# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetSpacesBucketObjectResult:
    """
    A collection of values returned by getSpacesBucketObject.
    """
    def __init__(__self__, body=None, bucket=None, cache_control=None, content_disposition=None, content_encoding=None, content_language=None, content_length=None, content_type=None, etag=None, expiration=None, expires=None, id=None, key=None, last_modified=None, metadata=None, range=None, region=None, version_id=None, website_redirect_location=None):
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        __self__.body = body
        """
        Object data (see **limitations above** to understand cases in which this field is actually available)
        """
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        __self__.bucket = bucket
        if cache_control and not isinstance(cache_control, str):
            raise TypeError("Expected argument 'cache_control' to be a str")
        __self__.cache_control = cache_control
        """
        Specifies caching behavior along the request/reply chain.
        """
        if content_disposition and not isinstance(content_disposition, str):
            raise TypeError("Expected argument 'content_disposition' to be a str")
        __self__.content_disposition = content_disposition
        """
        Specifies presentational information for the object.
        """
        if content_encoding and not isinstance(content_encoding, str):
            raise TypeError("Expected argument 'content_encoding' to be a str")
        __self__.content_encoding = content_encoding
        """
        Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.
        """
        if content_language and not isinstance(content_language, str):
            raise TypeError("Expected argument 'content_language' to be a str")
        __self__.content_language = content_language
        """
        The language the content is in.
        """
        if content_length and not isinstance(content_length, float):
            raise TypeError("Expected argument 'content_length' to be a float")
        __self__.content_length = content_length
        """
        Size of the body in bytes.
        """
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        __self__.content_type = content_type
        """
        A standard MIME type describing the format of the object data.
        """
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        __self__.etag = etag
        """
        [ETag](https://en.wikipedia.org/wiki/HTTP_ETag) generated for the object (an MD5 sum of the object content in case it's not encrypted)
        """
        if expiration and not isinstance(expiration, str):
            raise TypeError("Expected argument 'expiration' to be a str")
        __self__.expiration = expiration
        """
        If the object expiration is configured (see [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)), the field includes this header. It includes the expiry-date and rule-id key value pairs providing object expiration information. The value of the rule-id is URL encoded.
        """
        if expires and not isinstance(expires, str):
            raise TypeError("Expected argument 'expires' to be a str")
        __self__.expires = expires
        """
        The date and time at which the object is no longer cacheable.
        """
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        __self__.key = key
        if last_modified and not isinstance(last_modified, str):
            raise TypeError("Expected argument 'last_modified' to be a str")
        __self__.last_modified = last_modified
        """
        Last modified date of the object in RFC1123 format (e.g. `Mon, 02 Jan 2006 15:04:05 MST`)
        """
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        __self__.metadata = metadata
        """
        A map of metadata stored with the object in Spaces
        """
        if range and not isinstance(range, str):
            raise TypeError("Expected argument 'range' to be a str")
        __self__.range = range
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        __self__.region = region
        if version_id and not isinstance(version_id, str):
            raise TypeError("Expected argument 'version_id' to be a str")
        __self__.version_id = version_id
        """
        The latest version ID of the object returned.
        """
        if website_redirect_location and not isinstance(website_redirect_location, str):
            raise TypeError("Expected argument 'website_redirect_location' to be a str")
        __self__.website_redirect_location = website_redirect_location
        """
        If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Spaces stores the value of this header in the object metadata.
        """
class AwaitableGetSpacesBucketObjectResult(GetSpacesBucketObjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSpacesBucketObjectResult(
            body=self.body,
            bucket=self.bucket,
            cache_control=self.cache_control,
            content_disposition=self.content_disposition,
            content_encoding=self.content_encoding,
            content_language=self.content_language,
            content_length=self.content_length,
            content_type=self.content_type,
            etag=self.etag,
            expiration=self.expiration,
            expires=self.expires,
            id=self.id,
            key=self.key,
            last_modified=self.last_modified,
            metadata=self.metadata,
            range=self.range,
            region=self.region,
            version_id=self.version_id,
            website_redirect_location=self.website_redirect_location)

def get_spaces_bucket_object(bucket=None,key=None,range=None,region=None,version_id=None,opts=None):
    """
    The Spaces object data source allows access to the metadata and
    _optionally_ (see below) content of an object stored inside a Spaces bucket.

    > **Note:** The content of an object (`body` field) is available only for objects which have a human-readable
    `Content-Type` (`text/*` and `application/json`). This is to prevent printing unsafe characters and potentially
    downloading large amount of data which would be thrown away in favor of metadata.




    :param str bucket: The name of the bucket to read the object from.
    :param str key: The full path to the object inside the bucket
    :param str region: The slug of the region where the bucket is stored.
    :param str version_id: Specific version ID of the object returned (defaults to latest version)
    """
    __args__ = dict()


    __args__['bucket'] = bucket
    __args__['key'] = key
    __args__['range'] = range
    __args__['region'] = region
    __args__['versionId'] = version_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getSpacesBucketObject:getSpacesBucketObject', __args__, opts=opts).value

    return AwaitableGetSpacesBucketObjectResult(
        body=__ret__.get('body'),
        bucket=__ret__.get('bucket'),
        cache_control=__ret__.get('cacheControl'),
        content_disposition=__ret__.get('contentDisposition'),
        content_encoding=__ret__.get('contentEncoding'),
        content_language=__ret__.get('contentLanguage'),
        content_length=__ret__.get('contentLength'),
        content_type=__ret__.get('contentType'),
        etag=__ret__.get('etag'),
        expiration=__ret__.get('expiration'),
        expires=__ret__.get('expires'),
        id=__ret__.get('id'),
        key=__ret__.get('key'),
        last_modified=__ret__.get('lastModified'),
        metadata=__ret__.get('metadata'),
        range=__ret__.get('range'),
        region=__ret__.get('region'),
        version_id=__ret__.get('versionId'),
        website_redirect_location=__ret__.get('websiteRedirectLocation'))
