CMAKE_MINIMUM_REQUIRED(VERSION 2.6.3)

MACRO(NOW RESULT)
  IF(CMAKE_VERSION VERSION_GREATER "2.8.10")
    STRING(TIMESTAMP ${RESULT} "%Y%m%d")
  ELSE()
    IF(WIN32)
      EXECUTE_PROCESS(COMMAND "wmic" "os" "get" "localdatetime" OUTPUT_VARIABLE DATETIME)
      IF(NOT DATETIME MATCHES "ERROR")
        STRING(REGEX REPLACE ".*\n([0-9][0-9][0-9][0-9])([0-9][0-9])([0-9][0-9])([0-9][0-9])([0-9][0-9])([0-9][0-9]).*" "\\1-\\2-\\3 \\4:\\5:\\6" ${RESULT} "${DATETIME}")
      ENDIF()
    ELSEIF(UNIX)
      EXECUTE_PROCESS(COMMAND "date" "+%Y%m%d" OUTPUT_VARIABLE DATETIME)
      STRING(REGEX REPLACE "([0-9: -]+).*" "\\1" ${RESULT} "${DATETIME}")
    ELSE()
      MESSAGE(SEND_ERROR "date not implemented")
      SET(${RESULT} "00000000")
    ENDIF()
  ENDIF()
ENDMACRO()
