import { IVpc, GatewayVpcEndpoint } from '@aws-cdk/aws-ec2';
import { IAccessPoint } from '@aws-cdk/aws-efs';
import { PolicyStatement } from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
import { DefinitionBucket } from './definition-bucket';
export interface SandboxProps {
    readonly encryptedFileSystem?: boolean;
}
export declare class Sandbox extends Construct {
    readonly vpc: IVpc;
    readonly s3Endpoint: GatewayVpcEndpoint;
    readonly lambdaAccessPoint: IAccessPoint;
    readonly definitionBucket: DefinitionBucket;
    constructor(scope: Construct, id: string, props?: SandboxProps);
    addToS3EnpointPolicy(statement: PolicyStatement): void;
}
