> **BREAKING CHANGES** (pre-release)
>
> * `> v0.15.5`: updated defaults for UserPoolWithMfa will break deployments for already created userPools. If migrating to a newer version of this package, be sure to set the following in your `cdk.context.json`:
>
>   ```
>     {
>       "@aws-prototyping-sdk/identity:useLegacyMFAProps":true
>     }
>   ```

This module by default deploys a configurable Identity Provider with a default Cognito User Pool. These resources can be used by your website to restrict access to only authenticated users if needed. All settings are configurable and the creation of these AuthN resources can be disabled if needed or configured to use custom AuthN providers i.e. Facebook, Google, etc.

Below is a conceptual view of the default architecture this module creates:

```
Cognito User Pool --------------------> Identity Pool
     |_ User Pool Client                     |_ Unauthenticated IAM Role
                                             |_ Authenticated IAM Role
```

## Migrating Users

If you ever need to migrate users from one cognito user pool to another, you can use this helper utility: https://www.npmjs.com/package/cognito-backup-restore
# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### UserIdentity <a name="UserIdentity" id="@aws-prototyping-sdk/identity.UserIdentity"></a>

Creates a UserPool and Identity Pool with sane defaults configured intended for usage from a web client.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserIdentity(
  scope: Construct,
  id: str,
  identity_pool_options: IdentityPoolProps = None,
  user_pool: UserPool = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.identityPoolOptions">identity_pool_options</a></code> | <code>aws_cdk.aws_cognito_identitypool_alpha.IdentityPoolProps</code> | Configuration for the Identity Pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.userPool">user_pool</a></code> | <code>aws_cdk.aws_cognito.UserPool</code> | User provided Cognito UserPool. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.id"></a>

- *Type:* str

---

##### `identity_pool_options`<sup>Optional</sup> <a name="identity_pool_options" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.identityPoolOptions"></a>

- *Type:* aws_cdk.aws_cognito_identitypool_alpha.IdentityPoolProps

Configuration for the Identity Pool.

---

##### `user_pool`<sup>Optional</sup> <a name="user_pool" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.userPool"></a>

- *Type:* aws_cdk.aws_cognito.UserPool
- *Default:* a userpool with mfa will be created.

User provided Cognito UserPool.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.toString">to_string</a></code> | Returns a string representation of this construct. |

---

##### `to_string` <a name="to_string" id="@aws-prototyping-sdk/identity.UserIdentity.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### `is_construct` <a name="is_construct" id="@aws-prototyping-sdk/identity.UserIdentity.isConstruct"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserIdentity.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/identity.UserIdentity.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.identityPool">identity_pool</a></code> | <code>aws_cdk.aws_cognito_identitypool_alpha.IdentityPool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.userPool">user_pool</a></code> | <code>aws_cdk.aws_cognito.UserPool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.userPoolClient">user_pool_client</a></code> | <code>aws_cdk.aws_cognito.UserPoolClient</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/identity.UserIdentity.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `identity_pool`<sup>Required</sup> <a name="identity_pool" id="@aws-prototyping-sdk/identity.UserIdentity.property.identityPool"></a>

```python
identity_pool: IdentityPool
```

- *Type:* aws_cdk.aws_cognito_identitypool_alpha.IdentityPool

---

##### `user_pool`<sup>Required</sup> <a name="user_pool" id="@aws-prototyping-sdk/identity.UserIdentity.property.userPool"></a>

```python
user_pool: UserPool
```

- *Type:* aws_cdk.aws_cognito.UserPool

---

##### `user_pool_client`<sup>Required</sup> <a name="user_pool_client" id="@aws-prototyping-sdk/identity.UserIdentity.property.userPoolClient"></a>

```python
user_pool_client: UserPoolClient
```

- *Type:* aws_cdk.aws_cognito.UserPoolClient

---


### UserPoolWithMfa <a name="UserPoolWithMfa" id="@aws-prototyping-sdk/identity.UserPoolWithMfa"></a>

Configures a UserPool with MFA across SMS/TOTP using sane defaults.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserPoolWithMfa(
  scope: Construct,
  id: str,
  account_recovery: AccountRecovery = None,
  advanced_security_mode: AdvancedSecurityMode = None,
  auto_verify: AutoVerifiedAttrs = None,
  custom_attributes: typing.Mapping[ICustomAttribute] = None,
  custom_sender_kms_key: IKey = None,
  deletion_protection: bool = None,
  device_tracking: DeviceTracking = None,
  email: UserPoolEmail = None,
  enable_sms_role: bool = None,
  keep_original: KeepOriginalAttrs = None,
  lambda_triggers: UserPoolTriggers = None,
  mfa: Mfa = None,
  mfa_message: str = None,
  mfa_second_factor: MfaSecondFactor = None,
  password_policy: PasswordPolicy = None,
  removal_policy: RemovalPolicy = None,
  self_sign_up_enabled: bool = None,
  sign_in_aliases: SignInAliases = None,
  sign_in_case_sensitive: bool = None,
  sms_role: IRole = None,
  sms_role_external_id: str = None,
  sns_region: str = None,
  standard_attributes: StandardAttributes = None,
  user_invitation: UserInvitationConfig = None,
  user_pool_name: str = None,
  user_verification: UserVerificationConfig = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.accountRecovery">account_recovery</a></code> | <code>aws_cdk.aws_cognito.AccountRecovery</code> | How will a user be able to recover their account? |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.advancedSecurityMode">advanced_security_mode</a></code> | <code>aws_cdk.aws_cognito.AdvancedSecurityMode</code> | The user pool's Advanced Security Mode. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.autoVerify">auto_verify</a></code> | <code>aws_cdk.aws_cognito.AutoVerifiedAttrs</code> | Attributes which Cognito will look to verify automatically upon user sign up. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.customAttributes">custom_attributes</a></code> | <code>typing.Mapping[aws_cdk.aws_cognito.ICustomAttribute]</code> | Define a set of custom attributes that can be configured for each user in the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.customSenderKmsKey">custom_sender_kms_key</a></code> | <code>aws_cdk.aws_kms.IKey</code> | This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.deletionProtection">deletion_protection</a></code> | <code>bool</code> | Indicates whether the user pool should have deletion protection enabled. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.deviceTracking">device_tracking</a></code> | <code>aws_cdk.aws_cognito.DeviceTracking</code> | Device tracking settings. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.email">email</a></code> | <code>aws_cdk.aws_cognito.UserPoolEmail</code> | Email settings for a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.enableSmsRole">enable_sms_role</a></code> | <code>bool</code> | Setting this would explicitly enable or disable SMS role creation. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.keepOriginal">keep_original</a></code> | <code>aws_cdk.aws_cognito.KeepOriginalAttrs</code> | Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.lambdaTriggers">lambda_triggers</a></code> | <code>aws_cdk.aws_cognito.UserPoolTriggers</code> | Lambda functions to use for supported Cognito triggers. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfa">mfa</a></code> | <code>aws_cdk.aws_cognito.Mfa</code> | Configure whether users of this user pool can or are required use MFA to sign in. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfaMessage">mfa_message</a></code> | <code>str</code> | The SMS message template sent during MFA verification. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfaSecondFactor">mfa_second_factor</a></code> | <code>aws_cdk.aws_cognito.MfaSecondFactor</code> | Configure the MFA types that users can use in this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.passwordPolicy">password_policy</a></code> | <code>aws_cdk.aws_cognito.PasswordPolicy</code> | Password policy for this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.removalPolicy">removal_policy</a></code> | <code>aws_cdk.RemovalPolicy</code> | Policy to apply when the user pool is removed from the stack. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.selfSignUpEnabled">self_sign_up_enabled</a></code> | <code>bool</code> | Whether self sign up should be enabled. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.signInAliases">sign_in_aliases</a></code> | <code>aws_cdk.aws_cognito.SignInAliases</code> | Methods in which a user registers or signs in to a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.signInCaseSensitive">sign_in_case_sensitive</a></code> | <code>bool</code> | Whether sign-in aliases should be evaluated with case sensitivity. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.smsRole">sms_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | The IAM role that Cognito will assume while sending SMS messages. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.smsRoleExternalId">sms_role_external_id</a></code> | <code>str</code> | The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.snsRegion">sns_region</a></code> | <code>str</code> | The region to integrate with SNS to send SMS messages. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.standardAttributes">standard_attributes</a></code> | <code>aws_cdk.aws_cognito.StandardAttributes</code> | The set of attributes that are required for every user in the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userInvitation">user_invitation</a></code> | <code>aws_cdk.aws_cognito.UserInvitationConfig</code> | Configuration around admins signing up users into a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userPoolName">user_pool_name</a></code> | <code>str</code> | Name of the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userVerification">user_verification</a></code> | <code>aws_cdk.aws_cognito.UserVerificationConfig</code> | Configuration around users signing themselves up to the user pool. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.id"></a>

- *Type:* str

---

##### `account_recovery`<sup>Optional</sup> <a name="account_recovery" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.accountRecovery"></a>

- *Type:* aws_cdk.aws_cognito.AccountRecovery
- *Default:* AccountRecovery.PHONE_WITHOUT_MFA_AND_EMAIL

How will a user be able to recover their account?

---

##### `advanced_security_mode`<sup>Optional</sup> <a name="advanced_security_mode" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.advancedSecurityMode"></a>

- *Type:* aws_cdk.aws_cognito.AdvancedSecurityMode
- *Default:* no value

The user pool's Advanced Security Mode.

---

##### `auto_verify`<sup>Optional</sup> <a name="auto_verify" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.autoVerify"></a>

- *Type:* aws_cdk.aws_cognito.AutoVerifiedAttrs
- *Default:* If `signInAlias` includes email and/or phone, they will be included in `autoVerifiedAttributes` by default. If absent, no attributes will be auto-verified.

Attributes which Cognito will look to verify automatically upon user sign up.

EMAIL and PHONE are the only available options.

---

##### `custom_attributes`<sup>Optional</sup> <a name="custom_attributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.customAttributes"></a>

- *Type:* typing.Mapping[aws_cdk.aws_cognito.ICustomAttribute]
- *Default:* No custom attributes.

Define a set of custom attributes that can be configured for each user in the user pool.

---

##### `custom_sender_kms_key`<sup>Optional</sup> <a name="custom_sender_kms_key" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.customSenderKmsKey"></a>

- *Type:* aws_cdk.aws_kms.IKey
- *Default:* no key ID configured

This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html)

---

##### `deletion_protection`<sup>Optional</sup> <a name="deletion_protection" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.deletionProtection"></a>

- *Type:* bool
- *Default:* false

Indicates whether the user pool should have deletion protection enabled.

---

##### `device_tracking`<sup>Optional</sup> <a name="device_tracking" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.deviceTracking"></a>

- *Type:* aws_cdk.aws_cognito.DeviceTracking
- *Default:* see defaults on each property of DeviceTracking.

Device tracking settings.

---

##### `email`<sup>Optional</sup> <a name="email" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.email"></a>

- *Type:* aws_cdk.aws_cognito.UserPoolEmail
- *Default:* cognito will use the default email configuration

Email settings for a user pool.

---

##### `enable_sms_role`<sup>Optional</sup> <a name="enable_sms_role" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.enableSmsRole"></a>

- *Type:* bool
- *Default:* CDK will determine based on other properties of the user pool if an SMS role should be created or not.

Setting this would explicitly enable or disable SMS role creation.

When left unspecified, CDK will determine based on other properties if a role is needed or not.

---

##### `keep_original`<sup>Optional</sup> <a name="keep_original" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.keepOriginal"></a>

- *Type:* aws_cdk.aws_cognito.KeepOriginalAttrs
- *Default:* Nothing is kept.

Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes.

EMAIL and PHONE are the only available options.

---

##### `lambda_triggers`<sup>Optional</sup> <a name="lambda_triggers" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.lambdaTriggers"></a>

- *Type:* aws_cdk.aws_cognito.UserPoolTriggers
- *Default:* No Lambda triggers.

Lambda functions to use for supported Cognito triggers.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)

---

##### `mfa`<sup>Optional</sup> <a name="mfa" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfa"></a>

- *Type:* aws_cdk.aws_cognito.Mfa
- *Default:* Mfa.OFF

Configure whether users of this user pool can or are required use MFA to sign in.

---

##### `mfa_message`<sup>Optional</sup> <a name="mfa_message" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfaMessage"></a>

- *Type:* str
- *Default:* 'Your authentication code is {####}.'

The SMS message template sent during MFA verification.

Use '{####}' in the template where Cognito should insert the verification code.

---

##### `mfa_second_factor`<sup>Optional</sup> <a name="mfa_second_factor" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.mfaSecondFactor"></a>

- *Type:* aws_cdk.aws_cognito.MfaSecondFactor
- *Default:* { sms: true, otp: false }, if `mfa` is set to `OPTIONAL` or `REQUIRED`. { sms: false, otp: false }, otherwise

Configure the MFA types that users can use in this user pool.

Ignored if `mfa` is set to `OFF`.

---

##### `password_policy`<sup>Optional</sup> <a name="password_policy" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.passwordPolicy"></a>

- *Type:* aws_cdk.aws_cognito.PasswordPolicy
- *Default:* see defaults on each property of PasswordPolicy.

Password policy for this user pool.

---

##### `removal_policy`<sup>Optional</sup> <a name="removal_policy" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.removalPolicy"></a>

- *Type:* aws_cdk.RemovalPolicy
- *Default:* RemovalPolicy.RETAIN

Policy to apply when the user pool is removed from the stack.

---

##### `self_sign_up_enabled`<sup>Optional</sup> <a name="self_sign_up_enabled" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.selfSignUpEnabled"></a>

- *Type:* bool
- *Default:* false

Whether self sign up should be enabled.

This can be further configured via the `selfSignUp` property.

---

##### `sign_in_aliases`<sup>Optional</sup> <a name="sign_in_aliases" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.signInAliases"></a>

- *Type:* aws_cdk.aws_cognito.SignInAliases
- *Default:* { username: true }

Methods in which a user registers or signs in to a user pool.

Allows either username with aliases OR sign in with email, phone, or both.

Read the sections on usernames and aliases to learn more -
https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html

To match with 'Option 1' in the above link, with a verified email, this property should be set to
`{ username: true, email: true }`. To match with 'Option 2' in the above link with both a verified email and phone
number, this property should be set to `{ email: true, phone: true }`.

---

##### `sign_in_case_sensitive`<sup>Optional</sup> <a name="sign_in_case_sensitive" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.signInCaseSensitive"></a>

- *Type:* bool
- *Default:* true

Whether sign-in aliases should be evaluated with case sensitivity.

For example, when this option is set to false, users will be able to sign in using either `MyUsername` or `myusername`.

---

##### `sms_role`<sup>Optional</sup> <a name="sms_role" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.smsRole"></a>

- *Type:* aws_cdk.aws_iam.IRole
- *Default:* a new IAM role is created

The IAM role that Cognito will assume while sending SMS messages.

---

##### `sms_role_external_id`<sup>Optional</sup> <a name="sms_role_external_id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.smsRoleExternalId"></a>

- *Type:* str
- *Default:* No external id will be configured

The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional.

Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html

This property will be ignored if `smsRole` is not specified.

---

##### `sns_region`<sup>Optional</sup> <a name="sns_region" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.snsRegion"></a>

- *Type:* str
- *Default:* The same region as the user pool, with a few exceptions - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html#user-pool-sms-settings-first-time

The region to integrate with SNS to send SMS messages.

This property will do nothing if SMS configuration is not configured

---

##### `standard_attributes`<sup>Optional</sup> <a name="standard_attributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.standardAttributes"></a>

- *Type:* aws_cdk.aws_cognito.StandardAttributes
- *Default:* All standard attributes are optional and mutable.

The set of attributes that are required for every user in the user pool.

Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html

---

##### `user_invitation`<sup>Optional</sup> <a name="user_invitation" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userInvitation"></a>

- *Type:* aws_cdk.aws_cognito.UserInvitationConfig
- *Default:* see defaults in UserInvitationConfig

Configuration around admins signing up users into a user pool.

---

##### `user_pool_name`<sup>Optional</sup> <a name="user_pool_name" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userPoolName"></a>

- *Type:* str
- *Default:* automatically generated name by CloudFormation at deploy time

Name of the user pool.

---

##### `user_verification`<sup>Optional</sup> <a name="user_verification" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.userVerification"></a>

- *Type:* aws_cdk.aws_cognito.UserVerificationConfig
- *Default:* see defaults in UserVerificationConfig

Configuration around users signing themselves up to the user pool.

Enable or disable self sign-up via the `selfSignUpEnabled` property.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.applyRemovalPolicy">apply_removal_policy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient">add_client</a></code> | Add a new app client to this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain">add_domain</a></code> | Associate a domain to this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer">add_resource_server</a></code> | Add a new resource server to this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger">add_trigger</a></code> | Add a lambda trigger to a user pool operation. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.grant">grant</a></code> | Adds an IAM policy statement associated with this user pool to an IAM principal's policy. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.registerIdentityProvider">register_identity_provider</a></code> | Register an identity provider with this user pool. |

---

##### `to_string` <a name="to_string" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `apply_removal_policy` <a name="apply_removal_policy" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.applyRemovalPolicy"></a>

```python
def apply_removal_policy(
  policy: RemovalPolicy
) -> None
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws_cdk.RemovalPolicy

---

##### `add_client` <a name="add_client" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient"></a>

```python
def add_client(
  id: str,
  access_token_validity: Duration = None,
  auth_flows: AuthFlow = None,
  auth_session_validity: Duration = None,
  disable_o_auth: bool = None,
  enable_token_revocation: bool = None,
  generate_secret: bool = None,
  id_token_validity: Duration = None,
  o_auth: OAuthSettings = None,
  prevent_user_existence_errors: bool = None,
  read_attributes: ClientAttributes = None,
  refresh_token_validity: Duration = None,
  supported_identity_providers: typing.List[UserPoolClientIdentityProvider] = None,
  user_pool_client_name: str = None,
  write_attributes: ClientAttributes = None
) -> UserPoolClient
```

Add a new app client to this user pool.

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.id"></a>

- *Type:* str

---

###### `access_token_validity`<sup>Optional</sup> <a name="access_token_validity" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.accessTokenValidity"></a>

- *Type:* aws_cdk.Duration
- *Default:* Duration.minutes(60)

Validity of the access token.

Values between 5 minutes and 1 day are valid. The duration can not be longer than the refresh token validity.

> [https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-access-token](https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-access-token)

---

###### `auth_flows`<sup>Optional</sup> <a name="auth_flows" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.authFlows"></a>

- *Type:* aws_cdk.aws_cognito.AuthFlow
- *Default:* all auth flows disabled

The set of OAuth authentication flows to enable on the client.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html](https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html)

---

###### `auth_session_validity`<sup>Optional</sup> <a name="auth_session_validity" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.authSessionValidity"></a>

- *Type:* aws_cdk.Duration
- *Default:* Duration.minutes(3)

Cognito creates a session token for each API request in an authentication flow.

AuthSessionValidity is the duration, in minutes, of that session token.
see defaults in `AuthSessionValidity`. Valid duration is from 3 to 15 minutes.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-authsessionvalidity](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-authsessionvalidity)

---

###### `disable_o_auth`<sup>Optional</sup> <a name="disable_o_auth" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.disableOAuth"></a>

- *Type:* bool
- *Default:* false

Turns off all OAuth interactions for this client.

---

###### `enable_token_revocation`<sup>Optional</sup> <a name="enable_token_revocation" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.enableTokenRevocation"></a>

- *Type:* bool
- *Default:* true for new user pool clients

Enable token revocation for this client.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/token-revocation.html#enable-token-revocation](https://docs.aws.amazon.com/cognito/latest/developerguide/token-revocation.html#enable-token-revocation)

---

###### `generate_secret`<sup>Optional</sup> <a name="generate_secret" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.generateSecret"></a>

- *Type:* bool
- *Default:* false

Whether to generate a client secret.

---

###### `id_token_validity`<sup>Optional</sup> <a name="id_token_validity" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.idTokenValidity"></a>

- *Type:* aws_cdk.Duration
- *Default:* Duration.minutes(60)

Validity of the ID token.

Values between 5 minutes and 1 day are valid. The duration can not be longer than the refresh token validity.

> [https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-id-token](https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-id-token)

---

###### `o_auth`<sup>Optional</sup> <a name="o_auth" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.oAuth"></a>

- *Type:* aws_cdk.aws_cognito.OAuthSettings
- *Default:* see defaults in `OAuthSettings`. meaningless if `disableOAuth` is set.

OAuth settings for this client to interact with the app.

An error is thrown when this is specified and `disableOAuth` is set.

---

###### `prevent_user_existence_errors`<sup>Optional</sup> <a name="prevent_user_existence_errors" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.preventUserExistenceErrors"></a>

- *Type:* bool
- *Default:* false

Whether Cognito returns a UserNotFoundException exception when the user does not exist in the user pool (false), or whether it returns another type of error that doesn't reveal the user's absence.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-managing-errors.html](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-managing-errors.html)

---

###### `read_attributes`<sup>Optional</sup> <a name="read_attributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.readAttributes"></a>

- *Type:* aws_cdk.aws_cognito.ClientAttributes
- *Default:* all standard and custom attributes

The set of attributes this client will be able to read.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes)

---

###### `refresh_token_validity`<sup>Optional</sup> <a name="refresh_token_validity" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.refreshTokenValidity"></a>

- *Type:* aws_cdk.Duration
- *Default:* Duration.days(30)

Validity of the refresh token.

Values between 60 minutes and 10 years are valid.

> [https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-refresh-token](https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-refresh-token)

---

###### `supported_identity_providers`<sup>Optional</sup> <a name="supported_identity_providers" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.supportedIdentityProviders"></a>

- *Type:* typing.List[aws_cdk.aws_cognito.UserPoolClientIdentityProvider]
- *Default:* supports all identity providers that are registered with the user pool. If the user pool and/or identity providers are imported, either specify this option explicitly or ensure that the identity providers are registered with the user pool using the `UserPool.registerIdentityProvider()` API.

The list of identity providers that users should be able to use to sign in using this client.

---

###### `user_pool_client_name`<sup>Optional</sup> <a name="user_pool_client_name" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.userPoolClientName"></a>

- *Type:* str
- *Default:* cloudformation generated name

Name of the application client.

---

###### `write_attributes`<sup>Optional</sup> <a name="write_attributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.writeAttributes"></a>

- *Type:* aws_cdk.aws_cognito.ClientAttributes
- *Default:* all standard and custom attributes

The set of attributes this client will be able to write.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes)

---

##### `add_domain` <a name="add_domain" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain"></a>

```python
def add_domain(
  id: str,
  cognito_domain: CognitoDomainOptions = None,
  custom_domain: CustomDomainOptions = None
) -> UserPoolDomain
```

Associate a domain to this user pool.

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain.parameter.id"></a>

- *Type:* str

---

###### `cognito_domain`<sup>Optional</sup> <a name="cognito_domain" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain.parameter.cognitoDomain"></a>

- *Type:* aws_cdk.aws_cognito.CognitoDomainOptions
- *Default:* not set if `customDomain` is specified, otherwise, throws an error.

Associate a cognito prefix domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html)

---

###### `custom_domain`<sup>Optional</sup> <a name="custom_domain" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain.parameter.customDomain"></a>

- *Type:* aws_cdk.aws_cognito.CustomDomainOptions
- *Default:* not set if `cognitoDomain` is specified, otherwise, throws an error.

Associate a custom domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html)

---

##### `add_resource_server` <a name="add_resource_server" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer"></a>

```python
def add_resource_server(
  id: str,
  identifier: str,
  scopes: typing.List[ResourceServerScope] = None,
  user_pool_resource_server_name: str = None
) -> UserPoolResourceServer
```

Add a new resource server to this user pool.

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer.parameter.id"></a>

- *Type:* str

---

###### `identifier`<sup>Required</sup> <a name="identifier" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer.parameter.identifier"></a>

- *Type:* str

A unique resource server identifier for the resource server.

---

###### `scopes`<sup>Optional</sup> <a name="scopes" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer.parameter.scopes"></a>

- *Type:* typing.List[aws_cdk.aws_cognito.ResourceServerScope]
- *Default:* No scopes will be added

Oauth scopes.

---

###### `user_pool_resource_server_name`<sup>Optional</sup> <a name="user_pool_resource_server_name" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer.parameter.userPoolResourceServerName"></a>

- *Type:* str
- *Default:* same as `identifier`

A friendly name for the resource server.

---

##### `add_trigger` <a name="add_trigger" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger"></a>

```python
def add_trigger(
  operation: UserPoolOperation,
  fn: IFunction
) -> None
```

Add a lambda trigger to a user pool operation.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)

###### `operation`<sup>Required</sup> <a name="operation" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger.parameter.operation"></a>

- *Type:* aws_cdk.aws_cognito.UserPoolOperation

---

###### `fn`<sup>Required</sup> <a name="fn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger.parameter.fn"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `grant` <a name="grant" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.grant"></a>

```python
def grant(
  grantee: IGrantable,
  actions: str
) -> Grant
```

Adds an IAM policy statement associated with this user pool to an IAM principal's policy.

###### `grantee`<sup>Required</sup> <a name="grantee" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.grant.parameter.grantee"></a>

- *Type:* aws_cdk.aws_iam.IGrantable

---

###### `actions`<sup>Required</sup> <a name="actions" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.grant.parameter.actions"></a>

- *Type:* str

---

##### `register_identity_provider` <a name="register_identity_provider" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.registerIdentityProvider"></a>

```python
def register_identity_provider(
  provider: IUserPoolIdentityProvider
) -> None
```

Register an identity provider with this user pool.

###### `provider`<sup>Required</sup> <a name="provider" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.registerIdentityProvider.parameter.provider"></a>

- *Type:* aws_cdk.aws_cognito.IUserPoolIdentityProvider

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.isOwnedResource">is_owned_resource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.isResource">is_resource</a></code> | Check whether the given construct is a Resource. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn">from_user_pool_arn</a></code> | Import an existing user pool based on its ARN. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId">from_user_pool_id</a></code> | Import an existing user pool based on its id. |

---

##### `is_construct` <a name="is_construct" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isConstruct"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserPoolWithMfa.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

##### `is_owned_resource` <a name="is_owned_resource" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isOwnedResource"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserPoolWithMfa.is_owned_resource(
  construct: IConstruct
)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `is_resource` <a name="is_resource" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isResource"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserPoolWithMfa.is_resource(
  construct: IConstruct
)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `from_user_pool_arn` <a name="from_user_pool_arn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserPoolWithMfa.from_user_pool_arn(
  scope: Construct,
  id: str,
  user_pool_arn: str
)
```

Import an existing user pool based on its ARN.

###### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn.parameter.scope"></a>

- *Type:* constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn.parameter.id"></a>

- *Type:* str

---

###### `user_pool_arn`<sup>Required</sup> <a name="user_pool_arn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn.parameter.userPoolArn"></a>

- *Type:* str

---

##### `from_user_pool_id` <a name="from_user_pool_id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserPoolWithMfa.from_user_pool_id(
  scope: Construct,
  id: str,
  user_pool_id: str
)
```

Import an existing user pool based on its id.

###### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId.parameter.scope"></a>

- *Type:* constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId.parameter.id"></a>

- *Type:* str

---

###### `user_pool_id`<sup>Required</sup> <a name="user_pool_id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId.parameter.userPoolId"></a>

- *Type:* str

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.env">env</a></code> | <code>aws_cdk.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.stack">stack</a></code> | <code>aws_cdk.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.identityProviders">identity_providers</a></code> | <code>typing.List[aws_cdk.aws_cognito.IUserPoolIdentityProvider]</code> | Get all identity providers registered with this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolArn">user_pool_arn</a></code> | <code>str</code> | The ARN of the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolId">user_pool_id</a></code> | <code>str</code> | The physical ID of this user pool resource. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderName">user_pool_provider_name</a></code> | <code>str</code> | User pool provider name. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderUrl">user_pool_provider_url</a></code> | <code>str</code> | User pool provider URL. |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.env"></a>

```python
env: ResourceEnvironment
```

- *Type:* aws_cdk.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.stack"></a>

```python
stack: Stack
```

- *Type:* aws_cdk.Stack

The stack in which this resource is defined.

---

##### `identity_providers`<sup>Required</sup> <a name="identity_providers" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.identityProviders"></a>

```python
identity_providers: typing.List[IUserPoolIdentityProvider]
```

- *Type:* typing.List[aws_cdk.aws_cognito.IUserPoolIdentityProvider]

Get all identity providers registered with this user pool.

---

##### `user_pool_arn`<sup>Required</sup> <a name="user_pool_arn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolArn"></a>

```python
user_pool_arn: str
```

- *Type:* str

The ARN of the user pool.

---

##### `user_pool_id`<sup>Required</sup> <a name="user_pool_id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolId"></a>

```python
user_pool_id: str
```

- *Type:* str

The physical ID of this user pool resource.

---

##### `user_pool_provider_name`<sup>Required</sup> <a name="user_pool_provider_name" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderName"></a>

```python
user_pool_provider_name: str
```

- *Type:* str

User pool provider name.

---

##### `user_pool_provider_url`<sup>Required</sup> <a name="user_pool_provider_url" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderUrl"></a>

```python
user_pool_provider_url: str
```

- *Type:* str

User pool provider URL.

---


## Structs <a name="Structs" id="Structs"></a>

### UserIdentityProps <a name="UserIdentityProps" id="@aws-prototyping-sdk/identity.UserIdentityProps"></a>

Properties which configures the Identity Pool.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/identity.UserIdentityProps.Initializer"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserIdentityProps(
  identity_pool_options: IdentityPoolProps = None,
  user_pool: UserPool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentityProps.property.identityPoolOptions">identity_pool_options</a></code> | <code>aws_cdk.aws_cognito_identitypool_alpha.IdentityPoolProps</code> | Configuration for the Identity Pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentityProps.property.userPool">user_pool</a></code> | <code>aws_cdk.aws_cognito.UserPool</code> | User provided Cognito UserPool. |

---

##### `identity_pool_options`<sup>Optional</sup> <a name="identity_pool_options" id="@aws-prototyping-sdk/identity.UserIdentityProps.property.identityPoolOptions"></a>

```python
identity_pool_options: IdentityPoolProps
```

- *Type:* aws_cdk.aws_cognito_identitypool_alpha.IdentityPoolProps

Configuration for the Identity Pool.

---

##### `user_pool`<sup>Optional</sup> <a name="user_pool" id="@aws-prototyping-sdk/identity.UserIdentityProps.property.userPool"></a>

```python
user_pool: UserPool
```

- *Type:* aws_cdk.aws_cognito.UserPool
- *Default:* a userpool with mfa will be created.

User provided Cognito UserPool.

---

### UserPoolWithMfaProps <a name="UserPoolWithMfaProps" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps"></a>

UserPoolWithMfa props.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.Initializer"></a>

```python
import aws_prototyping_sdk.identity

aws_prototyping_sdk.identity.UserPoolWithMfaProps(
  account_recovery: AccountRecovery = None,
  advanced_security_mode: AdvancedSecurityMode = None,
  auto_verify: AutoVerifiedAttrs = None,
  custom_attributes: typing.Mapping[ICustomAttribute] = None,
  custom_sender_kms_key: IKey = None,
  deletion_protection: bool = None,
  device_tracking: DeviceTracking = None,
  email: UserPoolEmail = None,
  enable_sms_role: bool = None,
  keep_original: KeepOriginalAttrs = None,
  lambda_triggers: UserPoolTriggers = None,
  mfa: Mfa = None,
  mfa_message: str = None,
  mfa_second_factor: MfaSecondFactor = None,
  password_policy: PasswordPolicy = None,
  removal_policy: RemovalPolicy = None,
  self_sign_up_enabled: bool = None,
  sign_in_aliases: SignInAliases = None,
  sign_in_case_sensitive: bool = None,
  sms_role: IRole = None,
  sms_role_external_id: str = None,
  sns_region: str = None,
  standard_attributes: StandardAttributes = None,
  user_invitation: UserInvitationConfig = None,
  user_pool_name: str = None,
  user_verification: UserVerificationConfig = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.accountRecovery">account_recovery</a></code> | <code>aws_cdk.aws_cognito.AccountRecovery</code> | How will a user be able to recover their account? |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.advancedSecurityMode">advanced_security_mode</a></code> | <code>aws_cdk.aws_cognito.AdvancedSecurityMode</code> | The user pool's Advanced Security Mode. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.autoVerify">auto_verify</a></code> | <code>aws_cdk.aws_cognito.AutoVerifiedAttrs</code> | Attributes which Cognito will look to verify automatically upon user sign up. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customAttributes">custom_attributes</a></code> | <code>typing.Mapping[aws_cdk.aws_cognito.ICustomAttribute]</code> | Define a set of custom attributes that can be configured for each user in the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customSenderKmsKey">custom_sender_kms_key</a></code> | <code>aws_cdk.aws_kms.IKey</code> | This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deletionProtection">deletion_protection</a></code> | <code>bool</code> | Indicates whether the user pool should have deletion protection enabled. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deviceTracking">device_tracking</a></code> | <code>aws_cdk.aws_cognito.DeviceTracking</code> | Device tracking settings. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.email">email</a></code> | <code>aws_cdk.aws_cognito.UserPoolEmail</code> | Email settings for a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.enableSmsRole">enable_sms_role</a></code> | <code>bool</code> | Setting this would explicitly enable or disable SMS role creation. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.keepOriginal">keep_original</a></code> | <code>aws_cdk.aws_cognito.KeepOriginalAttrs</code> | Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.lambdaTriggers">lambda_triggers</a></code> | <code>aws_cdk.aws_cognito.UserPoolTriggers</code> | Lambda functions to use for supported Cognito triggers. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfa">mfa</a></code> | <code>aws_cdk.aws_cognito.Mfa</code> | Configure whether users of this user pool can or are required use MFA to sign in. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaMessage">mfa_message</a></code> | <code>str</code> | The SMS message template sent during MFA verification. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaSecondFactor">mfa_second_factor</a></code> | <code>aws_cdk.aws_cognito.MfaSecondFactor</code> | Configure the MFA types that users can use in this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.passwordPolicy">password_policy</a></code> | <code>aws_cdk.aws_cognito.PasswordPolicy</code> | Password policy for this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.removalPolicy">removal_policy</a></code> | <code>aws_cdk.RemovalPolicy</code> | Policy to apply when the user pool is removed from the stack. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.selfSignUpEnabled">self_sign_up_enabled</a></code> | <code>bool</code> | Whether self sign up should be enabled. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInAliases">sign_in_aliases</a></code> | <code>aws_cdk.aws_cognito.SignInAliases</code> | Methods in which a user registers or signs in to a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInCaseSensitive">sign_in_case_sensitive</a></code> | <code>bool</code> | Whether sign-in aliases should be evaluated with case sensitivity. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRole">sms_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | The IAM role that Cognito will assume while sending SMS messages. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRoleExternalId">sms_role_external_id</a></code> | <code>str</code> | The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.snsRegion">sns_region</a></code> | <code>str</code> | The region to integrate with SNS to send SMS messages. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.standardAttributes">standard_attributes</a></code> | <code>aws_cdk.aws_cognito.StandardAttributes</code> | The set of attributes that are required for every user in the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userInvitation">user_invitation</a></code> | <code>aws_cdk.aws_cognito.UserInvitationConfig</code> | Configuration around admins signing up users into a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userPoolName">user_pool_name</a></code> | <code>str</code> | Name of the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userVerification">user_verification</a></code> | <code>aws_cdk.aws_cognito.UserVerificationConfig</code> | Configuration around users signing themselves up to the user pool. |

---

##### `account_recovery`<sup>Optional</sup> <a name="account_recovery" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.accountRecovery"></a>

```python
account_recovery: AccountRecovery
```

- *Type:* aws_cdk.aws_cognito.AccountRecovery
- *Default:* AccountRecovery.PHONE_WITHOUT_MFA_AND_EMAIL

How will a user be able to recover their account?

---

##### `advanced_security_mode`<sup>Optional</sup> <a name="advanced_security_mode" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.advancedSecurityMode"></a>

```python
advanced_security_mode: AdvancedSecurityMode
```

- *Type:* aws_cdk.aws_cognito.AdvancedSecurityMode
- *Default:* no value

The user pool's Advanced Security Mode.

---

##### `auto_verify`<sup>Optional</sup> <a name="auto_verify" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.autoVerify"></a>

```python
auto_verify: AutoVerifiedAttrs
```

- *Type:* aws_cdk.aws_cognito.AutoVerifiedAttrs
- *Default:* If `signInAlias` includes email and/or phone, they will be included in `autoVerifiedAttributes` by default. If absent, no attributes will be auto-verified.

Attributes which Cognito will look to verify automatically upon user sign up.

EMAIL and PHONE are the only available options.

---

##### `custom_attributes`<sup>Optional</sup> <a name="custom_attributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customAttributes"></a>

```python
custom_attributes: typing.Mapping[ICustomAttribute]
```

- *Type:* typing.Mapping[aws_cdk.aws_cognito.ICustomAttribute]
- *Default:* No custom attributes.

Define a set of custom attributes that can be configured for each user in the user pool.

---

##### `custom_sender_kms_key`<sup>Optional</sup> <a name="custom_sender_kms_key" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customSenderKmsKey"></a>

```python
custom_sender_kms_key: IKey
```

- *Type:* aws_cdk.aws_kms.IKey
- *Default:* no key ID configured

This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html)

---

##### `deletion_protection`<sup>Optional</sup> <a name="deletion_protection" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deletionProtection"></a>

```python
deletion_protection: bool
```

- *Type:* bool
- *Default:* false

Indicates whether the user pool should have deletion protection enabled.

---

##### `device_tracking`<sup>Optional</sup> <a name="device_tracking" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deviceTracking"></a>

```python
device_tracking: DeviceTracking
```

- *Type:* aws_cdk.aws_cognito.DeviceTracking
- *Default:* see defaults on each property of DeviceTracking.

Device tracking settings.

---

##### `email`<sup>Optional</sup> <a name="email" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.email"></a>

```python
email: UserPoolEmail
```

- *Type:* aws_cdk.aws_cognito.UserPoolEmail
- *Default:* cognito will use the default email configuration

Email settings for a user pool.

---

##### `enable_sms_role`<sup>Optional</sup> <a name="enable_sms_role" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.enableSmsRole"></a>

```python
enable_sms_role: bool
```

- *Type:* bool
- *Default:* CDK will determine based on other properties of the user pool if an SMS role should be created or not.

Setting this would explicitly enable or disable SMS role creation.

When left unspecified, CDK will determine based on other properties if a role is needed or not.

---

##### `keep_original`<sup>Optional</sup> <a name="keep_original" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.keepOriginal"></a>

```python
keep_original: KeepOriginalAttrs
```

- *Type:* aws_cdk.aws_cognito.KeepOriginalAttrs
- *Default:* Nothing is kept.

Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes.

EMAIL and PHONE are the only available options.

---

##### `lambda_triggers`<sup>Optional</sup> <a name="lambda_triggers" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.lambdaTriggers"></a>

```python
lambda_triggers: UserPoolTriggers
```

- *Type:* aws_cdk.aws_cognito.UserPoolTriggers
- *Default:* No Lambda triggers.

Lambda functions to use for supported Cognito triggers.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)

---

##### `mfa`<sup>Optional</sup> <a name="mfa" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfa"></a>

```python
mfa: Mfa
```

- *Type:* aws_cdk.aws_cognito.Mfa
- *Default:* Mfa.OFF

Configure whether users of this user pool can or are required use MFA to sign in.

---

##### `mfa_message`<sup>Optional</sup> <a name="mfa_message" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaMessage"></a>

```python
mfa_message: str
```

- *Type:* str
- *Default:* 'Your authentication code is {####}.'

The SMS message template sent during MFA verification.

Use '{####}' in the template where Cognito should insert the verification code.

---

##### `mfa_second_factor`<sup>Optional</sup> <a name="mfa_second_factor" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaSecondFactor"></a>

```python
mfa_second_factor: MfaSecondFactor
```

- *Type:* aws_cdk.aws_cognito.MfaSecondFactor
- *Default:* { sms: true, otp: false }, if `mfa` is set to `OPTIONAL` or `REQUIRED`. { sms: false, otp: false }, otherwise

Configure the MFA types that users can use in this user pool.

Ignored if `mfa` is set to `OFF`.

---

##### `password_policy`<sup>Optional</sup> <a name="password_policy" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.passwordPolicy"></a>

```python
password_policy: PasswordPolicy
```

- *Type:* aws_cdk.aws_cognito.PasswordPolicy
- *Default:* see defaults on each property of PasswordPolicy.

Password policy for this user pool.

---

##### `removal_policy`<sup>Optional</sup> <a name="removal_policy" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.removalPolicy"></a>

```python
removal_policy: RemovalPolicy
```

- *Type:* aws_cdk.RemovalPolicy
- *Default:* RemovalPolicy.RETAIN

Policy to apply when the user pool is removed from the stack.

---

##### `self_sign_up_enabled`<sup>Optional</sup> <a name="self_sign_up_enabled" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.selfSignUpEnabled"></a>

```python
self_sign_up_enabled: bool
```

- *Type:* bool
- *Default:* false

Whether self sign up should be enabled.

This can be further configured via the `selfSignUp` property.

---

##### `sign_in_aliases`<sup>Optional</sup> <a name="sign_in_aliases" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInAliases"></a>

```python
sign_in_aliases: SignInAliases
```

- *Type:* aws_cdk.aws_cognito.SignInAliases
- *Default:* { username: true }

Methods in which a user registers or signs in to a user pool.

Allows either username with aliases OR sign in with email, phone, or both.

Read the sections on usernames and aliases to learn more -
https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html

To match with 'Option 1' in the above link, with a verified email, this property should be set to
`{ username: true, email: true }`. To match with 'Option 2' in the above link with both a verified email and phone
number, this property should be set to `{ email: true, phone: true }`.

---

##### `sign_in_case_sensitive`<sup>Optional</sup> <a name="sign_in_case_sensitive" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInCaseSensitive"></a>

```python
sign_in_case_sensitive: bool
```

- *Type:* bool
- *Default:* true

Whether sign-in aliases should be evaluated with case sensitivity.

For example, when this option is set to false, users will be able to sign in using either `MyUsername` or `myusername`.

---

##### `sms_role`<sup>Optional</sup> <a name="sms_role" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRole"></a>

```python
sms_role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole
- *Default:* a new IAM role is created

The IAM role that Cognito will assume while sending SMS messages.

---

##### `sms_role_external_id`<sup>Optional</sup> <a name="sms_role_external_id" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRoleExternalId"></a>

```python
sms_role_external_id: str
```

- *Type:* str
- *Default:* No external id will be configured

The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional.

Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html

This property will be ignored if `smsRole` is not specified.

---

##### `sns_region`<sup>Optional</sup> <a name="sns_region" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.snsRegion"></a>

```python
sns_region: str
```

- *Type:* str
- *Default:* The same region as the user pool, with a few exceptions - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html#user-pool-sms-settings-first-time

The region to integrate with SNS to send SMS messages.

This property will do nothing if SMS configuration is not configured

---

##### `standard_attributes`<sup>Optional</sup> <a name="standard_attributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.standardAttributes"></a>

```python
standard_attributes: StandardAttributes
```

- *Type:* aws_cdk.aws_cognito.StandardAttributes
- *Default:* All standard attributes are optional and mutable.

The set of attributes that are required for every user in the user pool.

Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html

---

##### `user_invitation`<sup>Optional</sup> <a name="user_invitation" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userInvitation"></a>

```python
user_invitation: UserInvitationConfig
```

- *Type:* aws_cdk.aws_cognito.UserInvitationConfig
- *Default:* see defaults in UserInvitationConfig

Configuration around admins signing up users into a user pool.

---

##### `user_pool_name`<sup>Optional</sup> <a name="user_pool_name" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userPoolName"></a>

```python
user_pool_name: str
```

- *Type:* str
- *Default:* automatically generated name by CloudFormation at deploy time

Name of the user pool.

---

##### `user_verification`<sup>Optional</sup> <a name="user_verification" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userVerification"></a>

```python
user_verification: UserVerificationConfig
```

- *Type:* aws_cdk.aws_cognito.UserVerificationConfig
- *Default:* see defaults in UserVerificationConfig

Configuration around users signing themselves up to the user pool.

Enable or disable self sign-up via the `selfSignUpEnabled` property.

---



