> **BREAKING CHANGES** (pre-release)
> - `> v0.15.5`: updated defaults for UserPoolWithMfa will break deployments for already created userPools. If migrating to a newer version of this package, be sure to set the following in your `cdk.context.json`:
>
>
>   ```
>     {
>       "@aws-prototyping-sdk/identity:useLegacyMFAProps":true
>     }
>   ```

This module by default deploys a configurable Identity Provider with a default Cognito User Pool. These resources can be used by your website to restrict access to only authenticated users if needed. All settings are configurable and the creation of these AuthN resources can be disabled if needed or configured to use custom AuthN providers i.e. Facebook, Google, etc.

Below is a conceptual view of the default architecture this module creates:

```
Cognito User Pool --------------------> Identity Pool
     |_ User Pool Client                     |_ Unauthenticated IAM Role
                                             |_ Authenticated IAM Role
```

## Migrating Users

If you ever need to migrate users from one cognito user pool to another, you can use this helper utility: https://www.npmjs.com/package/cognito-backup-restore
# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### UserIdentity <a name="UserIdentity" id="@aws-prototyping-sdk/identity.UserIdentity"></a>

Creates a UserPool and Identity Pool with sane defaults configured intended for usage from a web client.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer"></a>

```typescript
import { UserIdentity } from '@aws-prototyping-sdk/identity'

new UserIdentity(scope: Construct, id: string, props?: UserIdentityProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.props">props</a></code> | <code><a href="#@aws-prototyping-sdk/identity.UserIdentityProps">UserIdentityProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/identity.UserIdentity.Initializer.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/identity.UserIdentityProps">UserIdentityProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/identity.UserIdentity.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/identity.UserIdentity.isConstruct"></a>

```typescript
import { UserIdentity } from '@aws-prototyping-sdk/identity'

UserIdentity.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/identity.UserIdentity.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.identityPool">identityPool</a></code> | <code>@aws-cdk/aws-cognito-identitypool-alpha.IdentityPool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.userPool">userPool</a></code> | <code>aws-cdk-lib.aws_cognito.UserPool</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentity.property.userPoolClient">userPoolClient</a></code> | <code>aws-cdk-lib.aws_cognito.UserPoolClient</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/identity.UserIdentity.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `identityPool`<sup>Required</sup> <a name="identityPool" id="@aws-prototyping-sdk/identity.UserIdentity.property.identityPool"></a>

```typescript
public readonly identityPool: IdentityPool;
```

- *Type:* @aws-cdk/aws-cognito-identitypool-alpha.IdentityPool

---

##### `userPool`<sup>Required</sup> <a name="userPool" id="@aws-prototyping-sdk/identity.UserIdentity.property.userPool"></a>

```typescript
public readonly userPool: UserPool;
```

- *Type:* aws-cdk-lib.aws_cognito.UserPool

---

##### `userPoolClient`<sup>Required</sup> <a name="userPoolClient" id="@aws-prototyping-sdk/identity.UserIdentity.property.userPoolClient"></a>

```typescript
public readonly userPoolClient: UserPoolClient;
```

- *Type:* aws-cdk-lib.aws_cognito.UserPoolClient

---


### UserPoolWithMfa <a name="UserPoolWithMfa" id="@aws-prototyping-sdk/identity.UserPoolWithMfa"></a>

Configures a UserPool with MFA across SMS/TOTP using sane defaults.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer"></a>

```typescript
import { UserPoolWithMfa } from '@aws-prototyping-sdk/identity'

new UserPoolWithMfa(scope: Construct, id: string, props?: UserPoolWithMfaProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.props">props</a></code> | <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps">UserPoolWithMfaProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Optional</sup> <a name="props" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.Initializer.parameter.props"></a>

- *Type:* <a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps">UserPoolWithMfaProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient">addClient</a></code> | Add a new app client to this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain">addDomain</a></code> | Associate a domain to this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer">addResourceServer</a></code> | Add a new resource server to this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger">addTrigger</a></code> | Add a lambda trigger to a user pool operation. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.grant">grant</a></code> | Adds an IAM policy statement associated with this user pool to an IAM principal's policy. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.registerIdentityProvider">registerIdentityProvider</a></code> | Register an identity provider with this user pool. |

---

##### `toString` <a name="toString" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addClient` <a name="addClient" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient"></a>

```typescript
public addClient(id: string, options?: UserPoolClientOptions): UserPoolClient
```

Add a new app client to this user pool.

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.id"></a>

- *Type:* string

---

###### `options`<sup>Optional</sup> <a name="options" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addClient.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_cognito.UserPoolClientOptions

---

##### `addDomain` <a name="addDomain" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain"></a>

```typescript
public addDomain(id: string, options: UserPoolDomainOptions): UserPoolDomain
```

Associate a domain to this user pool.

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain.parameter.id"></a>

- *Type:* string

---

###### `options`<sup>Required</sup> <a name="options" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addDomain.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_cognito.UserPoolDomainOptions

---

##### `addResourceServer` <a name="addResourceServer" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer"></a>

```typescript
public addResourceServer(id: string, options: UserPoolResourceServerOptions): UserPoolResourceServer
```

Add a new resource server to this user pool.

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer.parameter.id"></a>

- *Type:* string

---

###### `options`<sup>Required</sup> <a name="options" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addResourceServer.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_cognito.UserPoolResourceServerOptions

---

##### `addTrigger` <a name="addTrigger" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger"></a>

```typescript
public addTrigger(operation: UserPoolOperation, fn: IFunction): void
```

Add a lambda trigger to a user pool operation.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)

###### `operation`<sup>Required</sup> <a name="operation" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger.parameter.operation"></a>

- *Type:* aws-cdk-lib.aws_cognito.UserPoolOperation

---

###### `fn`<sup>Required</sup> <a name="fn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.addTrigger.parameter.fn"></a>

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `grant` <a name="grant" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.grant"></a>

```typescript
public grant(grantee: IGrantable, actions: string): Grant
```

Adds an IAM policy statement associated with this user pool to an IAM principal's policy.

###### `grantee`<sup>Required</sup> <a name="grantee" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.grant.parameter.grantee"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `actions`<sup>Required</sup> <a name="actions" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.grant.parameter.actions"></a>

- *Type:* string

---

##### `registerIdentityProvider` <a name="registerIdentityProvider" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.registerIdentityProvider"></a>

```typescript
public registerIdentityProvider(provider: IUserPoolIdentityProvider): void
```

Register an identity provider with this user pool.

###### `provider`<sup>Required</sup> <a name="provider" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.registerIdentityProvider.parameter.provider"></a>

- *Type:* aws-cdk-lib.aws_cognito.IUserPoolIdentityProvider

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.isResource">isResource</a></code> | Check whether the given construct is a Resource. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn">fromUserPoolArn</a></code> | Import an existing user pool based on its ARN. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId">fromUserPoolId</a></code> | Import an existing user pool based on its id. |

---

##### `isConstruct` <a name="isConstruct" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isConstruct"></a>

```typescript
import { UserPoolWithMfa } from '@aws-prototyping-sdk/identity'

UserPoolWithMfa.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isOwnedResource"></a>

```typescript
import { UserPoolWithMfa } from '@aws-prototyping-sdk/identity'

UserPoolWithMfa.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isResource"></a>

```typescript
import { UserPoolWithMfa } from '@aws-prototyping-sdk/identity'

UserPoolWithMfa.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `fromUserPoolArn` <a name="fromUserPoolArn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn"></a>

```typescript
import { UserPoolWithMfa } from '@aws-prototyping-sdk/identity'

UserPoolWithMfa.fromUserPoolArn(scope: Construct, id: string, userPoolArn: string)
```

Import an existing user pool based on its ARN.

###### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn.parameter.scope"></a>

- *Type:* constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn.parameter.id"></a>

- *Type:* string

---

###### `userPoolArn`<sup>Required</sup> <a name="userPoolArn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolArn.parameter.userPoolArn"></a>

- *Type:* string

---

##### `fromUserPoolId` <a name="fromUserPoolId" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId"></a>

```typescript
import { UserPoolWithMfa } from '@aws-prototyping-sdk/identity'

UserPoolWithMfa.fromUserPoolId(scope: Construct, id: string, userPoolId: string)
```

Import an existing user pool based on its id.

###### `scope`<sup>Required</sup> <a name="scope" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId.parameter.scope"></a>

- *Type:* constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId.parameter.id"></a>

- *Type:* string

---

###### `userPoolId`<sup>Required</sup> <a name="userPoolId" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.fromUserPoolId.parameter.userPoolId"></a>

- *Type:* string

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.identityProviders">identityProviders</a></code> | <code>aws-cdk-lib.aws_cognito.IUserPoolIdentityProvider[]</code> | Get all identity providers registered with this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolArn">userPoolArn</a></code> | <code>string</code> | The ARN of the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolId">userPoolId</a></code> | <code>string</code> | The physical ID of this user pool resource. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderName">userPoolProviderName</a></code> | <code>string</code> | User pool provider name. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderUrl">userPoolProviderUrl</a></code> | <code>string</code> | User pool provider URL. |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `identityProviders`<sup>Required</sup> <a name="identityProviders" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.identityProviders"></a>

```typescript
public readonly identityProviders: IUserPoolIdentityProvider[];
```

- *Type:* aws-cdk-lib.aws_cognito.IUserPoolIdentityProvider[]

Get all identity providers registered with this user pool.

---

##### `userPoolArn`<sup>Required</sup> <a name="userPoolArn" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolArn"></a>

```typescript
public readonly userPoolArn: string;
```

- *Type:* string

The ARN of the user pool.

---

##### `userPoolId`<sup>Required</sup> <a name="userPoolId" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolId"></a>

```typescript
public readonly userPoolId: string;
```

- *Type:* string

The physical ID of this user pool resource.

---

##### `userPoolProviderName`<sup>Required</sup> <a name="userPoolProviderName" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderName"></a>

```typescript
public readonly userPoolProviderName: string;
```

- *Type:* string

User pool provider name.

---

##### `userPoolProviderUrl`<sup>Required</sup> <a name="userPoolProviderUrl" id="@aws-prototyping-sdk/identity.UserPoolWithMfa.property.userPoolProviderUrl"></a>

```typescript
public readonly userPoolProviderUrl: string;
```

- *Type:* string

User pool provider URL.

---


## Structs <a name="Structs" id="Structs"></a>

### UserIdentityProps <a name="UserIdentityProps" id="@aws-prototyping-sdk/identity.UserIdentityProps"></a>

Properties which configures the Identity Pool.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/identity.UserIdentityProps.Initializer"></a>

```typescript
import { UserIdentityProps } from '@aws-prototyping-sdk/identity'

const userIdentityProps: UserIdentityProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentityProps.property.identityPoolOptions">identityPoolOptions</a></code> | <code>@aws-cdk/aws-cognito-identitypool-alpha.IdentityPoolProps</code> | Configuration for the Identity Pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserIdentityProps.property.userPool">userPool</a></code> | <code>aws-cdk-lib.aws_cognito.UserPool</code> | User provided Cognito UserPool. |

---

##### `identityPoolOptions`<sup>Optional</sup> <a name="identityPoolOptions" id="@aws-prototyping-sdk/identity.UserIdentityProps.property.identityPoolOptions"></a>

```typescript
public readonly identityPoolOptions: IdentityPoolProps;
```

- *Type:* @aws-cdk/aws-cognito-identitypool-alpha.IdentityPoolProps

Configuration for the Identity Pool.

---

##### `userPool`<sup>Optional</sup> <a name="userPool" id="@aws-prototyping-sdk/identity.UserIdentityProps.property.userPool"></a>

```typescript
public readonly userPool: UserPool;
```

- *Type:* aws-cdk-lib.aws_cognito.UserPool
- *Default:* a userpool with mfa will be created.

User provided Cognito UserPool.

---

### UserPoolWithMfaProps <a name="UserPoolWithMfaProps" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps"></a>

UserPoolWithMfa props.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.Initializer"></a>

```typescript
import { UserPoolWithMfaProps } from '@aws-prototyping-sdk/identity'

const userPoolWithMfaProps: UserPoolWithMfaProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.accountRecovery">accountRecovery</a></code> | <code>aws-cdk-lib.aws_cognito.AccountRecovery</code> | How will a user be able to recover their account? |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.advancedSecurityMode">advancedSecurityMode</a></code> | <code>aws-cdk-lib.aws_cognito.AdvancedSecurityMode</code> | The user pool's Advanced Security Mode. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.autoVerify">autoVerify</a></code> | <code>aws-cdk-lib.aws_cognito.AutoVerifiedAttrs</code> | Attributes which Cognito will look to verify automatically upon user sign up. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customAttributes">customAttributes</a></code> | <code>{[ key: string ]: aws-cdk-lib.aws_cognito.ICustomAttribute}</code> | Define a set of custom attributes that can be configured for each user in the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customSenderKmsKey">customSenderKmsKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deletionProtection">deletionProtection</a></code> | <code>boolean</code> | Indicates whether the user pool should have deletion protection enabled. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deviceTracking">deviceTracking</a></code> | <code>aws-cdk-lib.aws_cognito.DeviceTracking</code> | Device tracking settings. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.email">email</a></code> | <code>aws-cdk-lib.aws_cognito.UserPoolEmail</code> | Email settings for a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.enableSmsRole">enableSmsRole</a></code> | <code>boolean</code> | Setting this would explicitly enable or disable SMS role creation. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.keepOriginal">keepOriginal</a></code> | <code>aws-cdk-lib.aws_cognito.KeepOriginalAttrs</code> | Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.lambdaTriggers">lambdaTriggers</a></code> | <code>aws-cdk-lib.aws_cognito.UserPoolTriggers</code> | Lambda functions to use for supported Cognito triggers. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfa">mfa</a></code> | <code>aws-cdk-lib.aws_cognito.Mfa</code> | Configure whether users of this user pool can or are required use MFA to sign in. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaMessage">mfaMessage</a></code> | <code>string</code> | The SMS message template sent during MFA verification. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaSecondFactor">mfaSecondFactor</a></code> | <code>aws-cdk-lib.aws_cognito.MfaSecondFactor</code> | Configure the MFA types that users can use in this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.passwordPolicy">passwordPolicy</a></code> | <code>aws-cdk-lib.aws_cognito.PasswordPolicy</code> | Password policy for this user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.removalPolicy">removalPolicy</a></code> | <code>aws-cdk-lib.RemovalPolicy</code> | Policy to apply when the user pool is removed from the stack. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.selfSignUpEnabled">selfSignUpEnabled</a></code> | <code>boolean</code> | Whether self sign up should be enabled. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInAliases">signInAliases</a></code> | <code>aws-cdk-lib.aws_cognito.SignInAliases</code> | Methods in which a user registers or signs in to a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInCaseSensitive">signInCaseSensitive</a></code> | <code>boolean</code> | Whether sign-in aliases should be evaluated with case sensitivity. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRole">smsRole</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | The IAM role that Cognito will assume while sending SMS messages. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRoleExternalId">smsRoleExternalId</a></code> | <code>string</code> | The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.snsRegion">snsRegion</a></code> | <code>string</code> | The region to integrate with SNS to send SMS messages. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.standardAttributes">standardAttributes</a></code> | <code>aws-cdk-lib.aws_cognito.StandardAttributes</code> | The set of attributes that are required for every user in the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userInvitation">userInvitation</a></code> | <code>aws-cdk-lib.aws_cognito.UserInvitationConfig</code> | Configuration around admins signing up users into a user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userPoolName">userPoolName</a></code> | <code>string</code> | Name of the user pool. |
| <code><a href="#@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userVerification">userVerification</a></code> | <code>aws-cdk-lib.aws_cognito.UserVerificationConfig</code> | Configuration around users signing themselves up to the user pool. |

---

##### `accountRecovery`<sup>Optional</sup> <a name="accountRecovery" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.accountRecovery"></a>

```typescript
public readonly accountRecovery: AccountRecovery;
```

- *Type:* aws-cdk-lib.aws_cognito.AccountRecovery
- *Default:* AccountRecovery.PHONE_WITHOUT_MFA_AND_EMAIL

How will a user be able to recover their account?

---

##### `advancedSecurityMode`<sup>Optional</sup> <a name="advancedSecurityMode" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.advancedSecurityMode"></a>

```typescript
public readonly advancedSecurityMode: AdvancedSecurityMode;
```

- *Type:* aws-cdk-lib.aws_cognito.AdvancedSecurityMode
- *Default:* no value

The user pool's Advanced Security Mode.

---

##### `autoVerify`<sup>Optional</sup> <a name="autoVerify" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.autoVerify"></a>

```typescript
public readonly autoVerify: AutoVerifiedAttrs;
```

- *Type:* aws-cdk-lib.aws_cognito.AutoVerifiedAttrs
- *Default:* If `signInAlias` includes email and/or phone, they will be included in `autoVerifiedAttributes` by default. If absent, no attributes will be auto-verified.

Attributes which Cognito will look to verify automatically upon user sign up.

EMAIL and PHONE are the only available options.

---

##### `customAttributes`<sup>Optional</sup> <a name="customAttributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customAttributes"></a>

```typescript
public readonly customAttributes: {[ key: string ]: ICustomAttribute};
```

- *Type:* {[ key: string ]: aws-cdk-lib.aws_cognito.ICustomAttribute}
- *Default:* No custom attributes.

Define a set of custom attributes that can be configured for each user in the user pool.

---

##### `customSenderKmsKey`<sup>Optional</sup> <a name="customSenderKmsKey" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.customSenderKmsKey"></a>

```typescript
public readonly customSenderKmsKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey
- *Default:* no key ID configured

This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html)

---

##### `deletionProtection`<sup>Optional</sup> <a name="deletionProtection" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deletionProtection"></a>

```typescript
public readonly deletionProtection: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the user pool should have deletion protection enabled.

---

##### `deviceTracking`<sup>Optional</sup> <a name="deviceTracking" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.deviceTracking"></a>

```typescript
public readonly deviceTracking: DeviceTracking;
```

- *Type:* aws-cdk-lib.aws_cognito.DeviceTracking
- *Default:* see defaults on each property of DeviceTracking.

Device tracking settings.

---

##### `email`<sup>Optional</sup> <a name="email" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.email"></a>

```typescript
public readonly email: UserPoolEmail;
```

- *Type:* aws-cdk-lib.aws_cognito.UserPoolEmail
- *Default:* cognito will use the default email configuration

Email settings for a user pool.

---

##### `enableSmsRole`<sup>Optional</sup> <a name="enableSmsRole" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.enableSmsRole"></a>

```typescript
public readonly enableSmsRole: boolean;
```

- *Type:* boolean
- *Default:* CDK will determine based on other properties of the user pool if an SMS role should be created or not.

Setting this would explicitly enable or disable SMS role creation.

When left unspecified, CDK will determine based on other properties if a role is needed or not.

---

##### `keepOriginal`<sup>Optional</sup> <a name="keepOriginal" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.keepOriginal"></a>

```typescript
public readonly keepOriginal: KeepOriginalAttrs;
```

- *Type:* aws-cdk-lib.aws_cognito.KeepOriginalAttrs
- *Default:* Nothing is kept.

Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes.

EMAIL and PHONE are the only available options.

---

##### `lambdaTriggers`<sup>Optional</sup> <a name="lambdaTriggers" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.lambdaTriggers"></a>

```typescript
public readonly lambdaTriggers: UserPoolTriggers;
```

- *Type:* aws-cdk-lib.aws_cognito.UserPoolTriggers
- *Default:* No Lambda triggers.

Lambda functions to use for supported Cognito triggers.

> [https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)

---

##### `mfa`<sup>Optional</sup> <a name="mfa" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfa"></a>

```typescript
public readonly mfa: Mfa;
```

- *Type:* aws-cdk-lib.aws_cognito.Mfa
- *Default:* Mfa.OFF

Configure whether users of this user pool can or are required use MFA to sign in.

---

##### `mfaMessage`<sup>Optional</sup> <a name="mfaMessage" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaMessage"></a>

```typescript
public readonly mfaMessage: string;
```

- *Type:* string
- *Default:* 'Your authentication code is {####}.'

The SMS message template sent during MFA verification.

Use '{####}' in the template where Cognito should insert the verification code.

---

##### `mfaSecondFactor`<sup>Optional</sup> <a name="mfaSecondFactor" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.mfaSecondFactor"></a>

```typescript
public readonly mfaSecondFactor: MfaSecondFactor;
```

- *Type:* aws-cdk-lib.aws_cognito.MfaSecondFactor
- *Default:* { sms: true, otp: false }, if `mfa` is set to `OPTIONAL` or `REQUIRED`. { sms: false, otp: false }, otherwise

Configure the MFA types that users can use in this user pool.

Ignored if `mfa` is set to `OFF`.

---

##### `passwordPolicy`<sup>Optional</sup> <a name="passwordPolicy" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.passwordPolicy"></a>

```typescript
public readonly passwordPolicy: PasswordPolicy;
```

- *Type:* aws-cdk-lib.aws_cognito.PasswordPolicy
- *Default:* see defaults on each property of PasswordPolicy.

Password policy for this user pool.

---

##### `removalPolicy`<sup>Optional</sup> <a name="removalPolicy" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.removalPolicy"></a>

```typescript
public readonly removalPolicy: RemovalPolicy;
```

- *Type:* aws-cdk-lib.RemovalPolicy
- *Default:* RemovalPolicy.RETAIN

Policy to apply when the user pool is removed from the stack.

---

##### `selfSignUpEnabled`<sup>Optional</sup> <a name="selfSignUpEnabled" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.selfSignUpEnabled"></a>

```typescript
public readonly selfSignUpEnabled: boolean;
```

- *Type:* boolean
- *Default:* false

Whether self sign up should be enabled.

This can be further configured via the `selfSignUp` property.

---

##### `signInAliases`<sup>Optional</sup> <a name="signInAliases" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInAliases"></a>

```typescript
public readonly signInAliases: SignInAliases;
```

- *Type:* aws-cdk-lib.aws_cognito.SignInAliases
- *Default:* { username: true }

Methods in which a user registers or signs in to a user pool.

Allows either username with aliases OR sign in with email, phone, or both.

Read the sections on usernames and aliases to learn more -
https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html

To match with 'Option 1' in the above link, with a verified email, this property should be set to
`{ username: true, email: true }`. To match with 'Option 2' in the above link with both a verified email and phone
number, this property should be set to `{ email: true, phone: true }`.

---

##### `signInCaseSensitive`<sup>Optional</sup> <a name="signInCaseSensitive" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.signInCaseSensitive"></a>

```typescript
public readonly signInCaseSensitive: boolean;
```

- *Type:* boolean
- *Default:* true

Whether sign-in aliases should be evaluated with case sensitivity.

For example, when this option is set to false, users will be able to sign in using either `MyUsername` or `myusername`.

---

##### `smsRole`<sup>Optional</sup> <a name="smsRole" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRole"></a>

```typescript
public readonly smsRole: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole
- *Default:* a new IAM role is created

The IAM role that Cognito will assume while sending SMS messages.

---

##### `smsRoleExternalId`<sup>Optional</sup> <a name="smsRoleExternalId" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.smsRoleExternalId"></a>

```typescript
public readonly smsRoleExternalId: string;
```

- *Type:* string
- *Default:* No external id will be configured

The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional.

Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html

This property will be ignored if `smsRole` is not specified.

---

##### `snsRegion`<sup>Optional</sup> <a name="snsRegion" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.snsRegion"></a>

```typescript
public readonly snsRegion: string;
```

- *Type:* string
- *Default:* The same region as the user pool, with a few exceptions - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html#user-pool-sms-settings-first-time

The region to integrate with SNS to send SMS messages.

This property will do nothing if SMS configuration is not configured

---

##### `standardAttributes`<sup>Optional</sup> <a name="standardAttributes" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.standardAttributes"></a>

```typescript
public readonly standardAttributes: StandardAttributes;
```

- *Type:* aws-cdk-lib.aws_cognito.StandardAttributes
- *Default:* All standard attributes are optional and mutable.

The set of attributes that are required for every user in the user pool.

Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html

---

##### `userInvitation`<sup>Optional</sup> <a name="userInvitation" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userInvitation"></a>

```typescript
public readonly userInvitation: UserInvitationConfig;
```

- *Type:* aws-cdk-lib.aws_cognito.UserInvitationConfig
- *Default:* see defaults in UserInvitationConfig

Configuration around admins signing up users into a user pool.

---

##### `userPoolName`<sup>Optional</sup> <a name="userPoolName" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userPoolName"></a>

```typescript
public readonly userPoolName: string;
```

- *Type:* string
- *Default:* automatically generated name by CloudFormation at deploy time

Name of the user pool.

---

##### `userVerification`<sup>Optional</sup> <a name="userVerification" id="@aws-prototyping-sdk/identity.UserPoolWithMfaProps.property.userVerification"></a>

```typescript
public readonly userVerification: UserVerificationConfig;
```

- *Type:* aws-cdk-lib.aws_cognito.UserVerificationConfig
- *Default:* see defaults in UserVerificationConfig

Configuration around users signing themselves up to the user pool.

Enable or disable self sign-up via the `selfSignUpEnabled` property.

---



