"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
const userpool_with_mfa_1 = require("./userpool-with-mfa");
const WEB_CLIENT_ID = "WebClient";
/**
 * Creates a UserPool and Identity Pool with sane defaults configured intended for usage from a web client.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        this.userPool = !props?.userPool
            ? new userpool_with_mfa_1.UserPoolWithMfa(this, "UserPool")
            : props.userPool;
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", props?.identityPoolOptions);
        const existingClient = this.userPool.node.children.find((e) => e.node.id === WEB_CLIENT_ID && e instanceof aws_cognito_1.UserPoolClient);
        this.userPoolClient =
            existingClient ??
                this.userPool.addClient(WEB_CLIENT_ID, {
                    authFlows: {
                        userPassword: true,
                        userSrp: true,
                    },
                });
        this.identityPool.addUserPoolAuthentication(new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
        }));
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws-prototyping-sdk/identity.UserIdentity", version: "0.17.5" };
//# sourceMappingURL=data:application/json;base64,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