"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolWithMfa = exports.USE_LEGACY_MFA_PROPS_CONTEXT_KEY = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const pdk_nag_1 = require("@aws-prototyping-sdk/pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
/**
 * Boolean context to indicate whether legacy MFA props should be used.
 *
 * @deprecated
 */
exports.USE_LEGACY_MFA_PROPS_CONTEXT_KEY = "@aws-prototyping-sdk/identity:useLegacyMFAProps";
/**
 * Legacy Userpool Props which configures MFA for SMS only.
 */
const LEGACY_DEFAULT_PROPS = {
    deletionProtection: true,
    passwordPolicy: {
        minLength: 8,
        requireLowercase: true,
        requireUppercase: true,
        requireDigits: true,
        requireSymbols: true,
        tempPasswordValidity: aws_cdk_lib_1.Duration.days(3),
    },
    advancedSecurityMode: aws_cognito_1.AdvancedSecurityMode.ENFORCED,
    mfa: aws_cognito_1.Mfa.REQUIRED,
    accountRecovery: aws_cognito_1.AccountRecovery.EMAIL_ONLY,
    autoVerify: {
        email: true,
    },
};
/**
 * Userpool default props which configure MFA across SMS/TOTP.
 */
const DEFAULT_PROPS = {
    deletionProtection: true,
    passwordPolicy: {
        minLength: 8,
        requireLowercase: true,
        requireUppercase: true,
        requireDigits: true,
        requireSymbols: true,
        tempPasswordValidity: aws_cdk_lib_1.Duration.days(3),
    },
    mfa: aws_cognito_1.Mfa.REQUIRED,
    mfaSecondFactor: { sms: true, otp: true },
    signInCaseSensitive: false,
    advancedSecurityMode: aws_cognito_1.AdvancedSecurityMode.ENFORCED,
    signInAliases: { username: true, email: true },
    accountRecovery: aws_cognito_1.AccountRecovery.EMAIL_ONLY,
    selfSignUpEnabled: false,
    standardAttributes: {
        phoneNumber: { required: false },
        email: { required: true },
        givenName: { required: true },
        familyName: { required: true },
    },
    autoVerify: {
        email: true,
        phone: true,
    },
    keepOriginal: {
        email: true,
        phone: true,
    },
};
/**
 * Configures a UserPool with MFA across SMS/TOTP using sane defaults.
 */
class UserPoolWithMfa extends aws_cognito_1.UserPool {
    constructor(scope, id, props) {
        super(scope, id, {
            ...(shouldUseLegacyProps(scope) ? LEGACY_DEFAULT_PROPS : DEFAULT_PROPS),
            ...props,
        });
        const stack = aws_cdk_lib_1.Stack.of(this);
        ["AwsSolutions-IAM5", "AwsPrototyping-IAMNoWildcardPermissions"].forEach((RuleId) => {
            pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${id}/UserPool/smsRole/Resource`, [
                {
                    id: RuleId,
                    reason: "MFA requires sending a text to a users phone number which cannot be known at deployment time.",
                    appliesTo: ["Resource::*"],
                },
            ]);
        });
    }
}
exports.UserPoolWithMfa = UserPoolWithMfa;
_a = JSII_RTTI_SYMBOL_1;
UserPoolWithMfa[_a] = { fqn: "@aws-prototyping-sdk/identity.UserPoolWithMfa", version: "0.17.5" };
/**
 * Determines if legacy props should be used by looking at the control flag in cdk context.
 *
 * @param scope construct scope.
 */
const shouldUseLegacyProps = (scope) => scope.node.tryGetContext(exports.USE_LEGACY_MFA_PROPS_CONTEXT_KEY);
//# sourceMappingURL=data:application/json;base64,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