# coding: utf-8

"""
    Timeline events

    This feature allows an app to create and configure custom events that can show up in the timelines of certain CRM objects like contacts, companies, tickets, or deals. You'll find multiple use cases for this API in the sections below.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.timeline.configuration import Configuration


class TimelineEventTemplate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'header_template': 'str',
        'detail_template': 'str',
        'tokens': 'list[TimelineEventTemplateToken]',
        'id': 'str',
        'object_type': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'name': 'name',
        'header_template': 'headerTemplate',
        'detail_template': 'detailTemplate',
        'tokens': 'tokens',
        'id': 'id',
        'object_type': 'objectType',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, name=None, header_template=None, detail_template=None, tokens=None, id=None, object_type=None, created_at=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """TimelineEventTemplate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._header_template = None
        self._detail_template = None
        self._tokens = None
        self._id = None
        self._object_type = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        self.name = name
        if header_template is not None:
            self.header_template = header_template
        if detail_template is not None:
            self.detail_template = detail_template
        self.tokens = tokens
        self.id = id
        self.object_type = object_type
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def name(self):
        """Gets the name of this TimelineEventTemplate.  # noqa: E501

        The template name.  # noqa: E501

        :return: The name of this TimelineEventTemplate.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TimelineEventTemplate.

        The template name.  # noqa: E501

        :param name: The name of this TimelineEventTemplate.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def header_template(self):
        """Gets the header_template of this TimelineEventTemplate.  # noqa: E501

        This uses Markdown syntax with Handlebars and event-specific data to render HTML on a timeline as a header.  # noqa: E501

        :return: The header_template of this TimelineEventTemplate.  # noqa: E501
        :rtype: str
        """
        return self._header_template

    @header_template.setter
    def header_template(self, header_template):
        """Sets the header_template of this TimelineEventTemplate.

        This uses Markdown syntax with Handlebars and event-specific data to render HTML on a timeline as a header.  # noqa: E501

        :param header_template: The header_template of this TimelineEventTemplate.  # noqa: E501
        :type: str
        """

        self._header_template = header_template

    @property
    def detail_template(self):
        """Gets the detail_template of this TimelineEventTemplate.  # noqa: E501

        This uses Markdown syntax with Handlebars and event-specific data to render HTML on a timeline when you expand the details.  # noqa: E501

        :return: The detail_template of this TimelineEventTemplate.  # noqa: E501
        :rtype: str
        """
        return self._detail_template

    @detail_template.setter
    def detail_template(self, detail_template):
        """Sets the detail_template of this TimelineEventTemplate.

        This uses Markdown syntax with Handlebars and event-specific data to render HTML on a timeline when you expand the details.  # noqa: E501

        :param detail_template: The detail_template of this TimelineEventTemplate.  # noqa: E501
        :type: str
        """

        self._detail_template = detail_template

    @property
    def tokens(self):
        """Gets the tokens of this TimelineEventTemplate.  # noqa: E501

        A collection of tokens that can be used as custom properties on the event and to create fully fledged CRM objects.  # noqa: E501

        :return: The tokens of this TimelineEventTemplate.  # noqa: E501
        :rtype: list[TimelineEventTemplateToken]
        """
        return self._tokens

    @tokens.setter
    def tokens(self, tokens):
        """Sets the tokens of this TimelineEventTemplate.

        A collection of tokens that can be used as custom properties on the event and to create fully fledged CRM objects.  # noqa: E501

        :param tokens: The tokens of this TimelineEventTemplate.  # noqa: E501
        :type: list[TimelineEventTemplateToken]
        """
        if self.local_vars_configuration.client_side_validation and tokens is None:  # noqa: E501
            raise ValueError("Invalid value for `tokens`, must not be `None`")  # noqa: E501

        self._tokens = tokens

    @property
    def id(self):
        """Gets the id of this TimelineEventTemplate.  # noqa: E501

        The template ID.  # noqa: E501

        :return: The id of this TimelineEventTemplate.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TimelineEventTemplate.

        The template ID.  # noqa: E501

        :param id: The id of this TimelineEventTemplate.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def object_type(self):
        """Gets the object_type of this TimelineEventTemplate.  # noqa: E501

        The type of CRM object this template is for. [Contacts, companies, tickets, and deals] are supported.  # noqa: E501

        :return: The object_type of this TimelineEventTemplate.  # noqa: E501
        :rtype: str
        """
        return self._object_type

    @object_type.setter
    def object_type(self, object_type):
        """Sets the object_type of this TimelineEventTemplate.

        The type of CRM object this template is for. [Contacts, companies, tickets, and deals] are supported.  # noqa: E501

        :param object_type: The object_type of this TimelineEventTemplate.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and object_type is None:  # noqa: E501
            raise ValueError("Invalid value for `object_type`, must not be `None`")  # noqa: E501

        self._object_type = object_type

    @property
    def created_at(self):
        """Gets the created_at of this TimelineEventTemplate.  # noqa: E501

        The date and time that the Event Template was created, as an ISO 8601 timestamp. Will be null if the template was created before Feb 18th, 2020.  # noqa: E501

        :return: The created_at of this TimelineEventTemplate.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this TimelineEventTemplate.

        The date and time that the Event Template was created, as an ISO 8601 timestamp. Will be null if the template was created before Feb 18th, 2020.  # noqa: E501

        :param created_at: The created_at of this TimelineEventTemplate.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this TimelineEventTemplate.  # noqa: E501

        The date and time that the Event Template was last updated, as an ISO 8601 timestamp. Will be null if the template was created before Feb 18th, 2020.  # noqa: E501

        :return: The updated_at of this TimelineEventTemplate.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this TimelineEventTemplate.

        The date and time that the Event Template was last updated, as an ISO 8601 timestamp. Will be null if the template was created before Feb 18th, 2020.  # noqa: E501

        :param updated_at: The updated_at of this TimelineEventTemplate.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TimelineEventTemplate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TimelineEventTemplate):
            return True

        return self.to_dict() != other.to_dict()
