# Generated by Django 2.0.1 on 2018-01-17 14:35

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('billing', '0005_creditcard_status'),
    ]

    operations = [
        migrations.CreateModel(
            name='ProductProperty',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=100, validators=[django.core.validators.RegexValidator(flags=258, message='a letter maybe followed by letters, numbers, or underscores', regex='^[a-z]\\w*$')])),
                ('value', models.CharField(max_length=255)),
            ],
        ),
        migrations.RemoveField(
            model_name='charge',
            name='description',
        ),
        migrations.AddField(
            model_name='charge',
            name='ad_hoc_label',
            field=models.TextField(blank=True, help_text='When not empty, this is shown verbatim to the user.'),
        ),
        migrations.AddField(
            model_name='charge',
            name='product_code',
            field=models.CharField(blank=True, db_index=True, help_text='Identifies the kind of product being charged or credited', max_length=8, validators=[django.core.validators.RegexValidator(message='Between 4 and 8 uppercase letters or digits', regex='^[A-Z0-9]{4,8}$')]),
        ),
        migrations.AddField(
            model_name='productproperty',
            name='charge',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='product_properties', to='billing.Charge'),
        ),
        migrations.AlterUniqueTogether(
            name='productproperty',
            unique_together={('charge', 'name')},
        ),
    ]
