# -*- coding: utf-8 -*-
#
# Copyright (C) 2021-2022 CERN.
# Copyright (C) 2021 TU Wien.
#
# Invenio-Requests is free software; you can redistribute it and/or modify it
# under the terms of the MIT License; see LICENSE file for more details.

"""Invenio module for generic and customizable requests."""

from .actions import (
    AcceptAction,
    CancelAction,
    CreateAction,
    CreateAndSubmitAction,
    DeclineAction,
    DeleteAction,
    ExpireAction,
    RequestAction,
    RequestActions,
    SubmitAction,
)
from .request_types import RequestType
from .states import RequestState

__all__ = (
    "AcceptAction",
    "CancelAction",
    "CreateAction",
    "CreateAndSubmitAction",
    "DeclineAction",
    "DeleteAction",
    "ExpireAction",
    "RequestAction",
    "RequestAction",
    "RequestActions",
    "RequestState",
    "RequestType",
    "SubmitAction",
)
