"""Generated by emqxlwm2m.codegen at 2020-11-22 12:13:49

LwM2M Object: Location
ID: 6, URN: urn:oma:lwm2m:oma:6, Optional, Single
"""

from emqxlwm2m.lwm2m import *


class Latitude(Resource):
    """Latitude 0 - Float, Single, Mandatory

    The decimal notation of latitude, e.g., -43.5723 [World Geodetic
    System 1984].
    """

    rid = 0
    operations = R
    type = 'float'
    range = 'N/A'
    unit = 'Deg'
    mandatory = True
    multiple = False


class Longitude(Resource):
    """Longitude 1 - Float, Single, Mandatory

    The decimal notation of longitude, e.g., 153.21760 [World Geodetic
    System 1984].
    """

    rid = 1
    operations = R
    type = 'float'
    range = 'N/A'
    unit = 'Deg'
    mandatory = True
    multiple = False


class Altitude(Resource):
    """Altitude 2 - Float, Single, Optional

    The decimal notation of altitude in meters above sea level.
    """

    rid = 2
    operations = R
    type = 'float'
    range = 'N/A'
    unit = 'm'
    mandatory = False
    multiple = False


class Radius(Resource):
    """Radius 3 - Float, Single, Optional

    The value in the Radius Resource indicates the size in meters of a
    circular area around a point of geometry.
    """

    rid = 3
    operations = R
    type = 'float'
    range = 'N/A'
    unit = 'm'
    mandatory = False
    multiple = False


class Velocity(Resource):
    """Velocity 4 - Opaque, Single, Optional

    The velocity in the LwM2M Client is defined in [3GPP-TS_23.032].
    """

    rid = 4
    operations = R
    type = 'opaque'
    range = 'N/A'
    unit = 'N/A'
    mandatory = False
    multiple = False


class Timestamp(Resource):
    """Timestamp 5 - Time, Single, Mandatory

    The timestamp of when the location measurement was performed.
    """

    rid = 5
    operations = R
    type = 'time'
    range = 'N/A'
    unit = 'N/A'
    mandatory = True
    multiple = False


class Speed(Resource):
    """Speed 6 - Float, Single, Optional

    Speed is the time rate of change in position of a LwM2M Client
    without regard for direction: the scalar component of velocity.
    """

    rid = 6
    operations = R
    type = 'float'
    range = 'N/A'
    unit = 'Meters per second'
    mandatory = False
    multiple = False


class Location(ObjectDef):
    """Location Object 6 - Optional, Single

    This LwM2M Objects provide a range of device related information
    which can be queried by the LwM2M Server, and a device reboot and
    factory reset function.
    """

    oid = 6
    mandatory = False
    multiple = False

    # ID=0, Float, R, Single, Mandatory, range: N/A, unit: Deg
    latitude = Latitude()

    # ID=1, Float, R, Single, Mandatory, range: N/A, unit: Deg
    longitude = Longitude()

    # ID=2, Float, R, Single, Optional, range: N/A, unit: m
    altitude = Altitude()

    # ID=3, Float, R, Single, Optional, range: N/A, unit: m
    radius = Radius()

    # ID=4, Opaque, R, Single, Optional, range: N/A, unit: N/A
    velocity = Velocity()

    # ID=5, Time, R, Single, Mandatory, range: N/A, unit: N/A
    timestamp = Timestamp()

    # ID=6, Float, R, Single, Optional, range: N/A, unit: Meters per second
    speed = Speed()

