# parse-changelog
This is a very simplistic changelog updater/parser, with two modes of operation:
1. Insert a new release into the changelog, using the list of changes from the Unreleased section
1. Parse the releases in the changelog into a JSON structure.

Changelogs must be in the format documented by [Keep a Changelog](https://keepachangelog.com/en/1.0.0/), see the details
below.

Release history: [parse-changelog's CHANGELOG](https://github.com/cseelye/parse-changelog/blob/main/CHANGELOG.md)

## Changelog Updates
The first mode updates the changelog and is invoked by using the `--release` arg. It walks through the file line-by-line
until it finds the unreleased section. Then it inserts a newline and the new release heading, and then writes out the
rest of the file unchanged.

The changelog must use the format `## [Unreleased]` (case insensitive) for this parser to find it.
For example, here is the diff generated by adding a new release "1.0.2" to a changelog:
```
## [Unreleased]
+
+## [1.0.2] - 2022-10-20
 * Great new stuff
 
 ## [1.0.1] - 2022-10-08
```

## Changelog Parsing
The second mode parses the changelog into JSON and is invoked by not specifying a new `--release` arg. It finds all of
the heading2 entryies (lines starting with `##`) and assumes eachh of those is a release. For each release, it parses
the release title into version and date, and collects the content of the release as a single string. Each release
heading must be of the format `## [release_version] - YYYY-MM-DD`, where `release_version` matches SemVer version string
spec, and `YYYY-MM-DD` is a valid year-month-day. The one exception to this format is the special release heading for
unreleased changes, which must match `## [Unreleased]`. The content of the release is parsed as a single string and not
interpreted in any way. For example, given the following changelog:
```
# Changelog

My Project Name

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]
* Great new stuff

## [1.0.1] - 2022-10-08
### Fixed
* Minor bug that we missed
### Changed
* New name for an artifact

## [1.0.0] - 2022-09-01
Initial release
* Some cool feature
* Other interesting stuff
```

It will be parsed into this JSON:

```
{
  "prerelease": {
    "title": "[Unreleased]",
    "content": "* Great new stuff\n",
    "version": "prerelease",
    "date": "unreleased"
  },
  "[1.0.1] - 2022-10-08": {
    "title": "[1.0.1] - 2022-10-08",
    "content": "### Fixed\n* Minor bug that we missed\n### Changed\n* New name for an artifact\n",
    "version": "unknown",
    "date": "unknown"
  },
  "[1.0.0] - 2022-09-01": {
    "title": "[1.0.0] - 2022-09-01",
    "content": "Initial release\n* Some cool feature\n* Other interesting stuff\n",
    "version": "unknown",
    "date": "unknown"
  }
}
```
