import { Construct } from 'constructs';
export interface ImagePipelineProps {
    /**
     * Relative path to the Image Builder component document
     */
    readonly componentDocPath: string;
    /**
     * Name of the Component
     */
    readonly componentName: string;
    /**
     * Name of the instance profile that will be associated with the Instance Configuration.
     */
    readonly profileName: string;
    /**
     * Name of the Infrastructure Configuration for Image Builder
     */
    readonly infraConfigName: string;
    /**
     * Name of the Image Recipe
     */
    readonly imageRecipe: string;
    /**
     * Image recipe version (Default: 0.0.1)
     */
    readonly imageRecipeVersion?: string;
    /**
     * Name of the Image Pipeline
     */
    readonly pipelineName: string;
    /**
     * The source (parent) image that the image recipe uses as its base environment. The value can be the parent image ARN or an Image Builder AMI ID
     */
    readonly parentImage: string;
    /**
     * List of instance types used in the Instance Configuration (Default: [ 't3.medium', 'm5.large', 'm5.xlarge' ])
     */
    readonly instanceTypes?: string[];
    /**
     * Platform type Linux or Windows (Default: Linux)
     */
    readonly platform?: string;
    /**
    * Email used to receive Image Builder Pipeline Notifications via SNS
    */
    readonly email?: string;
    /**
     * List of security group IDs for the Infrastructure Configuration
     */
    readonly securityGroups?: string[];
    /**
     * Subnet ID for the Infrastructure Configuration
     */
    readonly subnetId?: string;
}
export declare class ImagePipeline extends Construct {
    constructor(scope: Construct, id: string, props: ImagePipelineProps);
}
