# generated by datamodel-codegen:
#   filename:  api-docs.yaml
#   timestamp: 2022-04-12T19:45:50+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union

from kodexa.model.base import KodexaBaseModel
from pydantic import Field, constr


class FavoriteLink(KodexaBaseModel):
    link: Optional[str] = None


class UserStorage(KodexaBaseModel):
    favorite_links: Optional[List[FavoriteLink]] = Field(None, alias='favoriteLinks')


class CompletePasswordReset(KodexaBaseModel):
    reset_token: str = Field(..., alias='resetToken')
    password: str


class Organization(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    name: str
    slug: constr(regex=r'^[a-zA-Z0-9\-_]{0,100}$')
    public_access: Optional[bool] = Field(None, alias='publicAccess')
    description: Optional[str] = None
    has_image: Optional[bool] = Field(None, alias='hasImage')


class Team(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    name: Optional[str] = None
    description: Optional[str] = None
    organization: Optional[Organization] = None


class AssistantImplementation(KodexaBaseModel):
    package: Optional[str] = None
    class_: Optional[str] = Field(None, alias='class')


class AssistantTaxonomy(KodexaBaseModel):
    ref: Optional[str] = None


class Avatar(KodexaBaseModel):
    icon: Optional[str] = None
    icon_group: Optional[str] = Field(None, alias='iconGroup')


class ColumnState(KodexaBaseModel):
    field: Optional[str] = None
    title: Optional[str] = None
    cell: Optional[str] = None
    width: Optional[str] = None
    groupable: Optional[bool] = None
    sortable: Optional[bool] = None
    resizeable: Optional[bool] = None


class ContainerResources(KodexaBaseModel):
    memory: Optional[str] = None
    cpu: Optional[str] = None


class ContentMetadata(KodexaBaseModel):
    type: Optional[str] = None


class DashboardWidget(KodexaBaseModel):
    id: Optional[str] = None
    name: Optional[str] = None
    type: Optional[str] = None
    height: Optional[str] = None


class DeploymentType(Enum):
    kubernetes = 'KUBERNETES'
    aws_lambda = 'AWS_LAMBDA'
    azure_cloud_function = 'AZURE_CLOUD_FUNCTION'
    none = 'NONE'


class DocumentColumn(KodexaBaseModel):
    label: Optional[str] = Field(
        None, description='The label to use for the column heading'
    )
    path: Optional[str] = Field(None, description='The path to the data')


class DocumentContentMetadata(ContentMetadata):
    type: Optional[str] = Field(None, description='The type of content metadata')


class EventSubscription(KodexaBaseModel):
    id: Optional[str] = None
    type: str = Field(..., description='The type of subscription object')


class Status(Enum):
    pending = 'PENDING'
    building = 'BUILDING'
    built = 'BUILT'
    available = 'AVAILABLE'
    failed = 'FAILED'
    undeployed = 'UNDEPLOYED'


class ExtensionPackSource(KodexaBaseModel):
    type: Optional[str] = None


class LabelSubscription(EventSubscription):
    label: Optional[str] = None
    inverted: Optional[bool] = None


class MatchLabel(KodexaBaseModel):
    label: Optional[str] = None
    value: Optional[str] = None


class MetadataTag(KodexaBaseModel):
    tag: Optional[str] = None
    image_url: Optional[str] = Field(None, alias='imageUrl')


class MixinSubscription(EventSubscription):
    mixin: Optional[str] = None
    inverted: Optional[bool] = None


class State(Enum):
    pending = 'PENDING'
    preparing = 'PREPARING'
    prepared = 'PREPARED'
    training = 'TRAINING'
    trained = 'TRAINED'
    deployed = 'DEPLOYED'
    undeployed = 'UNDEPLOYED'
    failed = 'FAILED'


class DeploymentType1(Enum):
    local = 'LOCAL'
    container = 'CONTAINER'


class Status1(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'


class OverlayCondition(KodexaBaseModel):
    pass


class PathSubscription(EventSubscription):
    path: Optional[str] = None
    case_sensitive: Optional[bool] = Field(None, alias='caseSensitive')
    inverted: Optional[bool] = None


class StepType(Enum):
    action = 'ACTION'
    model = 'MODEL'


class PipelineStepMetadata(KodexaBaseModel):
    name: Optional[str] = Field(None, description='The name of the step')
    ref: Optional[str] = Field(None, description='The reference to the action')
    options: Optional[Dict[str, Any]] = Field(
        None, description='The options for the step in the pipeline'
    )
    step_type: Optional[StepType] = Field(
        None, alias='stepType', description='The type of step (ACTION or MODEL)'
    )


class PossibleValue(KodexaBaseModel):
    label: Optional[str] = None
    value: Optional[Any] = None


class StoreType(Enum):
    document = 'DOCUMENT'
    table = 'TABLE'
    dictionary = 'DICTIONARY'
    model = 'MODEL'


class StorePurpose(Enum):
    operational = 'OPERATIONAL'
    training = 'TRAINING'


class ProjectStore(KodexaBaseModel):
    slug: Optional[str] = None
    name: Optional[str] = None
    description: Optional[str] = None
    store_type: Optional[StoreType] = Field(None, alias='storeType')
    store_purpose: Optional[StorePurpose] = Field(None, alias='storePurpose')
    template_ref: Optional[str] = Field(None, alias='templateRef')


class TaxonomyType(Enum):
    content = 'CONTENT'
    classification = 'CLASSIFICATION'
    processing = 'PROCESSING'
    model = 'MODEL'


class Category(Enum):
    task = 'TASK'
    document = 'DOCUMENT'
    connector = 'CONNECTOR'
    machine_learning = 'MACHINE_LEARNING'
    supplemental = 'SUPPLEMENTAL'


class Purpose(Enum):
    suggestion = 'SUGGESTION'
    source = 'SOURCE'


class RelatedTaxon(KodexaBaseModel):
    path: Optional[str] = None
    purpose: Optional[Purpose] = None
    priority: Optional[int] = None


class ScheduleDefinition(KodexaBaseModel):
    type: Optional[str] = None
    cron_expression: Optional[str] = Field(None, alias='cronExpression')
    last_event: Optional[datetime] = Field(None, alias='lastEvent')
    next_event: Optional[datetime] = Field(None, alias='nextEvent')


class SelectionOption(KodexaBaseModel):
    label: Optional[str] = None
    id: Optional[str] = None
    description: Optional[str] = None


class SlugBasedMetadata(KodexaBaseModel):
    ref: Optional[str] = Field(None, description='The reference to the metadata object')
    schema_version: Optional[int] = Field(
        None, alias='schemaVersion', description='The version of the schema'
    )
    template: Optional[bool] = Field(
        None,
        description='Is this taxonomy a template that can be used to create new taxonomies',
    )
    org_slug: Optional[str] = Field(
        None,
        alias='orgSlug',
        description='The slug of the organization that owns this metadata object',
    )
    slug: constr(regex=r'^[a-zA-Z0-9\-_]{0,255}$') = Field(
        ..., description='The slug used when referencing this metadata object'
    )
    type: str = Field(..., description='The type of metadata object')
    name: str = Field(..., description='The name of the object')
    description: Optional[str] = Field(
        None, description='The description of the object'
    )
    version: Optional[str] = Field(None, description='The version of the object')
    deployed: Optional[datetime] = Field(
        None,
        description='The date/time the object was deployed into this Kodexa instance',
    )
    public_access: Optional[bool] = Field(
        None,
        alias='publicAccess',
        description='Is the metadata object publicly accessible by other organizations',
    )
    image_url: Optional[str] = Field(
        None,
        alias='imageUrl',
        description='URL of image when presenting this object in a UI',
    )
    icon: Optional[str] = Field(None, description='Material Icon name to use in the UI')
    overview_markdown: Optional[str] = Field(
        None,
        alias='overviewMarkdown',
        description='Markdown that is used to present the overview of the object',
    )
    metadata_tag: Optional[List[MetadataTag]] = Field(
        None, alias='metadataTag', description='A list of associated tags'
    )
    provider: Optional[str] = Field(None, description='The details of the of provider')
    provider_url: Optional[str] = Field(
        None, alias='providerUrl', description='The link to the provider website'
    )
    provider_image_url: Optional[str] = Field(
        None, alias='providerImageUrl', description='The link to the model image'
    )


class StepImplementation(KodexaBaseModel):
    package: Optional[str] = None
    class_: Optional[str] = Field(None, alias='class')


class StoreType1(Enum):
    document = 'DOCUMENT'
    table = 'TABLE'
    dictionary = 'DICTIONARY'
    model = 'MODEL'


class StorePurpose1(Enum):
    operational = 'OPERATIONAL'
    training = 'TRAINING'


class StoreFilter(KodexaBaseModel):
    pass


class StoreViewOptions(KodexaBaseModel):
    show_last_event: Optional[bool] = Field(None, alias='showLastEvent')
    show_extension: Optional[bool] = Field(None, alias='showExtension')
    show_created: Optional[bool] = Field(None, alias='showCreated')
    show_modified: Optional[bool] = Field(None, alias='showModified')
    show_path_counts: Optional[bool] = Field(None, alias='showPathCounts')
    show_classifications: Optional[bool] = Field(None, alias='showClassifications')
    show_size: Optional[bool] = Field(None, alias='showSize')
    show_assignments: Optional[bool] = Field(None, alias='showAssignments')
    show_status: Optional[bool] = Field(None, alias='showStatus')
    additional_columns: Optional[List[DocumentColumn]] = Field(
        None, alias='additionalColumns'
    )
    column_states: Optional[Dict[str, List[ColumnState]]] = Field(
        None, alias='columnStates'
    )


class TabGroup(KodexaBaseModel):
    id: Optional[str] = None
    name: Optional[str] = None
    icon: Optional[str] = None
    show_if: Optional[str] = Field(None, alias='showIf')


class ValuePath(Enum):
    value_or_all_content = 'VALUE_OR_ALL_CONTENT'
    value_only = 'VALUE_ONLY'
    all_content = 'ALL_CONTENT'
    data_path = 'DATA_PATH'
    metadata = 'METADATA'
    expression = 'EXPRESSION'


class MetadataValue(Enum):
    filename = 'FILENAME'
    transaction_uuid = 'TRANSACTION_UUID'
    created_datetime = 'CREATED_DATETIME'


class TaxonType(Enum):
    string = 'STRING'
    date = 'DATE'
    date_time = 'DATE_TIME'
    number = 'NUMBER'
    decimal = 'DECIMAL'
    float = 'FLOAT'
    boolean = 'BOOLEAN'
    currency = 'CURRENCY'
    url = 'URL'
    email_address = 'EMAIL_ADDRESS'
    phone_number = 'PHONE_NUMBER'
    selection = 'SELECTION'


class TaxonomyType1(Enum):
    content = 'CONTENT'
    classification = 'CLASSIFICATION'
    processing = 'PROCESSING'
    model = 'MODEL'


class TextboxWidget(DashboardWidget):
    title: Optional[str] = None
    subtitle: Optional[str] = None
    body: Optional[str] = None


class ValidationError(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    message: Optional[str] = None
    option: Optional[str] = None
    description: Optional[str] = None


class ReprocessRequest(KodexaBaseModel):
    assistant_ids: Optional[List[str]] = Field(None, alias='assistantIds')
    family_ids: Optional[List[str]] = Field(None, alias='familyIds')
    all: Optional[bool] = None


class ContentClassification(KodexaBaseModel):
    label: Optional[str] = None
    taxonomy: Optional[str] = None
    selector: Optional[str] = None
    confidence: Optional[float] = None


class ContentType(Enum):
    document = 'DOCUMENT'
    native = 'NATIVE'


class ActorType(Enum):
    user = 'USER'
    assistant = 'ASSISTANT'
    access_token = 'ACCESS_TOKEN'
    api = 'API'


class DocumentActor(KodexaBaseModel):
    actor_id: Optional[str] = Field(
        None,
        alias='actorId',
        description='The ID for the actor (dependent on the actor type)',
    )
    actor_type: Optional[ActorType] = Field(
        None, alias='actorType', description='The type of actor'
    )


class StatusType(Enum):
    unresolved = 'UNRESOLVED'
    resolved = 'RESOLVED'


class DocumentStatus(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    color: Optional[str] = None
    icon: Optional[str] = None
    status: str
    status_type: Optional[StatusType] = Field(None, alias='statusType')


class TransitionType(Enum):
    derived = 'DERIVED'


class DocumentTransition(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    unknown_fields: Optional[Dict[str, str]] = Field(None, alias='unknownFields')
    transition_type: Optional[TransitionType] = Field(
        None, alias='transitionType', description='The type of transition'
    )
    index: Optional[int] = None
    date_time: Optional[datetime] = Field(
        None, alias='dateTime', description='The date/time of the transition'
    )
    actor: Optional[DocumentActor] = None
    label: Optional[str] = Field(
        None,
        description='A label for the transition (this can be used later if we want to prune based on a label)',
    )
    destination_content_object_id: Optional[str] = Field(
        None, alias='destinationContentObjectId'
    )
    source_content_object_id: Optional[str] = Field(None, alias='sourceContentObjectId')


class Label(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    color: Optional[str] = None
    label: str
    name: str


class BulkCopy(KodexaBaseModel):
    target_store_ref: Optional[str] = Field(None, alias='targetStoreRef')
    all: Optional[bool] = None
    document_family_ids: Optional[List[str]] = Field(None, alias='documentFamilyIds')


class FamilyRename(KodexaBaseModel):
    path: str


class ContentFeature(KodexaBaseModel):
    feature_type: Optional[str] = Field(None, alias='featureType')
    name: Optional[str] = None
    value: Optional[List[Dict[str, Any]]] = None
    single: Optional[bool] = None


class NodeFeatures(KodexaBaseModel):
    node_uuid: Optional[str] = Field(None, alias='nodeUuid')
    features: Optional[List[ContentFeature]] = None


class StatusType1(Enum):
    unresolved = 'UNRESOLVED'
    resolved = 'RESOLVED'


class AttributeStatus(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    color: Optional[str] = None
    icon: Optional[str] = None
    status: Optional[str] = None
    status_type: Optional[StatusType1] = Field(None, alias='statusType')


class CellValidationMessage(KodexaBaseModel):
    message: Optional[str] = Field(
        None, description='Message to describe the validation issue'
    )
    validation_features: Optional[Dict[str, Any]] = Field(
        None,
        alias='validationFeatures',
        description='Additional features from the validation',
    )


class ValidationState(Enum):
    valid = 'VALID'
    invalid = 'INVALID'
    warning = 'WARNING'


class DataAttribute(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    value: Optional[str] = None
    truncated: Optional[bool] = None
    tag: str
    tag_uuid: Optional[str] = Field(None, alias='tagUuid')
    date_value: Optional[datetime] = Field(None, alias='dateValue')
    float_value: Optional[float] = Field(None, alias='floatValue')
    decimal_value: Optional[float] = Field(None, alias='decimalValue')
    number_value: Optional[int] = Field(None, alias='numberValue')
    boolean_value: Optional[bool] = Field(None, alias='booleanValue')
    string_value: Optional[str] = Field(None, alias='stringValue')
    attribute_status: Optional[AttributeStatus] = Field(None, alias='attributeStatus')
    validation_state: ValidationState = Field(
        ..., alias='validationState', description='The current validation state'
    )
    validation_messages: Optional[List[CellValidationMessage]] = Field(
        None,
        alias='validationMessages',
        description='A list of messages relating to the validity',
    )
    confidence: Optional[float] = None
    data_features: Optional[Dict[str, Any]] = Field(
        None, alias='dataFeatures', description='Additional features for the data'
    )
    label: Optional[str] = None
    number_of_notes: Optional[int] = Field(
        None,
        alias='numberOfNotes',
        description='The number of notes associated with this attribute',
    )


class DataLineage(KodexaBaseModel):
    store_ref: Optional[str] = Field(None, alias='storeRef')
    document_family_id: Optional[str] = Field(None, alias='documentFamilyId')
    execution_id: Optional[str] = Field(None, alias='executionId')
    content_object_id: Optional[str] = Field(None, alias='contentObjectId')


class Status2(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'


class StatusDetails(KodexaBaseModel):
    status: Optional[Status2] = None
    message: Optional[str] = None
    detail: Optional[str] = None
    progress_max: Optional[int] = Field(None, alias='progressMax')
    progress: Optional[int] = None


class Status3(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'


class Status4(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'


class StepType1(Enum):
    action = 'ACTION'
    model = 'MODEL'


class Type(Enum):
    document_store = 'DOCUMENT_STORE'
    taxonomy_store = 'TAXONOMY_STORE'
    data_store = 'DATA_STORE'


class ExecutionTarget(KodexaBaseModel):
    type: Optional[Type] = None
    ref: Optional[str] = None
    document_family_id: Optional[str] = Field(None, alias='documentFamilyId')
    content_object_id: Optional[str] = Field(None, alias='contentObjectId')
    actor: Optional[DocumentActor] = None
    taxonomy_refs: Optional[List[str]] = Field(None, alias='taxonomyRefs')
    labels_to_apply: Optional[List[str]] = Field(None, alias='labelsToApply')


class ExecutionTargets(KodexaBaseModel):
    instances: Optional[List[ExecutionTarget]] = None


class State1(Enum):
    open = 'OPEN'
    closed = 'CLOSED'


class Session(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    state: State1
    token: Optional[str] = None
    last_accessed: Optional[datetime] = Field(None, alias='lastAccessed')


class ProjectMetadata(KodexaBaseModel):
    tags: Optional[List[str]] = None


class WorkflowDefinition(KodexaBaseModel):
    description: Optional[str] = None
    definition_xml: Optional[str] = Field(None, alias='definitionXml')


class ProjectResourcesUpdate(KodexaBaseModel):
    taxonomy_refs: Optional[List[str]] = Field(None, alias='taxonomyRefs')
    store_refs: Optional[List[str]] = Field(None, alias='storeRefs')
    dashboard_refs: Optional[List[str]] = Field(None, alias='dashboardRefs')


class AssistantSchedule(KodexaBaseModel):
    type: Optional[str] = None
    cron_expression: Optional[str] = Field(None, alias='cronExpression')
    last_event: Optional[datetime] = Field(None, alias='lastEvent')
    next_event: Optional[datetime] = Field(None, alias='nextEvent')
    id: Optional[str] = None


class ValidationResults(KodexaBaseModel):
    instances: Optional[List[ValidationError]] = None


class Role1(Enum):
    owner = 'OWNER'
    read = 'READ'
    write = 'WRITE'


class DeploymentType2(Enum):
    kubernetes = 'KUBERNETES'
    aws_lambda = 'AWS_LAMBDA'
    azure_cloud_function = 'AZURE_CLOUD_FUNCTION'
    none = 'NONE'


class DeploymentOptions(KodexaBaseModel):
    deployment_type: Optional[DeploymentType2] = Field(None, alias='deploymentType')
    max_replicas: Optional[int] = Field(None, alias='maxReplicas')
    min_replicas: Optional[int] = Field(None, alias='minReplicas')
    reserved_concurrency: Optional[int] = Field(None, alias='reservedConcurrency')
    memory_assigned: Optional[str] = Field(None, alias='memoryAssigned')
    cpu: Optional[str] = None
    pod_match_labels: Optional[List[MatchLabel]] = Field(None, alias='podMatchLabels')


class PlatformConfiguration(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    welcome_markdown: Optional[str] = Field(None, alias='welcomeMarkdown')
    about_markdown: Optional[str] = Field(None, alias='aboutMarkdown')
    login_message: Optional[str] = Field(None, alias='loginMessage')
    base_org_slug: Optional[str] = Field(None, alias='baseOrgSlug')
    title: Optional[str] = None
    organization_title: Optional[str] = Field(None, alias='organizationTitle')
    organizations_title: Optional[str] = Field(None, alias='organizationsTitle')
    organization_description: Optional[str] = Field(
        None, alias='organizationDescription'
    )
    project_title: Optional[str] = Field(None, alias='projectTitle')
    projects_title: Optional[str] = Field(None, alias='projectsTitle')
    project_description: Optional[str] = Field(None, alias='projectDescription')
    developer_links: Optional[bool] = Field(None, alias='developerLinks')
    allow_registration: Optional[bool] = Field(None, alias='allowRegistration')
    allow_password_reset: Optional[bool] = Field(None, alias='allowPasswordReset')
    default_to_design: Optional[bool] = Field(None, alias='defaultToDesign')
    extension_pack_bridge: Optional[str] = Field(None, alias='extensionPackBridge')
    fallback_feature_flags: Optional[str] = Field(None, alias='fallbackFeatureFlags')


class UserActivation(KodexaBaseModel):
    first_name: Optional[str] = Field(None, alias='firstName')
    last_name: Optional[str] = Field(None, alias='lastName')
    password: Optional[str] = None


class AccessToken(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    name: str
    token: Optional[str] = None
    organization: Optional[Organization] = None


class SearchEntity(KodexaBaseModel):
    entity: Optional[str] = Field(None, description='The type of entity')
    value: Optional[str] = Field(None, description='The entity value')
    start: Optional[int] = Field(None, description='Start position')
    end: Optional[int] = Field(None, description='End position')


class Status5(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'


class BaseEvent1(KodexaBaseModel):
    type: Optional[str] = Field(None, description='The type of the event')


class ObjectEventType(Enum):
    new_object = 'NEW_OBJECT'
    derived_object = 'DERIVED_OBJECT'


class Type1(Enum):
    start_execution = 'START_EXECUTION'
    step_update = 'STEP_UPDATE'
    assistant_event = 'ASSISTANT_EVENT'
    assistant_response = 'ASSISTANT_RESPONSE'


class Status6(Enum):
    pending = 'PENDING'
    running = 'RUNNING'
    succeeded = 'SUCCEEDED'
    failed = 'FAILED'
    requested = 'REQUESTED'
    skipped = 'SKIPPED'
    cancelling = 'CANCELLING'
    cancelled = 'CANCELLED'


class ExecutionLogEntry(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    log_date: Optional[datetime] = Field(None, alias='logDate')
    entry: Optional[str] = None


class LoginRequest(KodexaBaseModel):
    email: str
    password: str


class RegisterUser(KodexaBaseModel):
    email: str
    first_name: str = Field(..., alias='firstName')
    last_name: str = Field(..., alias='lastName')


class PasswordReset(KodexaBaseModel):
    email: str


class PasswordChange(KodexaBaseModel):
    old_password: str = Field(..., alias='oldPassword')
    new_password: str = Field(..., alias='newPassword')


class PlatformOverview(KodexaBaseModel):
    name: Optional[str] = None
    release: Optional[str] = None
    description: Optional[str] = None
    host_name: Optional[str] = Field(
        None, alias='hostName', description='The hostname for this instance'
    )
    environment: Optional[str] = Field(
        None,
        description='The name of the environment in which this instance is running',
    )
    commit_id: Optional[str] = Field(
        None,
        alias='commitId',
        description='The git commit ID for this API server instance running',
    )
    build_time: Optional[str] = Field(
        None,
        alias='buildTime',
        description='The build time for this API server instance running',
    )
    version: Optional[str] = Field(
        None, description='The version of API server instance running'
    )
    ua: Optional[str] = Field(None, description='Google UA')
    extension_packs: Optional[List[Dict[str, str]]] = Field(
        None, alias='extensionPacks', description='Installed extension packs'
    )


class QueryContext(KodexaBaseModel):
    page_size: Optional[int] = Field(
        None, alias='pageSize', description='Page size (default 20)'
    )
    page: Optional[int] = Field(None, description='Page number (default 1)')
    sort: Optional[str] = Field(None, description='Sorts to apply')
    filter: Optional[str] = Field(None, description='Simple filter to apply')
    query: Optional[str] = Field(
        None, description='Simple query to apply (if available)'
    )


class Sort(KodexaBaseModel):
    empty: Optional[bool] = None
    sorted: Optional[bool] = None
    unsorted: Optional[bool] = None


class EventType(Enum):
    created = 'CREATED'
    deleted = 'DELETED'
    updated = 'UPDATED'


class ValidationState1(Enum):
    valid = 'VALID'
    invalid = 'INVALID'
    warning = 'WARNING'


class DataAttributeValues(KodexaBaseModel):
    value: Optional[str] = None
    truncated: Optional[bool] = None
    tag: str
    tag_uuid: Optional[str] = Field(None, alias='tagUuid')
    date_value: Optional[datetime] = Field(None, alias='dateValue')
    float_value: Optional[float] = Field(None, alias='floatValue')
    decimal_value: Optional[float] = Field(None, alias='decimalValue')
    number_value: Optional[int] = Field(None, alias='numberValue')
    boolean_value: Optional[bool] = Field(None, alias='booleanValue')
    string_value: Optional[str] = Field(None, alias='stringValue')
    attribute_status: Optional[AttributeStatus] = Field(None, alias='attributeStatus')
    confidence: Optional[float] = None
    validation_state: ValidationState1 = Field(
        ..., alias='validationState', description='The current validation state'
    )


class AccessTokenDetails(KodexaBaseModel):
    type: Optional[str] = None
    token: Optional[str] = None


class BulkDelete(KodexaBaseModel):
    all: Optional[bool] = None
    document_family_ids: Optional[List[str]] = Field(None, alias='documentFamilyIds')


class User(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    email: str
    first_name: str = Field(..., alias='firstName')
    last_name: str = Field(..., alias='lastName')
    activated: Optional[bool] = None
    platform_admin: Optional[bool] = Field(None, alias='platformAdmin')
    password_reset_date: Optional[datetime] = Field(None, alias='passwordResetDate')
    last_connected: Optional[datetime] = Field(None, alias='lastConnected')
    user_storage: Optional[UserStorage] = Field(None, alias='userStorage')
    has_image: Optional[bool] = Field(None, alias='hasImage')


class ChartWidget(DashboardWidget):
    options: Optional[Dict[str, Any]] = None


class Credential(SlugBasedMetadata):
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )
    credential_type: Optional[str] = Field(None, alias='credentialType')
    properties: Optional[Dict[str, Any]] = Field(
        None, description='A map of key/value pairs that define the credential'
    )


class DashboardColumn(KodexaBaseModel):
    id: Optional[str] = None
    cols: Optional[str] = None
    height: Optional[str] = None
    widgets: Optional[List[DashboardWidget]] = None


class DashboardRow(KodexaBaseModel):
    id: Optional[str] = None
    height: Optional[str] = None
    columns: Optional[List[DashboardColumn]] = None


class DeploymentMetadata(KodexaBaseModel):
    deployment_type: Optional[DeploymentType] = Field(None, alias='deploymentType')
    min_replicas: Optional[int] = Field(None, alias='minReplicas')
    max_replicas: Optional[int] = Field(None, alias='maxReplicas')
    reserved_concurrency: Optional[int] = Field(None, alias='reservedConcurrency')
    limits: Optional[ContainerResources] = None
    requests: Optional[ContainerResources] = None
    memory_assigned: Optional[str] = Field(None, alias='memoryAssigned')
    scheduler_token: Optional[str] = Field(None, alias='schedulerToken')
    service_name: Optional[str] = Field(None, alias='serviceName')
    container_name: Optional[str] = Field(None, alias='containerName')
    function_arn: Optional[str] = Field(None, alias='functionArn')
    environment: Optional[Dict[str, str]] = None
    pod_match_labels: Optional[List[MatchLabel]] = Field(None, alias='podMatchLabels')


class DockerSource(ExtensionPackSource):
    location: Optional[str] = None


class ExceptionDetails(KodexaBaseModel):
    message: Optional[str] = None
    status_code: Optional[int] = Field(None, alias='statusCode')
    error_message: Optional[str] = Field(None, alias='errorMessage')
    error_type: Optional[str] = Field(None, alias='errorType')
    executed_version: Optional[str] = Field(None, alias='executedVersion')
    advice: Optional[str] = None
    description: Optional[str] = None
    cause: Optional[Dict[str, Any]] = None
    documentation_url: Optional[str] = Field(None, alias='documentationUrl')
    stack_trace: Optional[List[Dict[str, Any]]] = Field(None, alias='stackTrace')
    help: Optional[str] = None
    option_errors: Optional[Dict[str, Any]] = Field(
        None, alias='optionErrors'
    )
    validation_errors: Optional[List[ValidationError]] = Field(
        None, alias='validationErrors'
    )


class ExtensionPack(SlugBasedMetadata):
    org_slug: Optional[constr(regex=r'^[a-zA-Z0-9\-_]{0,100}$')] = Field(
        None, alias='orgSlug'
    )
    slug: Optional[constr(regex=r'^[a-zA-Z0-9\-_]{0,100}$')] = None
    name: Optional[str] = None
    description: Optional[str] = None
    public_access: Optional[bool] = Field(None, alias='publicAccess')
    pack_uri: Optional[str] = Field(None, alias='packUri')
    status: Optional[Status] = None
    deployable: Optional[bool] = None
    services: Optional[List[SlugBasedMetadata]] = None
    source: Optional[ExtensionPackSource] = None
    deployment: Optional[DeploymentMetadata] = None


class ModelRuntime(SlugBasedMetadata):
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )
    inference_action: Optional[str] = Field(
        None,
        alias='inferenceAction',
        description='The reference to the action that will be used for inference',
    )
    training_action: Optional[str] = Field(
        None,
        alias='trainingAction',
        description='A reference to the action that will be used for training',
    )
    deployment_type: Optional[DeploymentType1] = Field(
        None,
        alias='deploymentType',
        description='The deployment to use, local means that the model runtime can be re-used across models, while container means that the model store must be deployed with the model runtime',
    )
    container_url: Optional[str] = Field(
        None,
        alias='containerUrl',
        description='The URL of the container to use if the deployment type is CONTAINER',
    )
    deployment_defaults: Optional[DeploymentMetadata] = Field(
        None, alias='deploymentDefaults'
    )


class ModelTrainExecution(KodexaBaseModel):
    options: Optional[Dict[str, Any]] = None
    option_types: Optional[Dict[str, str]] = Field(None, alias='optionTypes')
    status: Optional[Status1] = None
    model_store_ref: Optional[str] = Field(None, alias='modelStoreRef')
    training_store_ref: Optional[str] = Field(None, alias='trainingStoreRef')
    extension_pack_ref: Optional[str] = Field(None, alias='extensionPackRef')
    subscriptions: Optional[List[EventSubscription]] = None
    exception_details: Optional[ExceptionDetails] = Field(
        None, alias='exceptionDetails'
    )


class Option(KodexaBaseModel):
    group_options: Optional[List[Option]] = Field(None, alias='groupOptions')
    tab_name: Optional[str] = Field(None, alias='tabName')
    name: Optional[str] = None
    label: Optional[str] = None
    false_label: Optional[str] = Field(None, alias='falseLabel')
    hint: Optional[str] = None
    required: Optional[bool] = None
    type: Optional[str] = None
    list_type: Optional[str] = Field(None, alias='listType')
    list_label: Optional[str] = Field(None, alias='listLabel')
    list_description: Optional[str] = Field(None, alias='listDescription')
    feature_flag: Optional[str] = Field(None, alias='featureFlag')
    default: Optional[Any] = None
    description: Optional[str] = None
    show_if: Optional[str] = Field(None, alias='showIf')
    possible_values: Optional[List[PossibleValue]] = Field(None, alias='possibleValues')


class Overlay(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the taxon')
    name: Optional[str] = None
    conditions: Optional[List[OverlayCondition]] = None


class PipelineImplementationMetadata(KodexaBaseModel):
    steps: Optional[List[PipelineStepMetadata]] = Field(
        None, description='The metadata for the steps in this pipeline'
    )


class ProjectAssistant(KodexaBaseModel):
    name: Optional[str] = None
    description: Optional[str] = None
    assistant_definition_ref: Optional[str] = Field(
        None, alias='assistantDefinitionRef'
    )
    options: Optional[Dict[str, Any]] = None
    stores: Optional[List[str]] = None
    schedules: Optional[List[ScheduleDefinition]] = None
    subscription: Optional[str] = None


class ProjectDashboard(KodexaBaseModel):
    slug: Optional[constr(regex=r'^[a-zA-Z0-9\-_]{0,255}$')] = None
    name: Optional[str] = None
    description: Optional[str] = None
    rows: Optional[List[DashboardRow]] = None
    template_ref: Optional[str] = Field(None, alias='templateRef')


class SavedFilter(KodexaBaseModel):
    id: Optional[str] = None
    name: Optional[str] = None
    filter: Optional[StoreFilter] = None


class Store(SlugBasedMetadata):
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )
    metadata: Optional[ContentMetadata] = None
    store_type: Optional[StoreType1] = Field(
        None, alias='storeType', description='The type of object the store will contain'
    )
    searchable: Optional[bool] = Field(
        None, description='Is the store indexed, and thus searchable'
    )
    store_purpose: Optional[StorePurpose1] = Field(
        None,
        alias='storePurpose',
        description='The purpose of the store (used by UI and assistants to understand how to interact with the store events)',
    )
    view_options: Optional[StoreViewOptions] = Field(None, alias='viewOptions')
    saved_filters: Optional[List[SavedFilter]] = Field(
        None,
        alias='savedFilters',
        description='Filters that have been saved for this store',
    )


class Taxon(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the taxon')
    label: Optional[str] = Field(None, description='The text to display for this taxon')
    generate_name: Optional[bool] = Field(
        None,
        alias='generateName',
        description='Is the name generated, this allows that you can change displays without impacted existing content',
    )
    group: Optional[bool] = Field(
        None,
        description="Is this taxon a group, and therefore can't have a value, can only have children",
    )
    name: Optional[constr(regex=r'^[a-zA-Z0-9\-_]{0,255}$')] = Field(
        None,
        description='The name to be used, note based on the hierarchy the actual label in the document will have the parent name too',
    )
    value_path: Optional[ValuePath] = Field(
        None,
        alias='valuePath',
        description='Where to get the value for this taxon when extracting',
    )
    metadata_value: Optional[MetadataValue] = Field(
        None,
        alias='metadataValue',
        description='If the type is metadata this will be the metadata option',
    )
    data_path: Optional[str] = Field(
        None,
        alias='dataPath',
        description='The path to the data, based on the data inside the label (tag) within the document',
    )
    expression: Optional[str] = Field(
        None,
        description='If the taxon is based on expression, this is the expression based on the available objects',
    )
    nullable: Optional[bool] = Field(
        None, description='Determine if the value of the taxon can be null (unknown)'
    )
    null_value: Optional[str] = Field(
        None,
        alias='nullValue',
        description='Allows the setting of a value to replace null if the taxon is nullable',
    )
    description: Optional[str] = Field(None, description='The description of the taxon')
    enabled: Optional[bool] = Field(
        None, description='Is the taxon enabled (used in the UI)'
    )
    color: Optional[str] = Field(
        None, description='Hex encoding of the color to use for the taxon'
    )
    children: Optional[List[Taxon]] = Field(
        None, description='The children under this taxon'
    )
    options: Optional[List[Option]] = Field(
        None,
        description='Options that can be shown for the taxon (usually used in assistant taxonomies)',
    )
    related_taxons: Optional[List[RelatedTaxon]] = Field(
        None,
        alias='relatedTaxons',
        description='A list of relationships to other taxons and the purpose of the relationship',
    )
    node_types: Optional[List[str]] = Field(
        None,
        alias='nodeTypes',
        description='A list of the node types that this taxon applies to (empty means everything), used in the UI',
    )
    taxon_type: Optional[TaxonType] = Field(
        None,
        alias='taxonType',
        description='Expected data type to coalesce to (defaults to STRING)',
    )
    selection_options: Optional[List[SelectionOption]] = Field(
        None,
        alias='selectionOptions',
        description='If data type is SELECTION, this is the list of available options',
    )
    type_features: Optional[Dict[str, Any]] = Field(
        None,
        alias='typeFeatures',
        description='Additional features for the type handling',
    )
    path: Optional[str] = Field(None, description='The path to the node')
    use_post_expression: Optional[bool] = Field(
        None, alias='usePostExpression', description='Use a post extraction expression'
    )
    post_expression: Optional[str] = Field(
        None,
        alias='postExpression',
        description='An expression that is applied post extraction of the data',
    )


class Taxonomy(SlugBasedMetadata):
    type: Optional[str] = Field(None, description='The metadata object type')
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )
    taxonomy_type: Optional[TaxonomyType1] = Field(
        None, alias='taxonomyType', description='The type of taxonomy'
    )
    enabled: Optional[bool] = Field(
        None, description='Is the taxonomy enabled (effects display in the UI)'
    )
    taxons: Optional[List[Taxon]] = Field(
        None, description="The hierarchical structure of taxon's in this taxonomy"
    )
    overlays: Optional[List[Overlay]] = Field(
        None,
        description='Overlays provide the ability to apply validation, normalization and enrichment',
    )
    total_taxons: Optional[int] = Field(
        None,
        alias='totalTaxons',
        description='The total number of taxons in the taxonomy',
    )


class ContentObject(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    content_type: ContentType = Field(
        ..., alias='contentType', description='The type of content'
    )
    document_version: Optional[str] = Field(None, alias='documentVersion')
    index: Optional[int] = None
    labels: Optional[List[Label]] = None
    metadata: Optional[Dict[str, Any]] = None
    mixins: Optional[List[str]] = None
    created: Optional[datetime] = None
    modified: Optional[datetime] = None
    size: Optional[int] = None
    store_ref: Optional[str] = Field(None, alias='storeRef')
    document_family_id: Optional[str] = Field(None, alias='documentFamilyId')


class DocumentAssignment(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    user: User


class DocumentFamily(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    document_status: Optional[DocumentStatus] = Field(None, alias='documentStatus')
    assignments: Optional[List[DocumentAssignment]] = Field(
        None, description='A list of the assignments to users for this document'
    )
    store_ref: Optional[str] = Field(
        None,
        alias='storeRef',
        description='The reference to the store that is holding this document family',
    )
    path: str = Field(..., description='The path to the document family in the store')
    locked: Optional[bool] = Field(
        None,
        description='Is the document family locked. If locked then you can no longer modify or add any new document transitions',
    )
    created: Optional[datetime] = Field(None, description='Date/Time Created')
    modified: Optional[datetime] = Field(None, description='Date/Time Modified')
    size: Optional[int] = Field(
        None, description='Size of the original native content in bytes'
    )
    indexed: Optional[bool] = Field(
        None, description='Is the document family indexed for search'
    )
    content_objects: Optional[List[ContentObject]] = Field(
        None,
        alias='contentObjects',
        description='An ordered list of the content objects in the document family',
    )
    transitions: Optional[List[DocumentTransition]] = Field(
        None, description='An ordered list of the transitions in the document family'
    )
    labels: Optional[List[Label]] = Field(
        None, description='The labels from the latest content object in the family'
    )
    mixins: Optional[List[str]] = Field(
        None, description='The mixins from the latest content object in the family'
    )
    classes: Optional[List[ContentClassification]] = Field(
        None,
        description='The classification classes from the latest content object in the family',
    )


class FeatureSet(KodexaBaseModel):
    node_features: Optional[List[NodeFeatures]] = Field(None, alias='nodeFeatures')


class DataObject(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    document_family: DocumentFamily = Field(..., alias='documentFamily')
    taxonomy_ref: Optional[str] = Field(None, alias='taxonomyRef')
    path: Optional[str] = None
    row_num: Optional[int] = Field(None, alias='rowNum')
    source_ordering: Optional[str] = Field(None, alias='sourceOrdering')
    date_time: Optional[datetime] = Field(None, alias='dateTime')
    lineage: Optional[DataLineage] = None
    attributes: Optional[List[DataAttribute]] = None
    parent_id: Optional[str] = Field(None, alias='parentId')
    store_ref: Optional[str] = Field(None, alias='storeRef')
    taxon: Optional[Taxon] = None


class Note(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    document_family: Optional[DocumentFamily] = Field(None, alias='documentFamily')
    data_attribute: Optional[DataAttribute] = Field(None, alias='dataAttribute')
    user: Optional[User] = None
    content: Optional[str] = None


class ExecutionStep(KodexaBaseModel):
    id: Optional[str] = None
    status: Optional[Status4] = None
    exception_details: Optional[ExceptionDetails] = Field(
        None, alias='exceptionDetails'
    )
    name: Optional[str] = None
    start: Optional[datetime] = None
    end: Optional[datetime] = None
    processing_time: Optional[int] = Field(None, alias='processingTime')
    options: Optional[Dict[str, Any]] = None
    option_types: Optional[Dict[str, str]] = Field(None, alias='optionTypes')
    context: Optional[Dict[str, Any]] = None
    content_objects: Optional[List[ContentObject]] = Field(None, alias='contentObjects')
    input_id: Optional[str] = Field(None, alias='inputId')
    output_id: Optional[str] = Field(None, alias='outputId')
    ref: Optional[str] = None
    extension_pack_ref: Optional[str] = Field(None, alias='extensionPackRef')
    step_type: Optional[StepType1] = Field(None, alias='stepType')


class Role(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    name: str
    users: Optional[List[User]] = None
    teams: Optional[List[Team]] = None


class Workflow(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    active: Optional[bool] = None
    definition: Optional[WorkflowDefinition] = None


class Membership(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    created_by: Optional[str] = Field(None, alias='createdBy')
    updated_by: Optional[str] = Field(None, alias='updatedBy')
    role: Optional[Role1] = None
    organization: Optional[Organization] = None
    user: Optional[User] = None


class SearchContent(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The unique ID of the search content')
    store_ref: Optional[str] = Field(
        None,
        alias='storeRef',
        description='The ref of the store containing the document family',
    )
    document_family_id: Optional[str] = Field(
        None,
        alias='documentFamilyId',
        description='The unique ID of the document family',
    )
    container_type: Optional[str] = Field(
        None, alias='containerType', description='The container node type'
    )
    container_uuid: Optional[str] = Field(
        None, alias='containerUuid', description='The container node UUID'
    )
    container_index: Optional[int] = Field(
        None, alias='containerIndex', description='The index of the container'
    )
    source_ordering: Optional[int] = Field(
        None,
        alias='sourceOrdering',
        description='The source ordering for the content (starting at 0)',
    )
    entities: Optional[List[SearchEntity]] = Field(
        None, description='Entities found in the search content'
    )
    node_uuid: Optional[str] = Field(
        None, alias='nodeUuid', description='The unique ID of the content node'
    )
    content: Optional[str] = Field(None, description='The indexed content')
    document_family: Optional[DocumentFamily] = Field(None, alias='documentFamily')


class PageableObject(KodexaBaseModel):
    offset: Optional[int] = None
    sort: Optional[Sort] = None
    paged: Optional[bool] = None
    unpaged: Optional[bool] = None
    page_number: Optional[int] = Field(None, alias='pageNumber')
    page_size: Optional[int] = Field(None, alias='pageSize')


class PageTeam(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Team]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageTaxonomy(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Taxonomy]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageStore(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Store]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageDocumentFamily(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[DocumentFamily]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageDataObject(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[DataObject]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class AuditEvent(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    platform_user: Optional[User] = Field(None, alias='platformUser')
    document_family: Optional[DocumentFamily] = Field(None, alias='documentFamily')
    data_object: Optional[DataObject] = Field(None, alias='dataObject')
    data_attribute: Optional[DataAttribute] = Field(None, alias='dataAttribute')
    tag: Optional[str] = None
    event_type: Optional[EventType] = Field(None, alias='eventType')
    old_value: Optional[DataAttributeValues] = Field(None, alias='oldValue')
    new_value: Optional[DataAttributeValues] = Field(None, alias='newValue')


class PageAuditEvent(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[AuditEvent]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageNote(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Note]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageSession(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Session]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageRole(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Role]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageOrganization(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Organization]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageModelRuntime(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[ModelRuntime]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageMembership(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Membership]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageLabel(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Label]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageExtensionPack(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[ExtensionPack]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageExecutionLogEntry(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[ExecutionLogEntry]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageCredential(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Credential]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageAccessToken(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[AccessToken]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class AssistantMetadata(KodexaBaseModel):
    avatar: Optional[Avatar] = None
    tags: Optional[List[str]] = None
    tabs: Optional[List[TabGroup]] = None
    options: Optional[List[Option]] = None


class CustomEvent(KodexaBaseModel):
    name: Optional[constr(regex=r'^[a-zA-Z0-9\-_]{0,40}$')] = Field(
        None, description='The name of the event'
    )
    icon: Optional[str] = Field(
        None, description='The name of a Material Design Icon to use for the event'
    )
    label: Optional[str] = Field(
        None, description='The label to use on the event in the UI'
    )
    description: Optional[str] = Field(
        None, description='The long description for the event'
    )
    content_object: Optional[bool] = Field(
        None,
        alias='contentObject',
        description='Does the event require a content object',
    )
    options: Optional[List[Option]] = Field(
        None, description='Options available for this event'
    )


class Dashboard(SlugBasedMetadata):
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )
    rows: Optional[List[DashboardRow]] = None


class ModelContentMetadata(ContentMetadata):
    type: Optional[str] = Field(None, description='The type of content metadata')
    model_runtime_ref: Optional[str] = Field(
        None,
        alias='modelRuntimeRef',
        description='The reference to the model runtime to use',
    )
    state_hash: Optional[str] = Field(None, alias='stateHash')
    model_runtime_parameters: Optional[Dict[str, Any]] = Field(
        None,
        alias='modelRuntimeParameters',
        description='The parameters to be passed to the model runtime',
    )
    state: Optional[State] = Field(
        None, description='The state of the model in this store'
    )
    trainable: Optional[bool] = Field(None, description='Can this model be trained')
    vue_template: Optional[str] = Field(
        None,
        alias='vueTemplate',
        description='The Vue template to render for the configuration of this model',
    )
    training_options: Optional[Dict[str, Any]] = Field(
        None, alias='trainingOptions', description='The training options for this model'
    )
    training_parameters: Optional[Dict[str, Any]] = Field(
        None,
        alias='trainingParameters',
        description='The values for the training options',
    )
    inference_options: Optional[Dict[str, Any]] = Field(
        None,
        alias='inferenceOptions',
        description='The inference options for this model',
    )
    build_statistics: Optional[Dict[str, Any]] = Field(
        None,
        alias='buildStatistics',
        description='Build statistics (note this will update if the model is training)',
    )
    final_statistics: Optional[Dict[str, Any]] = Field(
        None, alias='finalStatistics', description='Final statistics from the model'
    )
    deployment: Optional[DeploymentMetadata] = None
    taxonomy: Optional[Taxonomy] = None
    additional_taxon_options: Optional[List[Option]] = Field(
        None,
        alias='additionalTaxonOptions',
        description='This are additional properties that can be set on a label when the model is part of the project',
    )
    last_train_event: Optional[ModelTrainExecution] = Field(
        None, alias='lastTrainEvent'
    )
    contents: Optional[List[str]] = Field(
        None,
        description='A list of the paths (with wildcards) that hold the content of this model',
    )
    ignored_contents: Optional[List[str]] = Field(
        None,
        alias='ignoredContents',
        description='A list of the paths (with wildcards) that are ignored when picking up the content of this model',
    )
    base_dir: Optional[str] = Field(
        None,
        alias='baseDir',
        description='A base directory that was used for uploading of the model',
    )


class ObjectMetadata(KodexaBaseModel):
    options: Optional[List[Option]] = None


class Pipeline(SlugBasedMetadata):
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )
    metadata: Optional[PipelineImplementationMetadata] = None


class ProjectTaxonomy(KodexaBaseModel):
    slug: Optional[str] = None
    name: Optional[str] = None
    description: Optional[str] = None
    taxonomy_type: Optional[TaxonomyType] = Field(
        None, alias='taxonomyType', description='The type of taxonomy'
    )
    taxons: Optional[List[Taxon]] = Field(
        None, description="The hierarchical structure of taxon's in this taxonomy"
    )
    template_ref: Optional[str] = Field(None, alias='templateRef')


class ProjectTemplate(SlugBasedMetadata):
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )
    stores: Optional[List[ProjectStore]] = Field(
        None, description='The stores that will be created with the project template'
    )
    assistants: Optional[List[ProjectAssistant]] = Field(
        None,
        description='The assistants that will be created with the project template',
    )
    taxonomies: Optional[List[ProjectTaxonomy]] = Field(
        None,
        description='The taxonomies that will be created with the project template',
    )
    dashboards: Optional[List[ProjectDashboard]] = Field(
        None,
        description='The dashboards that will be created with the project template',
    )
    help_url: Optional[str] = Field(
        None,
        alias='helpUrl',
        description='A help URL where you can learn more about the assistant',
    )
    category: Optional[Category] = Field(
        None, description='The category of project template'
    )


class ExecutionPipeline(KodexaBaseModel):
    valid: Optional[bool] = None
    ref: Optional[str] = None
    id: Optional[str] = None
    exceptions: Optional[List[ExceptionDetails]] = None
    steps: Optional[List[ExecutionStep]] = None


class AssistantResponsePipeline(KodexaBaseModel):
    description: Optional[str] = None
    pipeline: Optional[Pipeline] = None
    write_back_to_store: Optional[bool] = Field(None, alias='writeBackToStore')
    data_source_ref: Optional[str] = Field(None, alias='dataSourceRef')
    taxonomy_refs: Optional[List[str]] = Field(None, alias='taxonomyRefs')
    labels_to_apply: Optional[List[str]] = Field(None, alias='labelsToApply')
    logging_enabled: Optional[bool] = Field(None, alias='loggingEnabled')


class PageUser(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[User]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageProjectTemplate(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[ProjectTemplate]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PagePipeline(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Pipeline]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageDashboard(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Dashboard]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class Action(SlugBasedMetadata):
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )
    step: Optional[StepImplementation] = None
    metadata: Optional[ObjectMetadata] = None


class AssistantDefinition(SlugBasedMetadata):
    template: Optional[bool] = None
    extension_pack_ref: Optional[str] = Field(
        None,
        alias='extensionPackRef',
        description='The reference to the extension pack (if the metadata object was created by an extension pack)',
    )
    schedulable: Optional[bool] = Field(
        None, description='The assistant can be scheduled'
    )
    reactive: Optional[bool] = Field(
        None, description='The assistant is reactive to content changes'
    )
    assistant: Optional[AssistantImplementation] = None
    metadata: Optional[AssistantMetadata] = None
    services: Optional[List[SlugBasedMetadata]] = Field(
        None, description='Services used by the assistant'
    )
    processing_taxonomies: Optional[List[AssistantTaxonomy]] = Field(
        None,
        alias='processingTaxonomies',
        description='Taxonomies that the assistant uses',
    )
    options: Optional[List[Option]] = Field(
        None, description='Options for the assistant'
    )
    additional_taxon_options: Optional[List[Option]] = Field(
        None,
        alias='additionalTaxonOptions',
        description='This are additional properties that can be set on a label when the assistant is part of the project',
    )
    event_types: Optional[List[CustomEvent]] = Field(
        None,
        alias='eventTypes',
        description='Custom event types that the assistant is able to response to',
    )
    default_schedules: Optional[List[ScheduleDefinition]] = Field(
        None,
        alias='defaultSchedules',
        description='The default schedules that the assistant has',
    )
    subscription: Optional[str] = Field(
        None,
        description='The subscription that the assistant has, this can not be overridden by the subscription in the instance',
    )


class Execution(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    description: Optional[str] = None
    targets: Optional[ExecutionTargets] = None
    session: Optional[Session] = None
    start_date: Optional[datetime] = Field(None, alias='startDate')
    end_date: Optional[datetime] = Field(None, alias='endDate')
    processing_time: Optional[int] = Field(None, alias='processingTime')
    logging_enabled: Optional[bool] = Field(None, alias='loggingEnabled')
    status: Optional[Status3] = None
    exception_details: Optional[ExceptionDetails] = Field(
        None, alias='exceptionDetails'
    )
    status_details: Optional[StatusDetails] = Field(None, alias='statusDetails')
    pipeline: Optional[ExecutionPipeline] = None
    parameters: Optional[Dict[str, Any]] = None
    model_train: Optional[ModelTrainExecution] = Field(None, alias='modelTrain')
    custom_options: Optional[Dict[str, Any]] = Field(
        None, alias='customOptions'
    )
    context: Optional[Dict[str, Any]] = None
    child_executions: Optional[List[Execution]] = Field(None, alias='childExecutions')
    content_objects: Optional[List[ContentObject]] = Field(None, alias='contentObjects')


class AssistantExecutionResponse(KodexaBaseModel):
    text: Optional[str] = None
    pipelines: Optional[List[AssistantResponsePipeline]] = None


class PageExecution(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Execution]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageSlugBasedMetadata(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[
        List[
            Union[
                Action,
                AssistantDefinition,
                Credential,
                Dashboard,
                ExtensionPack,
                ModelRuntime,
                Pipeline,
                ProjectTemplate,
                Store,
                Taxonomy,
            ]
        ]
    ] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageAssistantDefinition(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[AssistantDefinition]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PageAction(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Action]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class Project(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    organization: Optional[Organization] = None
    name: Optional[str] = None
    description: Optional[str] = None
    metadata: Optional[ProjectMetadata] = None
    show_tasks: Optional[bool] = Field(None, alias='showTasks')
    show_thumbnails: Optional[bool] = Field(None, alias='showThumbnails')
    has_image: Optional[bool] = Field(None, alias='hasImage')
    project_template: Optional[ProjectTemplateMetadata] = Field(
        None, alias='projectTemplate'
    )
    workflow: Optional[Workflow] = None
    labels: Optional[List[Label]] = None
    document_statuses: Optional[List[DocumentStatus]] = Field(
        None, alias='documentStatuses'
    )
    attribute_statuses: Optional[List[AttributeStatus]] = Field(
        None, alias='attributeStatuses'
    )


class ProjectTemplateMetadata(KodexaBaseModel):
    id: Optional[str] = None
    uuid: Optional[str] = None
    version: Optional[str] = None
    organization: Optional[Organization] = None
    slug: str
    metadata: Optional[ProjectTemplate] = None
    extension_pack_ref: Optional[str] = Field(None, alias='extensionPackRef')
    projects: Optional[List[Project]] = None
    ref: Optional[str] = None


class Assistant(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    subscription: Optional[str] = None
    schedules: Optional[List[AssistantSchedule]] = None
    project: Optional[Project] = None
    name: str
    description: Optional[str] = None
    assistant_definition_ref: Optional[str] = Field(
        None, alias='assistantDefinitionRef'
    )
    logging_enabled: Optional[bool] = Field(None, alias='loggingEnabled')
    active: Optional[bool] = None
    run_on_existing_content: Optional[bool] = Field(None, alias='runOnExistingContent')
    options: Optional[Dict[str, Any]] = None
    validation_errors: Optional[ValidationResults] = Field(
        None, alias='validationErrors'
    )
    definition: Optional[AssistantDefinition] = None


class AssistantExecution(KodexaBaseModel):
    assistant_id: Optional[str] = Field(None, alias='assistantId')
    assistant_name: Optional[str] = Field(None, alias='assistantName')
    ref: Optional[str] = None
    options: Optional[Dict[str, Any]] = None
    option_types: Optional[Dict[str, str]] = Field(None, alias='optionTypes')
    status: Optional[Status5] = None
    exception_details: Optional[ExceptionDetails] = Field(
        None, alias='exceptionDetails'
    )
    event: Optional[Union[AssistantEvent, ContentEvent, ScheduledEvent]] = None
    response: Optional[AssistantExecutionResponse] = None
    start_date: Optional[datetime] = Field(None, alias='startDate')
    end_date: Optional[datetime] = Field(None, alias='endDate')
    processing_time: Optional[int] = Field(None, alias='processingTime')


class BaseEvent(KodexaBaseModel):
    __root__: Union[BaseEvent1, ContentEvent, ScheduledEvent, AssistantEvent]


class ExecutionEvent(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    type: Type1
    status: Optional[Status6] = None
    execution: Optional[Execution] = None
    store_ref: Optional[str] = Field(None, alias='storeRef')
    document_family_id: Optional[str] = Field(None, alias='documentFamilyId')
    session_id: str = Field(..., alias='sessionId')
    token: str
    pipeline: Optional[ExecutionPipeline] = None
    assistant: Optional[AssistantExecution] = None
    model_train: Optional[ModelTrainExecution] = Field(None, alias='modelTrain')
    source: Optional[Dict[str, Any]] = None
    payload: Optional[Dict[str, Any]] = None
    input_id: Optional[str] = Field(None, alias='inputId')
    platform_url: Optional[str] = Field(None, alias='platformUrl')
    session_call_back_url: Optional[str] = Field(None, alias='sessionCallBackUrl')
    created: Optional[datetime] = None
    start_date: Optional[datetime] = Field(None, alias='startDate')
    end_date: Optional[datetime] = Field(None, alias='endDate')


class PlatformEvent(KodexaBaseModel):
    id: Optional[str] = Field(None, description='The ID of the object')
    uuid: Optional[str] = None
    created_on: Optional[datetime] = Field(None, alias='createdOn')
    updated_on: Optional[datetime] = Field(None, alias='updatedOn')
    date_time: Optional[datetime] = Field(None, alias='dateTime')
    assistant: Optional[Assistant] = None
    event_detail: Optional[Union[AssistantEvent, ContentEvent, ScheduledEvent]] = Field(
        None, alias='eventDetail'
    )
    document_family: Optional[DocumentFamily] = Field(None, alias='documentFamily')


class PageProject(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[Project]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class PagePlatformEvent(KodexaBaseModel):
    total_elements: Optional[int] = Field(None, alias='totalElements')
    total_pages: Optional[int] = Field(None, alias='totalPages')
    first: Optional[bool] = None
    last: Optional[bool] = None
    size: Optional[int] = None
    content: Optional[List[PlatformEvent]] = None
    number: Optional[int] = None
    sort: Optional[Sort] = None
    number_of_elements: Optional[int] = Field(None, alias='numberOfElements')
    pageable: Optional[PageableObject] = None
    empty: Optional[bool] = None


class AssistantEvent(KodexaBaseModel):
    type: Optional[str] = None
    content_object: Optional[ContentObject] = Field(None, alias='contentObject')
    options: Optional[Dict[str, Any]] = None
    event_type: Optional[str] = Field(None, alias='eventType')
    assistant: Optional[Assistant] = None


class ContentEvent(KodexaBaseModel):
    type: Optional[str] = None
    content_object: Optional[ContentObject] = Field(None, alias='contentObject')
    document_family: Optional[DocumentFamily] = Field(None, alias='documentFamily')
    object_event_type: Optional[ObjectEventType] = Field(None, alias='objectEventType')


class ScheduledEvent(KodexaBaseModel):
    type: Optional[str] = None
    last_event: Optional[datetime] = Field(None, alias='lastEvent')
    next_event: Optional[datetime] = Field(None, alias='nextEvent')


Option.update_forward_refs()
Taxon.update_forward_refs()
Execution.update_forward_refs()
Project.update_forward_refs()
AssistantExecution.update_forward_refs()
BaseEvent.update_forward_refs()
PlatformEvent.update_forward_refs()



