# Applied Natural Language Processing in the Enterpris

This is the companion repo for _Applied Natural Language Processing in the Enterprise_, an O'Reilly Media publication by Ankur A. Patel and Ajay Uppili Arasanipalai. Here, you will find all the source code from the book, published here on GitHub for your convenience.

Follow the steps below to get started with setting up your environment and running the code examples.

## Setup

To install all the required libraries and dependancies, run the following command:

```
pip install nlpbook
```

However, the reccomemded approch is to use `conda`, a cross-platform, language-agnostic package manager that automatically handles . To install in your environment using `conda`, run the following command:

```
conda install -c nlpbook nlpbook
```

Alternatively, if you'd like to keep your environment for this book isolated form the rest of your system, run the following commands:

```
conda create -n nlpbook
conda activate nlpbook
conda install -c nlpbook nlpbook
```

Then run `conda activate nlpbook` everytime you want to return to your environment.

## Getting the Code

All publicly released code is in this repository. The simplest way to get started is via Git:

```
git clone https://github.com/nlpbook/nlpbook.git
```

If you're on Windows or another platform that doesn't already have `git` installed, you may need to obtain a [Git client](https://git-scm.com/downloads).

If you want a specific version to match the copy of the book you have (this can occasionally change), you can find previous versions on the [releases page](https://github.com/nlpbook/nlpbook/releases).

## How This Repo is Organized

Each chapter in the book has a corresponding notebook in the root of this project repository. They are named `chXX.ipynb` for the chapter XX. The appendices are named `apXX.ipynb`.

> **Note:** This repo only contains the code for the chapters, not the actual text in the book. For the complete picture, . Chapters 1, 2, and 3 have been entirely open-sourced and on behalf of O'Reilly.

Once you'd navigated to the `nlpbook` project directory, you can lauch a Jupyter client like Jupyter Lab, Jupyter Notebooks, or VS Code to view and run the notebooks.

## Contributions and Errata

We welcome and suggestions, feedback, and errata from readers. If you notice anything that seems off in the book or could use improvement, we've love to hear from you. Feel free to submit an issue here on GitHub, or on our errata page.

## Copyright Notice
