import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of accounts to be added to the share.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/share#accounts Share#accounts}
    */
    readonly accounts?: string[];
    /**
    * Specifies a comment for the managed account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/share#comment Share#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the identifier for the share; must be unique for the account in which the share is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/share#name Share#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/share snowflake_share}
*/
export declare class Share extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_share";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/share snowflake_share} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ShareConfig
    */
    constructor(scope: Construct, id: string, config: ShareConfig);
    private _accounts?;
    get accounts(): string[];
    set accounts(value: string[]);
    resetAccounts(): void;
    get accountsInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
