"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSipMediaApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const pstnCustomResources_1 = require("./pstnCustomResources");
const sipMediaApplicationValidator_1 = require("./sipMediaApplicationValidator");
class ChimeSipMediaApp extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, endpoint, region } = props;
        sipMediaApplicationValidator_1.sipMediaApplicationValidator(props);
        const sipMediaAppRequest = new pstnCustomResources_1.PSTNResources(this, 'sipMediaAppRequest', {
            resourceType: 'SMA',
            uid: uid,
            properties: {
                region: region || cdk.Stack.of(this).region,
                name: name ?? uid,
                endpoint: endpoint,
            },
        });
        this.sipMediaAppId =
            sipMediaAppRequest.pstnCustomResource.getAttString('sipMediaAppId');
    }
}
exports.ChimeSipMediaApp = ChimeSipMediaApp;
_a = JSII_RTTI_SYMBOL_1;
ChimeSipMediaApp[_a] = { fqn: "cdk-amazon-chime-resources.ChimeSipMediaApp", version: "0.1.166" };
//# sourceMappingURL=data:application/json;base64,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