"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnStageV2 = exports.CfnRouteResponseV2 = exports.CfnRouteV2 = exports.CfnModelV2 = exports.CfnIntegrationResponseV2 = exports.CfnIntegrationV2 = exports.CfnDomainNameV2 = exports.CfnDeploymentV2 = exports.CfnAuthorizerV2 = exports.CfnApiMappingV2 = exports.CfnApiV2 = void 0;
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Originally generated from the AWS CloudFormation Resource Specification. Now, hand managed.
/* eslint-disable max-len */
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Determine whether the given properties match those of a `CfnApiV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnApiV2Props`
 *
 * @returns the result of the validation.
 */
function CfnApiV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiKeySelectionExpression', cdk.validateString)(properties.apiKeySelectionExpression));
    errors.collect(cdk.propertyValidator('basePath', cdk.validateString)(properties.basePath));
    errors.collect(cdk.propertyValidator('body', cdk.validateObject)(properties.body));
    errors.collect(cdk.propertyValidator('bodyS3Location', CfnApiV2_BodyS3LocationPropertyValidator)(properties.bodyS3Location));
    errors.collect(cdk.propertyValidator('corsConfiguration', CfnApiV2_CorsPropertyValidator)(properties.corsConfiguration));
    errors.collect(cdk.propertyValidator('credentialsArn', cdk.validateString)(properties.credentialsArn));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('disableSchemaValidation', cdk.validateBoolean)(properties.disableSchemaValidation));
    errors.collect(cdk.propertyValidator('failOnWarnings', cdk.validateBoolean)(properties.failOnWarnings));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('protocolType', cdk.validateString)(properties.protocolType));
    errors.collect(cdk.propertyValidator('routeKey', cdk.validateString)(properties.routeKey));
    errors.collect(cdk.propertyValidator('routeSelectionExpression', cdk.validateString)(properties.routeSelectionExpression));
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    errors.collect(cdk.propertyValidator('target', cdk.validateString)(properties.target));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "CfnApiV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api` resource
 *
 * @param properties - the TypeScript properties of a `CfnApiV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api` resource.
 */
// @ts-ignore TS6133
function cfnApiV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnApiV2PropsValidator(properties).assertSuccess();
    return {
        ApiKeySelectionExpression: cdk.stringToCloudFormation(properties.apiKeySelectionExpression),
        BasePath: cdk.stringToCloudFormation(properties.basePath),
        Body: cdk.objectToCloudFormation(properties.body),
        BodyS3Location: cfnApiV2BodyS3LocationPropertyToCloudFormation(properties.bodyS3Location),
        CorsConfiguration: cfnApiV2CorsPropertyToCloudFormation(properties.corsConfiguration),
        CredentialsArn: cdk.stringToCloudFormation(properties.credentialsArn),
        Description: cdk.stringToCloudFormation(properties.description),
        DisableSchemaValidation: cdk.booleanToCloudFormation(properties.disableSchemaValidation),
        FailOnWarnings: cdk.booleanToCloudFormation(properties.failOnWarnings),
        Name: cdk.stringToCloudFormation(properties.name),
        ProtocolType: cdk.stringToCloudFormation(properties.protocolType),
        RouteKey: cdk.stringToCloudFormation(properties.routeKey),
        RouteSelectionExpression: cdk.stringToCloudFormation(properties.routeSelectionExpression),
        Tags: cdk.objectToCloudFormation(properties.tags),
        Target: cdk.stringToCloudFormation(properties.target),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Api`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Api
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnApiV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Api`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnApiV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        this.apiKeySelectionExpression = props.apiKeySelectionExpression;
        this.basePath = props.basePath;
        this.body = props.body;
        this.bodyS3Location = props.bodyS3Location;
        this.corsConfiguration = props.corsConfiguration;
        this.credentialsArn = props.credentialsArn;
        this.description = props.description;
        this.disableSchemaValidation = props.disableSchemaValidation;
        this.failOnWarnings = props.failOnWarnings;
        this.name = props.name;
        this.protocolType = props.protocolType;
        this.routeKey = props.routeKey;
        this.routeSelectionExpression = props.routeSelectionExpression;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, 'AWS::ApiGatewayV2::Api', props.tags, { tagPropertyName: 'tags' });
        this.target = props.target;
        this.version = props.version;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnApiV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiKeySelectionExpression: this.apiKeySelectionExpression,
            basePath: this.basePath,
            body: this.body,
            bodyS3Location: this.bodyS3Location,
            corsConfiguration: this.corsConfiguration,
            credentialsArn: this.credentialsArn,
            description: this.description,
            disableSchemaValidation: this.disableSchemaValidation,
            failOnWarnings: this.failOnWarnings,
            name: this.name,
            protocolType: this.protocolType,
            routeKey: this.routeKey,
            routeSelectionExpression: this.routeSelectionExpression,
            tags: this.tags.renderTags(),
            target: this.target,
            version: this.version,
        };
    }
    renderProperties(props) {
        return cfnApiV2PropsToCloudFormation(props);
    }
}
exports.CfnApiV2 = CfnApiV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnApiV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Api';
/**
 * Determine whether the given properties match those of a `BodyS3LocationProperty`
 *
 * @param properties - the TypeScript properties of a `BodyS3LocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnApiV2_BodyS3LocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('bucket', cdk.validateString)(properties.bucket));
    errors.collect(cdk.propertyValidator('etag', cdk.validateString)(properties.etag));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "BodyS3LocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api.BodyS3Location` resource
 *
 * @param properties - the TypeScript properties of a `BodyS3LocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api.BodyS3Location` resource.
 */
// @ts-ignore TS6133
function cfnApiV2BodyS3LocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnApiV2_BodyS3LocationPropertyValidator(properties).assertSuccess();
    return {
        Bucket: cdk.stringToCloudFormation(properties.bucket),
        Etag: cdk.stringToCloudFormation(properties.etag),
        Key: cdk.stringToCloudFormation(properties.key),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
/**
 * Determine whether the given properties match those of a `CorsProperty`
 *
 * @param properties - the TypeScript properties of a `CorsProperty`
 *
 * @returns the result of the validation.
 */
function CfnApiV2_CorsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allowCredentials', cdk.validateBoolean)(properties.allowCredentials));
    errors.collect(cdk.propertyValidator('allowHeaders', cdk.listValidator(cdk.validateString))(properties.allowHeaders));
    errors.collect(cdk.propertyValidator('allowMethods', cdk.listValidator(cdk.validateString))(properties.allowMethods));
    errors.collect(cdk.propertyValidator('allowOrigins', cdk.listValidator(cdk.validateString))(properties.allowOrigins));
    errors.collect(cdk.propertyValidator('exposeHeaders', cdk.listValidator(cdk.validateString))(properties.exposeHeaders));
    errors.collect(cdk.propertyValidator('maxAge', cdk.validateNumber)(properties.maxAge));
    return errors.wrap('supplied properties not correct for "CorsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api.Cors` resource
 *
 * @param properties - the TypeScript properties of a `CorsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Api.Cors` resource.
 */
// @ts-ignore TS6133
function cfnApiV2CorsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnApiV2_CorsPropertyValidator(properties).assertSuccess();
    return {
        AllowCredentials: cdk.booleanToCloudFormation(properties.allowCredentials),
        AllowHeaders: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowHeaders),
        AllowMethods: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowMethods),
        AllowOrigins: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowOrigins),
        ExposeHeaders: cdk.listMapper(cdk.stringToCloudFormation)(properties.exposeHeaders),
        MaxAge: cdk.numberToCloudFormation(properties.maxAge),
    };
}
/**
 * Determine whether the given properties match those of a `CfnApiMappingV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnApiMappingV2Props`
 *
 * @returns the result of the validation.
 */
function CfnApiMappingV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiMappingKey', cdk.validateString)(properties.apiMappingKey));
    errors.collect(cdk.propertyValidator('domainName', cdk.requiredValidator)(properties.domainName));
    errors.collect(cdk.propertyValidator('domainName', cdk.validateString)(properties.domainName));
    errors.collect(cdk.propertyValidator('stage', cdk.requiredValidator)(properties.stage));
    errors.collect(cdk.propertyValidator('stage', cdk.validateString)(properties.stage));
    return errors.wrap('supplied properties not correct for "CfnApiMappingV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::ApiMapping` resource
 *
 * @param properties - the TypeScript properties of a `CfnApiMappingV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::ApiMapping` resource.
 */
// @ts-ignore TS6133
function cfnApiMappingV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnApiMappingV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        DomainName: cdk.stringToCloudFormation(properties.domainName),
        Stage: cdk.stringToCloudFormation(properties.stage),
        ApiMappingKey: cdk.stringToCloudFormation(properties.apiMappingKey),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::ApiMapping`
 *
 * @cloudformationResource AWS::ApiGatewayV2::ApiMapping
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnApiMappingV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::ApiMapping`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnApiMappingV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'domainName', this);
        cdk.requireProperty(props, 'stage', this);
        this.apiId = props.apiId;
        this.domainName = props.domainName;
        this.stage = props.stage;
        this.apiMappingKey = props.apiMappingKey;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnApiMappingV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            domainName: this.domainName,
            stage: this.stage,
            apiMappingKey: this.apiMappingKey,
        };
    }
    renderProperties(props) {
        return cfnApiMappingV2PropsToCloudFormation(props);
    }
}
exports.CfnApiMappingV2 = CfnApiMappingV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnApiMappingV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::ApiMapping';
/**
 * Determine whether the given properties match those of a `CfnAuthorizerV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnAuthorizerV2Props`
 *
 * @returns the result of the validation.
 */
function CfnAuthorizerV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('authorizerCredentialsArn', cdk.validateString)(properties.authorizerCredentialsArn));
    errors.collect(cdk.propertyValidator('authorizerResultTtlInSeconds', cdk.validateNumber)(properties.authorizerResultTtlInSeconds));
    errors.collect(cdk.propertyValidator('authorizerType', cdk.requiredValidator)(properties.authorizerType));
    errors.collect(cdk.propertyValidator('authorizerType', cdk.validateString)(properties.authorizerType));
    errors.collect(cdk.propertyValidator('authorizerUri', cdk.validateString)(properties.authorizerUri));
    errors.collect(cdk.propertyValidator('identitySource', cdk.requiredValidator)(properties.identitySource));
    errors.collect(cdk.propertyValidator('identitySource', cdk.listValidator(cdk.validateString))(properties.identitySource));
    errors.collect(cdk.propertyValidator('identityValidationExpression', cdk.validateString)(properties.identityValidationExpression));
    errors.collect(cdk.propertyValidator('jwtConfiguration', CfnAuthorizerV2_JWTConfigurationPropertyValidator)(properties.jwtConfiguration));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "CfnAuthorizerV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Authorizer` resource
 *
 * @param properties - the TypeScript properties of a `CfnAuthorizerV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Authorizer` resource.
 */
// @ts-ignore TS6133
function cfnAuthorizerV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAuthorizerV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        AuthorizerType: cdk.stringToCloudFormation(properties.authorizerType),
        IdentitySource: cdk.listMapper(cdk.stringToCloudFormation)(properties.identitySource),
        Name: cdk.stringToCloudFormation(properties.name),
        AuthorizerCredentialsArn: cdk.stringToCloudFormation(properties.authorizerCredentialsArn),
        AuthorizerResultTtlInSeconds: cdk.numberToCloudFormation(properties.authorizerResultTtlInSeconds),
        AuthorizerUri: cdk.stringToCloudFormation(properties.authorizerUri),
        IdentityValidationExpression: cdk.stringToCloudFormation(properties.identityValidationExpression),
        JwtConfiguration: cfnAuthorizerV2JWTConfigurationPropertyToCloudFormation(properties.jwtConfiguration),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Authorizer`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Authorizer
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnAuthorizerV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Authorizer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAuthorizerV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'authorizerType', this);
        cdk.requireProperty(props, 'identitySource', this);
        cdk.requireProperty(props, 'name', this);
        this.apiId = props.apiId;
        this.authorizerType = props.authorizerType;
        this.identitySource = props.identitySource;
        this.name = props.name;
        this.authorizerCredentialsArn = props.authorizerCredentialsArn;
        this.authorizerResultTtlInSeconds = props.authorizerResultTtlInSeconds;
        this.authorizerUri = props.authorizerUri;
        this.identityValidationExpression = props.identityValidationExpression;
        this.jwtConfiguration = props.jwtConfiguration;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnAuthorizerV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            authorizerType: this.authorizerType,
            identitySource: this.identitySource,
            name: this.name,
            authorizerCredentialsArn: this.authorizerCredentialsArn,
            authorizerResultTtlInSeconds: this.authorizerResultTtlInSeconds,
            authorizerUri: this.authorizerUri,
            identityValidationExpression: this.identityValidationExpression,
            jwtConfiguration: this.jwtConfiguration,
        };
    }
    renderProperties(props) {
        return cfnAuthorizerV2PropsToCloudFormation(props);
    }
}
exports.CfnAuthorizerV2 = CfnAuthorizerV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAuthorizerV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Authorizer';
/**
 * Determine whether the given properties match those of a `JWTConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `JWTConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAuthorizerV2_JWTConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('audience', cdk.listValidator(cdk.validateString))(properties.audience));
    errors.collect(cdk.propertyValidator('issuer', cdk.validateString)(properties.issuer));
    return errors.wrap('supplied properties not correct for "JWTConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Authorizer.JWTConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `JWTConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Authorizer.JWTConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAuthorizerV2JWTConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAuthorizerV2_JWTConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Audience: cdk.listMapper(cdk.stringToCloudFormation)(properties.audience),
        Issuer: cdk.stringToCloudFormation(properties.issuer),
    };
}
/**
 * Determine whether the given properties match those of a `CfnDeploymentV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnDeploymentV2Props`
 *
 * @returns the result of the validation.
 */
function CfnDeploymentV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('stageName', cdk.validateString)(properties.stageName));
    return errors.wrap('supplied properties not correct for "CfnDeploymentV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Deployment` resource
 *
 * @param properties - the TypeScript properties of a `CfnDeploymentV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Deployment` resource.
 */
// @ts-ignore TS6133
function cfnDeploymentV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeploymentV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        Description: cdk.stringToCloudFormation(properties.description),
        StageName: cdk.stringToCloudFormation(properties.stageName),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Deployment`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Deployment
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-deployment.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnDeploymentV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Deployment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDeploymentV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        this.apiId = props.apiId;
        this.description = props.description;
        this.stageName = props.stageName;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnDeploymentV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            description: this.description,
            stageName: this.stageName,
        };
    }
    renderProperties(props) {
        return cfnDeploymentV2PropsToCloudFormation(props);
    }
}
exports.CfnDeploymentV2 = CfnDeploymentV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDeploymentV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Deployment';
/**
 * Determine whether the given properties match those of a `CfnDomainNameV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnDomainNameV2Props`
 *
 * @returns the result of the validation.
 */
function CfnDomainNameV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('domainName', cdk.requiredValidator)(properties.domainName));
    errors.collect(cdk.propertyValidator('domainName', cdk.validateString)(properties.domainName));
    errors.collect(cdk.propertyValidator('domainNameConfigurations', cdk.listValidator(CfnDomainNameV2_DomainNameConfigurationPropertyValidator))(properties.domainNameConfigurations));
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDomainNameV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::DomainName` resource
 *
 * @param properties - the TypeScript properties of a `CfnDomainNameV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::DomainName` resource.
 */
// @ts-ignore TS6133
function cfnDomainNameV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomainNameV2PropsValidator(properties).assertSuccess();
    return {
        DomainName: cdk.stringToCloudFormation(properties.domainName),
        DomainNameConfigurations: cdk.listMapper(cfnDomainNameV2DomainNameConfigurationPropertyToCloudFormation)(properties.domainNameConfigurations),
        Tags: cdk.objectToCloudFormation(properties.tags),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::DomainName`
 *
 * @cloudformationResource AWS::ApiGatewayV2::DomainName
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnDomainNameV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::DomainName`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDomainNameV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'domainName', this);
        this.attrRegionalDomainName = cdk.Token.asString(this.getAtt('RegionalDomainName'));
        this.attrRegionalHostedZoneId = cdk.Token.asString(this.getAtt('RegionalHostedZoneId'));
        this.domainName = props.domainName;
        this.domainNameConfigurations = props.domainNameConfigurations;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, 'AWS::ApiGatewayV2::DomainName', props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnDomainNameV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            domainName: this.domainName,
            domainNameConfigurations: this.domainNameConfigurations,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDomainNameV2PropsToCloudFormation(props);
    }
}
exports.CfnDomainNameV2 = CfnDomainNameV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDomainNameV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::DomainName';
/**
 * Determine whether the given properties match those of a `DomainNameConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DomainNameConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomainNameV2_DomainNameConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('certificateArn', cdk.validateString)(properties.certificateArn));
    errors.collect(cdk.propertyValidator('certificateName', cdk.validateString)(properties.certificateName));
    errors.collect(cdk.propertyValidator('endpointType', cdk.validateString)(properties.endpointType));
    return errors.wrap('supplied properties not correct for "DomainNameConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::DomainName.DomainNameConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DomainNameConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::DomainName.DomainNameConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDomainNameV2DomainNameConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomainNameV2_DomainNameConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CertificateArn: cdk.stringToCloudFormation(properties.certificateArn),
        CertificateName: cdk.stringToCloudFormation(properties.certificateName),
        EndpointType: cdk.stringToCloudFormation(properties.endpointType),
    };
}
/**
 * Determine whether the given properties match those of a `CfnIntegrationV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnIntegrationV2Props`
 *
 * @returns the result of the validation.
 */
function CfnIntegrationV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('connectionType', cdk.validateString)(properties.connectionType));
    errors.collect(cdk.propertyValidator('contentHandlingStrategy', cdk.validateString)(properties.contentHandlingStrategy));
    errors.collect(cdk.propertyValidator('credentialsArn', cdk.validateString)(properties.credentialsArn));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('integrationMethod', cdk.validateString)(properties.integrationMethod));
    errors.collect(cdk.propertyValidator('integrationType', cdk.requiredValidator)(properties.integrationType));
    errors.collect(cdk.propertyValidator('integrationType', cdk.validateString)(properties.integrationType));
    errors.collect(cdk.propertyValidator('integrationUri', cdk.validateString)(properties.integrationUri));
    errors.collect(cdk.propertyValidator('passthroughBehavior', cdk.validateString)(properties.passthroughBehavior));
    errors.collect(cdk.propertyValidator('payloadFormatVersion', cdk.validateString)(properties.payloadFormatVersion));
    errors.collect(cdk.propertyValidator('requestParameters', cdk.validateObject)(properties.requestParameters));
    errors.collect(cdk.propertyValidator('requestTemplates', cdk.validateObject)(properties.requestTemplates));
    errors.collect(cdk.propertyValidator('templateSelectionExpression', cdk.validateString)(properties.templateSelectionExpression));
    errors.collect(cdk.propertyValidator('timeoutInMillis', cdk.validateNumber)(properties.timeoutInMillis));
    return errors.wrap('supplied properties not correct for "CfnIntegrationV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Integration` resource
 *
 * @param properties - the TypeScript properties of a `CfnIntegrationV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Integration` resource.
 */
// @ts-ignore TS6133
function cfnIntegrationV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIntegrationV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        IntegrationType: cdk.stringToCloudFormation(properties.integrationType),
        ConnectionType: cdk.stringToCloudFormation(properties.connectionType),
        ContentHandlingStrategy: cdk.stringToCloudFormation(properties.contentHandlingStrategy),
        CredentialsArn: cdk.stringToCloudFormation(properties.credentialsArn),
        Description: cdk.stringToCloudFormation(properties.description),
        IntegrationMethod: cdk.stringToCloudFormation(properties.integrationMethod),
        IntegrationUri: cdk.stringToCloudFormation(properties.integrationUri),
        PassthroughBehavior: cdk.stringToCloudFormation(properties.passthroughBehavior),
        PayloadFormatVersion: cdk.stringToCloudFormation(properties.payloadFormatVersion),
        RequestParameters: cdk.objectToCloudFormation(properties.requestParameters),
        RequestTemplates: cdk.objectToCloudFormation(properties.requestTemplates),
        TemplateSelectionExpression: cdk.stringToCloudFormation(properties.templateSelectionExpression),
        TimeoutInMillis: cdk.numberToCloudFormation(properties.timeoutInMillis),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Integration`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Integration
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integration.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnIntegrationV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Integration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIntegrationV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'integrationType', this);
        this.apiId = props.apiId;
        this.integrationType = props.integrationType;
        this.connectionType = props.connectionType;
        this.contentHandlingStrategy = props.contentHandlingStrategy;
        this.credentialsArn = props.credentialsArn;
        this.description = props.description;
        this.integrationMethod = props.integrationMethod;
        this.integrationUri = props.integrationUri;
        this.passthroughBehavior = props.passthroughBehavior;
        this.payloadFormatVersion = props.payloadFormatVersion;
        this.requestParameters = props.requestParameters;
        this.requestTemplates = props.requestTemplates;
        this.templateSelectionExpression = props.templateSelectionExpression;
        this.timeoutInMillis = props.timeoutInMillis;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnIntegrationV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            integrationType: this.integrationType,
            connectionType: this.connectionType,
            contentHandlingStrategy: this.contentHandlingStrategy,
            credentialsArn: this.credentialsArn,
            description: this.description,
            integrationMethod: this.integrationMethod,
            integrationUri: this.integrationUri,
            passthroughBehavior: this.passthroughBehavior,
            payloadFormatVersion: this.payloadFormatVersion,
            requestParameters: this.requestParameters,
            requestTemplates: this.requestTemplates,
            templateSelectionExpression: this.templateSelectionExpression,
            timeoutInMillis: this.timeoutInMillis,
        };
    }
    renderProperties(props) {
        return cfnIntegrationV2PropsToCloudFormation(props);
    }
}
exports.CfnIntegrationV2 = CfnIntegrationV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnIntegrationV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Integration';
/**
 * Determine whether the given properties match those of a `CfnIntegrationResponseV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnIntegrationResponseV2Props`
 *
 * @returns the result of the validation.
 */
function CfnIntegrationResponseV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('contentHandlingStrategy', cdk.validateString)(properties.contentHandlingStrategy));
    errors.collect(cdk.propertyValidator('integrationId', cdk.requiredValidator)(properties.integrationId));
    errors.collect(cdk.propertyValidator('integrationId', cdk.validateString)(properties.integrationId));
    errors.collect(cdk.propertyValidator('integrationResponseKey', cdk.requiredValidator)(properties.integrationResponseKey));
    errors.collect(cdk.propertyValidator('integrationResponseKey', cdk.validateString)(properties.integrationResponseKey));
    errors.collect(cdk.propertyValidator('responseParameters', cdk.validateObject)(properties.responseParameters));
    errors.collect(cdk.propertyValidator('responseTemplates', cdk.validateObject)(properties.responseTemplates));
    errors.collect(cdk.propertyValidator('templateSelectionExpression', cdk.validateString)(properties.templateSelectionExpression));
    return errors.wrap('supplied properties not correct for "CfnIntegrationResponseV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::IntegrationResponse` resource
 *
 * @param properties - the TypeScript properties of a `CfnIntegrationResponseV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::IntegrationResponse` resource.
 */
// @ts-ignore TS6133
function cfnIntegrationResponseV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIntegrationResponseV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        IntegrationId: cdk.stringToCloudFormation(properties.integrationId),
        IntegrationResponseKey: cdk.stringToCloudFormation(properties.integrationResponseKey),
        ContentHandlingStrategy: cdk.stringToCloudFormation(properties.contentHandlingStrategy),
        ResponseParameters: cdk.objectToCloudFormation(properties.responseParameters),
        ResponseTemplates: cdk.objectToCloudFormation(properties.responseTemplates),
        TemplateSelectionExpression: cdk.stringToCloudFormation(properties.templateSelectionExpression),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::IntegrationResponse`
 *
 * @cloudformationResource AWS::ApiGatewayV2::IntegrationResponse
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnIntegrationResponseV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::IntegrationResponse`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIntegrationResponseV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'integrationId', this);
        cdk.requireProperty(props, 'integrationResponseKey', this);
        this.apiId = props.apiId;
        this.integrationId = props.integrationId;
        this.integrationResponseKey = props.integrationResponseKey;
        this.contentHandlingStrategy = props.contentHandlingStrategy;
        this.responseParameters = props.responseParameters;
        this.responseTemplates = props.responseTemplates;
        this.templateSelectionExpression = props.templateSelectionExpression;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnIntegrationResponseV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            integrationId: this.integrationId,
            integrationResponseKey: this.integrationResponseKey,
            contentHandlingStrategy: this.contentHandlingStrategy,
            responseParameters: this.responseParameters,
            responseTemplates: this.responseTemplates,
            templateSelectionExpression: this.templateSelectionExpression,
        };
    }
    renderProperties(props) {
        return cfnIntegrationResponseV2PropsToCloudFormation(props);
    }
}
exports.CfnIntegrationResponseV2 = CfnIntegrationResponseV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnIntegrationResponseV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::IntegrationResponse';
/**
 * Determine whether the given properties match those of a `CfnModelV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnModelV2Props`
 *
 * @returns the result of the validation.
 */
function CfnModelV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('contentType', cdk.validateString)(properties.contentType));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('schema', cdk.requiredValidator)(properties.schema));
    errors.collect(cdk.propertyValidator('schema', cdk.validateObject)(properties.schema));
    return errors.wrap('supplied properties not correct for "CfnModelV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Model` resource
 *
 * @param properties - the TypeScript properties of a `CfnModelV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Model` resource.
 */
// @ts-ignore TS6133
function cfnModelV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        Name: cdk.stringToCloudFormation(properties.name),
        Schema: cdk.objectToCloudFormation(properties.schema),
        ContentType: cdk.stringToCloudFormation(properties.contentType),
        Description: cdk.stringToCloudFormation(properties.description),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Model`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Model
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-model.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnModelV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Model`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnModelV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'schema', this);
        this.apiId = props.apiId;
        this.name = props.name;
        this.schema = props.schema;
        this.contentType = props.contentType;
        this.description = props.description;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnModelV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            name: this.name,
            schema: this.schema,
            contentType: this.contentType,
            description: this.description,
        };
    }
    renderProperties(props) {
        return cfnModelV2PropsToCloudFormation(props);
    }
}
exports.CfnModelV2 = CfnModelV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnModelV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Model';
/**
 * Determine whether the given properties match those of a `CfnRouteV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnRouteV2Props`
 *
 * @returns the result of the validation.
 */
function CfnRouteV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiKeyRequired', cdk.validateBoolean)(properties.apiKeyRequired));
    errors.collect(cdk.propertyValidator('authorizationScopes', cdk.listValidator(cdk.validateString))(properties.authorizationScopes));
    errors.collect(cdk.propertyValidator('authorizationType', cdk.validateString)(properties.authorizationType));
    errors.collect(cdk.propertyValidator('authorizerId', cdk.validateString)(properties.authorizerId));
    errors.collect(cdk.propertyValidator('modelSelectionExpression', cdk.validateString)(properties.modelSelectionExpression));
    errors.collect(cdk.propertyValidator('operationName', cdk.validateString)(properties.operationName));
    errors.collect(cdk.propertyValidator('requestModels', cdk.validateObject)(properties.requestModels));
    errors.collect(cdk.propertyValidator('requestParameters', cdk.validateObject)(properties.requestParameters));
    errors.collect(cdk.propertyValidator('routeKey', cdk.requiredValidator)(properties.routeKey));
    errors.collect(cdk.propertyValidator('routeKey', cdk.validateString)(properties.routeKey));
    errors.collect(cdk.propertyValidator('routeResponseSelectionExpression', cdk.validateString)(properties.routeResponseSelectionExpression));
    errors.collect(cdk.propertyValidator('target', cdk.validateString)(properties.target));
    return errors.wrap('supplied properties not correct for "CfnRouteV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Route` resource
 *
 * @param properties - the TypeScript properties of a `CfnRouteV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Route` resource.
 */
// @ts-ignore TS6133
function cfnRouteV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRouteV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        RouteKey: cdk.stringToCloudFormation(properties.routeKey),
        ApiKeyRequired: cdk.booleanToCloudFormation(properties.apiKeyRequired),
        AuthorizationScopes: cdk.listMapper(cdk.stringToCloudFormation)(properties.authorizationScopes),
        AuthorizationType: cdk.stringToCloudFormation(properties.authorizationType),
        AuthorizerId: cdk.stringToCloudFormation(properties.authorizerId),
        ModelSelectionExpression: cdk.stringToCloudFormation(properties.modelSelectionExpression),
        OperationName: cdk.stringToCloudFormation(properties.operationName),
        RequestModels: cdk.objectToCloudFormation(properties.requestModels),
        RequestParameters: cdk.objectToCloudFormation(properties.requestParameters),
        RouteResponseSelectionExpression: cdk.stringToCloudFormation(properties.routeResponseSelectionExpression),
        Target: cdk.stringToCloudFormation(properties.target),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Route`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Route
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-route.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnRouteV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Route`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRouteV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'routeKey', this);
        this.apiId = props.apiId;
        this.routeKey = props.routeKey;
        this.apiKeyRequired = props.apiKeyRequired;
        this.authorizationScopes = props.authorizationScopes;
        this.authorizationType = props.authorizationType;
        this.authorizerId = props.authorizerId;
        this.modelSelectionExpression = props.modelSelectionExpression;
        this.operationName = props.operationName;
        this.requestModels = props.requestModels;
        this.requestParameters = props.requestParameters;
        this.routeResponseSelectionExpression = props.routeResponseSelectionExpression;
        this.target = props.target;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnRouteV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            routeKey: this.routeKey,
            apiKeyRequired: this.apiKeyRequired,
            authorizationScopes: this.authorizationScopes,
            authorizationType: this.authorizationType,
            authorizerId: this.authorizerId,
            modelSelectionExpression: this.modelSelectionExpression,
            operationName: this.operationName,
            requestModels: this.requestModels,
            requestParameters: this.requestParameters,
            routeResponseSelectionExpression: this.routeResponseSelectionExpression,
            target: this.target,
        };
    }
    renderProperties(props) {
        return cfnRouteV2PropsToCloudFormation(props);
    }
}
exports.CfnRouteV2 = CfnRouteV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRouteV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Route';
/**
 * Determine whether the given properties match those of a `ParameterConstraintsProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterConstraintsProperty`
 *
 * @returns the result of the validation.
 */
function CfnRouteV2_ParameterConstraintsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('required', cdk.requiredValidator)(properties.required));
    errors.collect(cdk.propertyValidator('required', cdk.validateBoolean)(properties.required));
    return errors.wrap('supplied properties not correct for "ParameterConstraintsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Route.ParameterConstraints` resource
 *
 * @param properties - the TypeScript properties of a `ParameterConstraintsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Route.ParameterConstraints` resource.
 */
// @ts-ignore TS6133
function cfnRouteV2ParameterConstraintsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRouteV2_ParameterConstraintsPropertyValidator(properties).assertSuccess();
    return {
        Required: cdk.booleanToCloudFormation(properties.required),
    };
}
/**
 * Determine whether the given properties match those of a `CfnRouteResponseV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnRouteResponseV2Props`
 *
 * @returns the result of the validation.
 */
function CfnRouteResponseV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('modelSelectionExpression', cdk.validateString)(properties.modelSelectionExpression));
    errors.collect(cdk.propertyValidator('responseModels', cdk.validateObject)(properties.responseModels));
    errors.collect(cdk.propertyValidator('responseParameters', cdk.validateObject)(properties.responseParameters));
    errors.collect(cdk.propertyValidator('routeId', cdk.requiredValidator)(properties.routeId));
    errors.collect(cdk.propertyValidator('routeId', cdk.validateString)(properties.routeId));
    errors.collect(cdk.propertyValidator('routeResponseKey', cdk.requiredValidator)(properties.routeResponseKey));
    errors.collect(cdk.propertyValidator('routeResponseKey', cdk.validateString)(properties.routeResponseKey));
    return errors.wrap('supplied properties not correct for "CfnRouteResponseV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::RouteResponse` resource
 *
 * @param properties - the TypeScript properties of a `CfnRouteResponseV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::RouteResponse` resource.
 */
// @ts-ignore TS6133
function cfnRouteResponseV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRouteResponseV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        RouteId: cdk.stringToCloudFormation(properties.routeId),
        RouteResponseKey: cdk.stringToCloudFormation(properties.routeResponseKey),
        ModelSelectionExpression: cdk.stringToCloudFormation(properties.modelSelectionExpression),
        ResponseModels: cdk.objectToCloudFormation(properties.responseModels),
        ResponseParameters: cdk.objectToCloudFormation(properties.responseParameters),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::RouteResponse`
 *
 * @cloudformationResource AWS::ApiGatewayV2::RouteResponse
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-routeresponse.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnRouteResponseV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::RouteResponse`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRouteResponseV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'routeId', this);
        cdk.requireProperty(props, 'routeResponseKey', this);
        this.apiId = props.apiId;
        this.routeId = props.routeId;
        this.routeResponseKey = props.routeResponseKey;
        this.modelSelectionExpression = props.modelSelectionExpression;
        this.responseModels = props.responseModels;
        this.responseParameters = props.responseParameters;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnRouteResponseV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            routeId: this.routeId,
            routeResponseKey: this.routeResponseKey,
            modelSelectionExpression: this.modelSelectionExpression,
            responseModels: this.responseModels,
            responseParameters: this.responseParameters,
        };
    }
    renderProperties(props) {
        return cfnRouteResponseV2PropsToCloudFormation(props);
    }
}
exports.CfnRouteResponseV2 = CfnRouteResponseV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRouteResponseV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::RouteResponse';
/**
 * Determine whether the given properties match those of a `ParameterConstraintsProperty`
 *
 * @param properties - the TypeScript properties of a `ParameterConstraintsProperty`
 *
 * @returns the result of the validation.
 */
function CfnRouteResponseV2_ParameterConstraintsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('required', cdk.requiredValidator)(properties.required));
    errors.collect(cdk.propertyValidator('required', cdk.validateBoolean)(properties.required));
    return errors.wrap('supplied properties not correct for "ParameterConstraintsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::RouteResponse.ParameterConstraints` resource
 *
 * @param properties - the TypeScript properties of a `ParameterConstraintsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::RouteResponse.ParameterConstraints` resource.
 */
// @ts-ignore TS6133
function cfnRouteResponseV2ParameterConstraintsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRouteResponseV2_ParameterConstraintsPropertyValidator(properties).assertSuccess();
    return {
        Required: cdk.booleanToCloudFormation(properties.required),
    };
}
/**
 * Determine whether the given properties match those of a `CfnStageV2Props`
 *
 * @param properties - the TypeScript properties of a `CfnStageV2Props`
 *
 * @returns the result of the validation.
 */
function CfnStageV2PropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('accessLogSettings', CfnStageV2_AccessLogSettingsPropertyValidator)(properties.accessLogSettings));
    errors.collect(cdk.propertyValidator('apiId', cdk.requiredValidator)(properties.apiId));
    errors.collect(cdk.propertyValidator('apiId', cdk.validateString)(properties.apiId));
    errors.collect(cdk.propertyValidator('autoDeploy', cdk.validateBoolean)(properties.autoDeploy));
    errors.collect(cdk.propertyValidator('clientCertificateId', cdk.validateString)(properties.clientCertificateId));
    errors.collect(cdk.propertyValidator('defaultRouteSettings', CfnStageV2_RouteSettingsPropertyValidator)(properties.defaultRouteSettings));
    errors.collect(cdk.propertyValidator('deploymentId', cdk.validateString)(properties.deploymentId));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('routeSettings', cdk.validateObject)(properties.routeSettings));
    errors.collect(cdk.propertyValidator('stageName', cdk.requiredValidator)(properties.stageName));
    errors.collect(cdk.propertyValidator('stageName', cdk.validateString)(properties.stageName));
    errors.collect(cdk.propertyValidator('stageVariables', cdk.validateObject)(properties.stageVariables));
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnStageV2Props"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage` resource
 *
 * @param properties - the TypeScript properties of a `CfnStageV2Props`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage` resource.
 */
// @ts-ignore TS6133
function cfnStageV2PropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnStageV2PropsValidator(properties).assertSuccess();
    return {
        ApiId: cdk.stringToCloudFormation(properties.apiId),
        StageName: cdk.stringToCloudFormation(properties.stageName),
        AccessLogSettings: cfnStageV2AccessLogSettingsPropertyToCloudFormation(properties.accessLogSettings),
        AutoDeploy: cdk.booleanToCloudFormation(properties.autoDeploy),
        ClientCertificateId: cdk.stringToCloudFormation(properties.clientCertificateId),
        DefaultRouteSettings: cfnStageV2RouteSettingsPropertyToCloudFormation(properties.defaultRouteSettings),
        DeploymentId: cdk.stringToCloudFormation(properties.deploymentId),
        Description: cdk.stringToCloudFormation(properties.description),
        RouteSettings: cdk.objectToCloudFormation(properties.routeSettings),
        StageVariables: cdk.objectToCloudFormation(properties.stageVariables),
        Tags: cdk.objectToCloudFormation(properties.tags),
    };
}
/**
 * A CloudFormation `AWS::ApiGatewayV2::Stage`
 *
 * @cloudformationResource AWS::ApiGatewayV2::Stage
 * @stability deprecated
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html
 * @deprecated moved to package aws-apigatewayv2
 */
class CfnStageV2 extends cdk.CfnResource {
    /**
     * Create a new `AWS::ApiGatewayV2::Stage`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnStageV2.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'apiId', this);
        cdk.requireProperty(props, 'stageName', this);
        this.apiId = props.apiId;
        this.stageName = props.stageName;
        this.accessLogSettings = props.accessLogSettings;
        this.autoDeploy = props.autoDeploy;
        this.clientCertificateId = props.clientCertificateId;
        this.defaultRouteSettings = props.defaultRouteSettings;
        this.deploymentId = props.deploymentId;
        this.description = props.description;
        this.routeSettings = props.routeSettings;
        this.stageVariables = props.stageVariables;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, 'AWS::ApiGatewayV2::Stage', props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute('aws:cdk:cloudformation:type', CfnStageV2.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute('aws:cdk:cloudformation:props', this.cfnProperties);
    }
    get cfnProperties() {
        return {
            apiId: this.apiId,
            stageName: this.stageName,
            accessLogSettings: this.accessLogSettings,
            autoDeploy: this.autoDeploy,
            clientCertificateId: this.clientCertificateId,
            defaultRouteSettings: this.defaultRouteSettings,
            deploymentId: this.deploymentId,
            description: this.description,
            routeSettings: this.routeSettings,
            stageVariables: this.stageVariables,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnStageV2PropsToCloudFormation(props);
    }
}
exports.CfnStageV2 = CfnStageV2;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnStageV2.CFN_RESOURCE_TYPE_NAME = 'AWS::ApiGatewayV2::Stage';
/**
 * Determine whether the given properties match those of a `AccessLogSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `AccessLogSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnStageV2_AccessLogSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('destinationArn', cdk.validateString)(properties.destinationArn));
    errors.collect(cdk.propertyValidator('format', cdk.validateString)(properties.format));
    return errors.wrap('supplied properties not correct for "AccessLogSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage.AccessLogSettings` resource
 *
 * @param properties - the TypeScript properties of a `AccessLogSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage.AccessLogSettings` resource.
 */
// @ts-ignore TS6133
function cfnStageV2AccessLogSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnStageV2_AccessLogSettingsPropertyValidator(properties).assertSuccess();
    return {
        DestinationArn: cdk.stringToCloudFormation(properties.destinationArn),
        Format: cdk.stringToCloudFormation(properties.format),
    };
}
/**
 * Determine whether the given properties match those of a `RouteSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `RouteSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnStageV2_RouteSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('dataTraceEnabled', cdk.validateBoolean)(properties.dataTraceEnabled));
    errors.collect(cdk.propertyValidator('detailedMetricsEnabled', cdk.validateBoolean)(properties.detailedMetricsEnabled));
    errors.collect(cdk.propertyValidator('loggingLevel', cdk.validateString)(properties.loggingLevel));
    errors.collect(cdk.propertyValidator('throttlingBurstLimit', cdk.validateNumber)(properties.throttlingBurstLimit));
    errors.collect(cdk.propertyValidator('throttlingRateLimit', cdk.validateNumber)(properties.throttlingRateLimit));
    return errors.wrap('supplied properties not correct for "RouteSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage.RouteSettings` resource
 *
 * @param properties - the TypeScript properties of a `RouteSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ApiGatewayV2::Stage.RouteSettings` resource.
 */
// @ts-ignore TS6133
function cfnStageV2RouteSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnStageV2_RouteSettingsPropertyValidator(properties).assertSuccess();
    return {
        DataTraceEnabled: cdk.booleanToCloudFormation(properties.dataTraceEnabled),
        DetailedMetricsEnabled: cdk.booleanToCloudFormation(properties.detailedMetricsEnabled),
        LoggingLevel: cdk.stringToCloudFormation(properties.loggingLevel),
        ThrottlingBurstLimit: cdk.numberToCloudFormation(properties.throttlingBurstLimit),
        ThrottlingRateLimit: cdk.numberToCloudFormation(properties.throttlingRateLimit),
    };
}
//# sourceMappingURL=data:application/json;base64,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