"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsIntegration = void 0;
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const integration_1 = require("../integration");
const util_1 = require("../util");
/**
 * This type of integration lets an API expose AWS service actions. It is
 * intended for calling all AWS service actions, but is not recommended for
 * calling a Lambda function, because the Lambda custom integration is a legacy
 * technology.
 */
class AwsIntegration extends integration_1.Integration {
    constructor(props) {
        const backend = props.subdomain ? `${props.subdomain}.${props.service}` : props.service;
        const type = props.proxy ? integration_1.IntegrationType.AWS_PROXY : integration_1.IntegrationType.AWS;
        const { apiType, apiValue } = util_1.parseAwsApiCall(props.path, props.action, props.actionParameters);
        super({
            type,
            integrationHttpMethod: props.integrationHttpMethod || 'POST',
            uri: cdk.Lazy.stringValue({
                produce: () => {
                    if (!this.scope) {
                        throw new Error('AwsIntegration must be used in API');
                    }
                    return cdk.Stack.of(this.scope).formatArn({
                        service: 'apigateway',
                        account: backend,
                        resource: apiType,
                        sep: '/',
                        resourceName: apiValue,
                    });
                },
            }),
            options: props.options,
        });
    }
    bind(method) {
        const bindResult = super.bind(method);
        this.scope = method;
        return bindResult;
    }
}
exports.AwsIntegration = AwsIntegration;
//# sourceMappingURL=data:application/json;base64,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