"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaRestApi = void 0;
const integrations_1 = require("./integrations");
const restapi_1 = require("./restapi");
/**
 * Defines an API Gateway REST API with AWS Lambda proxy integration.
 *
 * Use the `proxy` property to define a greedy proxy ("{proxy+}") and "ANY"
 * method from the specified path. If not defined, you will need to explicity
 * add resources and methods to the API.
 */
class LambdaRestApi extends restapi_1.RestApi {
    constructor(scope, id, props) {
        if ((props.options && props.options.defaultIntegration) || props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Lambda integration is automatically defined');
        }
        super(scope, id, {
            defaultIntegration: new integrations_1.LambdaIntegration(props.handler),
            ...props.options,
            ...props,
        });
        if (props.proxy !== false) {
            this.root.addProxy();
            // Make sure users cannot call any other resource adding function
            this.root.addResource = addResourceThrows;
            this.root.addMethod = addMethodThrows;
            this.root.addProxy = addProxyThrows;
        }
    }
}
exports.LambdaRestApi = LambdaRestApi;
function addResourceThrows() {
    throw new Error('Cannot call \'addResource\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addMethodThrows() {
    throw new Error('Cannot call \'addMethod\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addProxyThrows() {
    throw new Error('Cannot call \'addProxy\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
//# sourceMappingURL=data:application/json;base64,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