import { Resource } from "../../core";
import { Construct } from 'constructs';
import { ApiKeyProps, IApiKey } from './api-key';
import { QuotaSettings, ThrottleSettings, UsagePlanPerApiStage } from './usage-plan';
/**
 * RateLimitedApiKey properties.
 */
export interface RateLimitedApiKeyProps extends ApiKeyProps {
    /**
     * API Stages to be associated with the RateLimitedApiKey.
     * @default none
     */
    readonly apiStages?: UsagePlanPerApiStage[];
    /**
     * Number of requests clients can make in a given time period.
     * @default none
     */
    readonly quota?: QuotaSettings;
    /**
     * Overall throttle settings for the API.
     * @default none
     */
    readonly throttle?: ThrottleSettings;
}
/**
 * An API Gateway ApiKey, for which a rate limiting configuration can be specified.
 *
 * @resource AWS::ApiGateway::ApiKey
 */
export declare class RateLimitedApiKey extends Resource implements IApiKey {
    readonly keyId: string;
    constructor(scope: Construct, id: string, props?: RateLimitedApiKeyProps);
}
