"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApiMapping = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Create a new API mapping for API Gateway HTTP API endpoint.
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
class HttpApiMapping extends core_1.Resource {
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id);
        if ((!((_a = props.stage) === null || _a === void 0 ? void 0 : _a.stageName)) && !props.api.defaultStage) {
            throw new Error('stage is required if default stage is not available');
        }
        const paramRe = '^[a-zA-Z0-9]*[-_.+!,$]?[a-zA-Z0-9]*$';
        if (props.apiMappingKey && !new RegExp(paramRe).test(props.apiMappingKey)) {
            throw new Error('An ApiMapping key may contain only letters, numbers and one of $-_.+!*\'(),');
        }
        if (props.apiMappingKey === '') {
            throw new Error('empty string for api mapping key not allowed');
        }
        const apiMappingProps = {
            apiId: props.api.httpApiId,
            domainName: props.domainName.domainName,
            stage: (_c = (_b = props.stage) === null || _b === void 0 ? void 0 : _b.stageName) !== null && _c !== void 0 ? _c : props.api.defaultStage.stageName,
            apiMappingKey: props.apiMappingKey,
        };
        const resource = new apigatewayv2_generated_1.CfnApiMapping(this, 'Resource', apiMappingProps);
        // ensure the dependency on the provided stage
        if (props.stage) {
            this.node.addDependency(props.stage);
        }
        // if stage not specified, we ensure the default stage is ready before we create the api mapping
        if (!((_d = props.stage) === null || _d === void 0 ? void 0 : _d.stageName) && props.api.defaultStage) {
            this.node.addDependency(props.api.defaultStage);
        }
        this.apiMappingId = resource.ref;
        this.mappingKey = props.apiMappingKey;
    }
    /**
     * import from API ID
     */
    static fromHttpApiMappingAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.apiMappingId = attrs.apiMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.HttpApiMapping = HttpApiMapping;
//# sourceMappingURL=data:application/json;base64,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