"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpProxyIntegration = void 0;
const integration_1 = require("../integration");
const route_1 = require("../route");
/**
 * The HTTP Proxy integration resource for HTTP API
 */
class HttpProxyIntegration {
    constructor(props) {
        this.props = props;
    }
    bind(_) {
        var _a;
        return {
            method: (_a = this.props.method) !== null && _a !== void 0 ? _a : route_1.HttpMethod.ANY,
            payloadFormatVersion: integration_1.PayloadFormatVersion.VERSION_1_0,
            type: integration_1.HttpIntegrationType.HTTP_PROXY,
            uri: this.props.url,
        };
    }
}
exports.HttpProxyIntegration = HttpProxyIntegration;
//# sourceMappingURL=data:application/json;base64,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