import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::ApplicationInsights::Application`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export interface CfnApplicationProps {
    /**
     * `AWS::ApplicationInsights::Application.ResourceGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-resourcegroupname
     */
    readonly resourceGroupName: string;
    /**
     * `AWS::ApplicationInsights::Application.AutoConfigurationEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled
     */
    readonly autoConfigurationEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.ComponentMonitoringSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings
     */
    readonly componentMonitoringSettings?: Array<CfnApplication.ComponentMonitoringSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.CustomComponents`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents
     */
    readonly customComponents?: Array<CfnApplication.CustomComponentProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.CWEMonitorEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled
     */
    readonly cweMonitorEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.LogPatternSets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets
     */
    readonly logPatternSets?: Array<CfnApplication.LogPatternSetProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.OpsCenterEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled
     */
    readonly opsCenterEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ApplicationInsights::Application.OpsItemSNSTopicArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opsitemsnstopicarn
     */
    readonly opsItemSnsTopicArn?: string;
    /**
     * `AWS::ApplicationInsights::Application.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ApplicationInsights::Application`
 *
 * @cloudformationResource AWS::ApplicationInsights::Application
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApplicationInsights::Application";
    /**
     * @cloudformationAttribute ApplicationARN
     */
    readonly attrApplicationArn: string;
    /**
     * `AWS::ApplicationInsights::Application.ResourceGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-resourcegroupname
     */
    resourceGroupName: string;
    /**
     * `AWS::ApplicationInsights::Application.AutoConfigurationEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-autoconfigurationenabled
     */
    autoConfigurationEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.ComponentMonitoringSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-componentmonitoringsettings
     */
    componentMonitoringSettings: Array<CfnApplication.ComponentMonitoringSettingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.CustomComponents`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-customcomponents
     */
    customComponents: Array<CfnApplication.CustomComponentProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.CWEMonitorEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-cwemonitorenabled
     */
    cweMonitorEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.LogPatternSets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-logpatternsets
     */
    logPatternSets: Array<CfnApplication.LogPatternSetProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.OpsCenterEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opscenterenabled
     */
    opsCenterEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationInsights::Application.OpsItemSNSTopicArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-opsitemsnstopicarn
     */
    opsItemSnsTopicArn: string | undefined;
    /**
     * `AWS::ApplicationInsights::Application.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationinsights-application.html#cfn-applicationinsights-application-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ApplicationInsights::Application`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html
     */
    interface AlarmProperty {
        /**
         * `CfnApplication.AlarmProperty.AlarmName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html#cfn-applicationinsights-application-alarm-alarmname
         */
        readonly alarmName: string;
        /**
         * `CfnApplication.AlarmProperty.Severity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarm.html#cfn-applicationinsights-application-alarm-severity
         */
        readonly severity?: string;
    }
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarmmetric.html
     */
    interface AlarmMetricProperty {
        /**
         * `CfnApplication.AlarmMetricProperty.AlarmMetricName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-alarmmetric.html#cfn-applicationinsights-application-alarmmetric-alarmmetricname
         */
        readonly alarmMetricName: string;
    }
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html
     */
    interface ComponentConfigurationProperty {
        /**
         * `CfnApplication.ComponentConfigurationProperty.ConfigurationDetails`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html#cfn-applicationinsights-application-componentconfiguration-configurationdetails
         */
        readonly configurationDetails?: CfnApplication.ConfigurationDetailsProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ComponentConfigurationProperty.SubComponentTypeConfigurations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentconfiguration.html#cfn-applicationinsights-application-componentconfiguration-subcomponenttypeconfigurations
         */
        readonly subComponentTypeConfigurations?: Array<CfnApplication.SubComponentTypeConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html
     */
    interface ComponentMonitoringSettingProperty {
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.ComponentARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentarn
         */
        readonly componentArn?: string;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.ComponentConfigurationMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentconfigurationmode
         */
        readonly componentConfigurationMode?: string;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.ComponentName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-componentname
         */
        readonly componentName?: string;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.CustomComponentConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-customcomponentconfiguration
         */
        readonly customComponentConfiguration?: CfnApplication.ComponentConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.DefaultOverwriteComponentConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-defaultoverwritecomponentconfiguration
         */
        readonly defaultOverwriteComponentConfiguration?: CfnApplication.ComponentConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ComponentMonitoringSettingProperty.Tier`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-componentmonitoringsetting.html#cfn-applicationinsights-application-componentmonitoringsetting-tier
         */
        readonly tier?: string;
    }
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html
     */
    interface ConfigurationDetailsProperty {
        /**
         * `CfnApplication.ConfigurationDetailsProperty.AlarmMetrics`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-alarmmetrics
         */
        readonly alarmMetrics?: Array<CfnApplication.AlarmMetricProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.ConfigurationDetailsProperty.Alarms`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-alarms
         */
        readonly alarms?: Array<CfnApplication.AlarmProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.ConfigurationDetailsProperty.Logs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-logs
         */
        readonly logs?: Array<CfnApplication.LogProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.ConfigurationDetailsProperty.WindowsEvents`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-configurationdetails.html#cfn-applicationinsights-application-configurationdetails-windowsevents
         */
        readonly windowsEvents?: Array<CfnApplication.WindowsEventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html
     */
    interface CustomComponentProperty {
        /**
         * `CfnApplication.CustomComponentProperty.ComponentName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html#cfn-applicationinsights-application-customcomponent-componentname
         */
        readonly componentName: string;
        /**
         * `CfnApplication.CustomComponentProperty.ResourceList`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-customcomponent.html#cfn-applicationinsights-application-customcomponent-resourcelist
         */
        readonly resourceList: string[];
    }
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html
     */
    interface LogProperty {
        /**
         * `CfnApplication.LogProperty.Encoding`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-encoding
         */
        readonly encoding?: string;
        /**
         * `CfnApplication.LogProperty.LogGroupName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-loggroupname
         */
        readonly logGroupName?: string;
        /**
         * `CfnApplication.LogProperty.LogPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-logpath
         */
        readonly logPath?: string;
        /**
         * `CfnApplication.LogProperty.LogType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-logtype
         */
        readonly logType: string;
        /**
         * `CfnApplication.LogProperty.PatternSet`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-log.html#cfn-applicationinsights-application-log-patternset
         */
        readonly patternSet?: string;
    }
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html
     */
    interface LogPatternProperty {
        /**
         * `CfnApplication.LogPatternProperty.Pattern`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-pattern
         */
        readonly pattern: string;
        /**
         * `CfnApplication.LogPatternProperty.PatternName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-patternname
         */
        readonly patternName: string;
        /**
         * `CfnApplication.LogPatternProperty.Rank`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpattern.html#cfn-applicationinsights-application-logpattern-rank
         */
        readonly rank: number;
    }
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html
     */
    interface LogPatternSetProperty {
        /**
         * `CfnApplication.LogPatternSetProperty.LogPatterns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html#cfn-applicationinsights-application-logpatternset-logpatterns
         */
        readonly logPatterns: Array<CfnApplication.LogPatternProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.LogPatternSetProperty.PatternSetName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-logpatternset.html#cfn-applicationinsights-application-logpatternset-patternsetname
         */
        readonly patternSetName: string;
    }
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html
     */
    interface SubComponentConfigurationDetailsProperty {
        /**
         * `CfnApplication.SubComponentConfigurationDetailsProperty.AlarmMetrics`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-alarmmetrics
         */
        readonly alarmMetrics?: Array<CfnApplication.AlarmMetricProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.SubComponentConfigurationDetailsProperty.Logs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-logs
         */
        readonly logs?: Array<CfnApplication.LogProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.SubComponentConfigurationDetailsProperty.WindowsEvents`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponentconfigurationdetails.html#cfn-applicationinsights-application-subcomponentconfigurationdetails-windowsevents
         */
        readonly windowsEvents?: Array<CfnApplication.WindowsEventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html
     */
    interface SubComponentTypeConfigurationProperty {
        /**
         * `CfnApplication.SubComponentTypeConfigurationProperty.SubComponentConfigurationDetails`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html#cfn-applicationinsights-application-subcomponenttypeconfiguration-subcomponentconfigurationdetails
         */
        readonly subComponentConfigurationDetails: CfnApplication.SubComponentConfigurationDetailsProperty | cdk.IResolvable;
        /**
         * `CfnApplication.SubComponentTypeConfigurationProperty.SubComponentType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-subcomponenttypeconfiguration.html#cfn-applicationinsights-application-subcomponenttypeconfiguration-subcomponenttype
         */
        readonly subComponentType: string;
    }
}
export declare namespace CfnApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html
     */
    interface WindowsEventProperty {
        /**
         * `CfnApplication.WindowsEventProperty.EventLevels`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-eventlevels
         */
        readonly eventLevels: string[];
        /**
         * `CfnApplication.WindowsEventProperty.EventName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-eventname
         */
        readonly eventName: string;
        /**
         * `CfnApplication.WindowsEventProperty.LogGroupName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-loggroupname
         */
        readonly logGroupName: string;
        /**
         * `CfnApplication.WindowsEventProperty.PatternSet`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationinsights-application-windowsevent.html#cfn-applicationinsights-application-windowsevent-patternset
         */
        readonly patternSet?: string;
    }
}
