"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessLog = exports.Protocol = void 0;
/**
 * Enum of supported AppMesh protocols
 */
var Protocol;
(function (Protocol) {
    Protocol["HTTP"] = "http";
    Protocol["TCP"] = "tcp";
    Protocol["HTTP2"] = "http2";
    Protocol["GRPC"] = "grpc";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Configuration for Envoy Access logs for mesh endpoints
 */
class AccessLog {
    /**
     * Path to a file to write access logs to
     *
     * @default - no file based access logging
     */
    static fromFilePath(filePath) {
        return new FileAccessLog(filePath);
    }
}
exports.AccessLog = AccessLog;
/**
 * Configuration for Envoy Access logs for mesh endpoints
 */
class FileAccessLog extends AccessLog {
    constructor(filePath) {
        super();
        this.filePath = filePath;
    }
    bind(_scope) {
        return {
            virtualNodeAccessLog: {
                file: {
                    path: this.filePath,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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