"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GraphqlApiBase = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const data_source_1 = require("./data-source");
/**
 * Base Class for GraphQL API
 */
class GraphqlApiBase extends core_1.Resource {
    /**
     * add a new dummy data source to this API. Useful for pipeline resolvers
     * and for backend changes that don't require a data source.
     *
     * @param id The data source's id
     * @param options The optional configuration for this data source
     */
    addNoneDataSource(id, options) {
        return new data_source_1.NoneDataSource(this, id, {
            api: this,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * add a new DynamoDB data source to this API
     *
     * @param id The data source's id
     * @param table The DynamoDB table backing this data source
     * @param options The optional configuration for this data source
     */
    addDynamoDbDataSource(id, table, options) {
        return new data_source_1.DynamoDbDataSource(this, id, {
            api: this,
            table,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * add a new http data source to this API
     *
     * @param id The data source's id
     * @param endpoint The http endpoint
     * @param options The optional configuration for this data source
     */
    addHttpDataSource(id, endpoint, options) {
        return new data_source_1.HttpDataSource(this, id, {
            api: this,
            endpoint,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
            authorizationConfig: options === null || options === void 0 ? void 0 : options.authorizationConfig,
        });
    }
    /**
     * add a new Lambda data source to this API
     *
     * @param id The data source's id
     * @param lambdaFunction The Lambda function to call to interact with this data source
     * @param options The optional configuration for this data source
     */
    addLambdaDataSource(id, lambdaFunction, options) {
        return new data_source_1.LambdaDataSource(this, id, {
            api: this,
            lambdaFunction,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * Add schema dependency if not imported
     *
     * @param construct the dependee
     */
    addSchemaDependency(construct) {
        construct;
        return false;
    }
}
exports.GraphqlApiBase = GraphqlApiBase;
//# sourceMappingURL=data:application/json;base64,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