import * as autoscaling from "../../aws-autoscaling";
import * as kms from "../../aws-kms";
import * as lambda from "../../aws-lambda";
import { Construct } from "../../core";
/**
 * Use a Lambda Function as a hook target
 *
 * Internally creates a Topic to make the connection.
 */
export declare class FunctionHook implements autoscaling.ILifecycleHookTarget {
    private readonly fn;
    private readonly encryptionKey?;
    /**
     * @param fn Function to invoke in response to a lifecycle event
     * @param encryptionKey If provided, this key is used to encrypt the contents of the SNS topic.
     */
    constructor(fn: lambda.IFunction, encryptionKey?: kms.IKey | undefined);
    bind(scope: Construct, lifecycleHook: autoscaling.ILifecycleHook): autoscaling.LifecycleHookTargetConfig;
}
