"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpOrigin = void 0;
const cloudfront = require("../../aws-cloudfront"); // Automatically re-written from '@aws-cdk/aws-cloudfront'
/**
 * An Origin for an HTTP server or S3 bucket configured for website hosting.
 *
 * @experimental
 */
class HttpOrigin extends cloudfront.OriginBase {
    constructor(domainName, props = {}) {
        super(domainName, props);
        this.props = props;
        validateSecondsInRangeOrUndefined('readTimeout', 1, 60, props.readTimeout);
        validateSecondsInRangeOrUndefined('keepaliveTimeout', 1, 60, props.keepaliveTimeout);
    }
    renderCustomOriginConfig() {
        var _a, _b, _c;
        return {
            originProtocolPolicy: (_a = this.props.protocolPolicy) !== null && _a !== void 0 ? _a : cloudfront.OriginProtocolPolicy.HTTPS_ONLY,
            httpPort: this.props.httpPort,
            httpsPort: this.props.httpsPort,
            originReadTimeout: (_b = this.props.readTimeout) === null || _b === void 0 ? void 0 : _b.toSeconds(),
            originKeepaliveTimeout: (_c = this.props.keepaliveTimeout) === null || _c === void 0 ? void 0 : _c.toSeconds(),
        };
    }
}
exports.HttpOrigin = HttpOrigin;
/**
 * Throws an error if a duration is defined and not an integer number of seconds within a range.
 */
function validateSecondsInRangeOrUndefined(name, min, max, duration) {
    if (duration === undefined) {
        return;
    }
    const value = duration.toSeconds();
    if (!Number.isInteger(value) || value < min || value > max) {
        throw new Error(`${name}: Must be an int between ${min} and ${max} seconds (inclusive); received ${value}.`);
    }
}
//# sourceMappingURL=data:application/json;base64,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