"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlarmStatusWidget = void 0;
const widget_1 = require("./widget");
/**
 * A dashboard widget that displays alarms in a grid view
 */
class AlarmStatusWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 3);
        this.props = props;
    }
    position(x, y) {
        this.x = x;
        this.y = y;
    }
    toJson() {
        return [
            {
                type: 'alarm',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    title: this.props.title ? this.props.title : 'Alarm Status',
                    alarms: this.props.alarms.map((alarm) => alarm.alarmArn),
                },
            },
        ];
    }
}
exports.AlarmStatusWidget = AlarmStatusWidget;
//# sourceMappingURL=data:application/json;base64,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