"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferenceEvent = void 0;
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
/**
 * Fields of CloudWatch Events that change references
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type
 */
class ReferenceEvent {
    /**
     * The type of reference event
     *
     * 'referenceCreated', 'referenceUpdated' or 'referenceDeleted'
     */
    static get eventType() {
        return events.EventField.fromPath('$.detail.event');
    }
    /**
     * Name of the CodeCommit repository
     */
    static get repositoryName() {
        return events.EventField.fromPath('$.detail.repositoryName');
    }
    /**
     * Id of the CodeCommit repository
     */
    static get repositoryId() {
        return events.EventField.fromPath('$.detail.repositoryId');
    }
    /**
     * Type of reference changed
     *
     * 'branch' or 'tag'
     */
    static get referenceType() {
        return events.EventField.fromPath('$.detail.referenceType');
    }
    /**
     * Name of reference changed (branch or tag name)
     */
    static get referenceName() {
        return events.EventField.fromPath('$.detail.referenceName');
    }
    /**
     * Full reference name
     *
     * For example, 'refs/tags/myTag'
     */
    static get referenceFullName() {
        return events.EventField.fromPath('$.detail.referenceFullName');
    }
    /**
     * Commit id this reference now points to
     */
    static get commitId() {
        return events.EventField.fromPath('$.detail.commitId');
    }
    constructor() {
    }
}
exports.ReferenceEvent = ReferenceEvent;
//# sourceMappingURL=data:application/json;base64,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