"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeploymentGroup = void 0;
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const utils_1 = require("../utils");
const deployment_config_1 = require("./deployment-config");
/**
 * Note: This class currently stands as a namespaced container for importing an ECS
 * Deployment Group defined outside the CDK app until CloudFormation supports provisioning
 * ECS Deployment Groups. Until then it is closed (private constructor) and does not
 * extend {@link cdk.Construct}.
 *
 * @resource AWS::CodeDeploy::DeploymentGroup
 */
class EcsDeploymentGroup {
    /**
     * Import an ECS Deployment Group defined outside the CDK app.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param attrs the properties of the referenced Deployment Group
     * @returns a Construct representing a reference to an existing Deployment Group
     */
    static fromEcsDeploymentGroupAttributes(scope, id, attrs) {
        return new ImportedEcsDeploymentGroup(scope, id, attrs);
    }
    constructor() {
        // nothing to do until CFN supports ECS deployment groups
    }
}
exports.EcsDeploymentGroup = EcsDeploymentGroup;
class ImportedEcsDeploymentGroup extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.application = props.application;
        this.deploymentGroupName = props.deploymentGroupName;
        this.deploymentGroupArn = utils_1.arnForDeploymentGroup(props.application.applicationName, props.deploymentGroupName);
        this.deploymentConfig = props.deploymentConfig || deployment_config_1.EcsDeploymentConfig.ALL_AT_ONCE;
    }
}
//# sourceMappingURL=data:application/json;base64,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