"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlexaSkillDeployAction = void 0;
const codepipeline = require("../../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const action_1 = require("../action");
/**
 * Deploys the skill to Alexa
 */
class AlexaSkillDeployAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.DEPLOY,
            owner: 'ThirdParty',
            provider: 'AlexaSkillsKit',
            artifactBounds: {
                minInputs: 1,
                maxInputs: 2,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: getInputs(props),
        });
        this.props = props;
    }
    bound(_scope, _stage, _options) {
        return {
            configuration: {
                ClientId: this.props.clientId,
                ClientSecret: this.props.clientSecret,
                RefreshToken: this.props.refreshToken,
                SkillId: this.props.skillId,
            },
        };
    }
}
exports.AlexaSkillDeployAction = AlexaSkillDeployAction;
function getInputs(props) {
    const ret = [props.input];
    if (props.parameterOverridesArtifact) {
        ret.push(props.parameterOverridesArtifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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