"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FullActionDescriptor = void 0;
/**
 * This class is private to the aws-codepipeline package.
 */
class FullActionDescriptor {
    constructor(props) {
        this.action = props.action;
        const actionProperties = props.action.actionProperties;
        this.actionName = actionProperties.actionName;
        this.category = actionProperties.category;
        this.owner = actionProperties.owner || 'AWS';
        this.provider = actionProperties.provider;
        this.version = actionProperties.version || '1';
        this.runOrder = actionProperties.runOrder === undefined ? 1 : actionProperties.runOrder;
        this.artifactBounds = actionProperties.artifactBounds;
        this.namespace = actionProperties.variablesNamespace;
        this.inputs = deduplicateArtifacts(actionProperties.inputs);
        this.outputs = deduplicateArtifacts(actionProperties.outputs);
        this.region = props.actionRegion || actionProperties.region;
        this.role = actionProperties.role !== undefined ? actionProperties.role : props.actionRole;
        this.configuration = props.actionConfig.configuration;
    }
}
exports.FullActionDescriptor = FullActionDescriptor;
function deduplicateArtifacts(artifacts) {
    const ret = new Array();
    for (const artifact of artifacts || []) {
        if (artifact.artifactName) {
            if (ret.find(a => a.artifactName === artifact.artifactName)) {
                continue;
            }
        }
        else {
            if (ret.find(a => a === artifact)) {
                continue;
            }
        }
        ret.push(artifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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