"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryVisibility = exports.GitHubRepository = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const codestar = require("./codestar.generated");
/**
 * The GitHubRepository resource
 */
class GitHubRepository extends cdk.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const resource = new codestar.CfnGitHubRepository(this, 'Resource', {
            repositoryOwner: props.owner,
            repositoryName: props.repositoryName,
            repositoryAccessToken: props.accessToken.toString(),
            code: {
                s3: {
                    bucket: props.contentsBucket.bucketName,
                    key: props.contentsKey,
                    objectVersion: props.contentsS3Version,
                },
            },
            enableIssues: (_a = props.enableIssues) !== null && _a !== void 0 ? _a : true,
            isPrivate: props.visibility === RepositoryVisibility.PRIVATE ? true : false,
            repositoryDescription: props.description,
        });
        this.owner = cdk.Fn.select(0, cdk.Fn.split('/', resource.ref));
        this.repo = cdk.Fn.select(1, cdk.Fn.split('/', resource.ref));
    }
}
exports.GitHubRepository = GitHubRepository;
/**
 * Visibility of the GitHubRepository
 */
var RepositoryVisibility;
(function (RepositoryVisibility) {
    /**
     * private repository
     */
    RepositoryVisibility[RepositoryVisibility["PRIVATE"] = 0] = "PRIVATE";
    /**
     * public repository
     */
    RepositoryVisibility[RepositoryVisibility["PUBLIC"] = 1] = "PUBLIC";
})(RepositoryVisibility = exports.RepositoryVisibility || (exports.RepositoryVisibility = {}));
//# sourceMappingURL=data:application/json;base64,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