import { InitElement } from './cfn-init-elements';
/**
 * A CloudFormation-init configuration
 */
export declare class CloudFormationInit {
    /**
     * Build a new config from a set of Init Elements
     */
    static fromElements(...elements: InitElement[]): CloudFormationInit;
    /**
     * Use an existing InitConfig object as the default and only config
     */
    static fromConfig(config: InitConfig): CloudFormationInit;
    /**
     * Build a CloudFormationInit from config sets
     */
    static fromConfigSets(props: ConfigSetProps): CloudFormationInit;
    private readonly _configSets;
    private readonly _configs;
    private constructor();
    /**
     * Add a config with the given name to this CloudFormationInit object
     */
    addConfig(configName: string, config: InitConfig): void;
    /**
     * Add a config set with the given name to this CloudFormationInit object
     *
     * The new configset will reference the given configs in the given order.
     */
    addConfigSet(configSetName: string, configNames?: string[]): void;
    private bind;
}
/**
 * A collection of configuration elements
 */
export declare class InitConfig {
    private readonly elements;
    constructor(elements: InitElement[]);
    /**
     * Whether this configset has elements or not
     */
    isEmpty(): boolean;
    /**
     * Add one or more elements to the config
     */
    add(...elements: InitElement[]): void;
    private bindForType;
    private initPlatformFromOSType;
}
/**
 * Options for CloudFormationInit.withConfigSets
 */
export interface ConfigSetProps {
    /**
     * The definitions of each config set
     */
    readonly configSets: Record<string, string[]>;
    /**
     * The sets of configs to pick from
     */
    readonly configs: Record<string, InitConfig>;
}
