"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcEndpointService = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const region_info_1 = require("../../region-info"); // Automatically re-written from '@aws-cdk/region-info'
const ec2_generated_1 = require("./ec2.generated");
/**
 * A VPC endpoint service
 * @resource AWS::EC2::VPCEndpointService
 * @experimental
 */
class VpcEndpointService extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        if (props.vpcEndpointServiceLoadBalancers === undefined || props.vpcEndpointServiceLoadBalancers.length === 0) {
            throw new Error('VPC Endpoint Service must have at least one load balancer specified.');
        }
        this.vpcEndpointServiceLoadBalancers = props.vpcEndpointServiceLoadBalancers;
        this.acceptanceRequired = props.acceptanceRequired !== undefined ? props.acceptanceRequired : true;
        this.whitelistedPrincipals = props.whitelistedPrincipals !== undefined ? props.whitelistedPrincipals : [];
        this.endpointService = new ec2_generated_1.CfnVPCEndpointService(this, id, {
            networkLoadBalancerArns: this.vpcEndpointServiceLoadBalancers.map(lb => lb.loadBalancerArn),
            acceptanceRequired: this.acceptanceRequired,
        });
        this.vpcEndpointServiceId = this.endpointService.ref;
        const { region } = core_1.Stack.of(this);
        const serviceNamePrefix = !core_1.Token.isUnresolved(region) ? (_a = region_info_1.RegionInfo.get(region).vpcEndpointServiceNamePrefix) !== null && _a !== void 0 ? _a : region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX :
            region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX;
        this.vpcEndpointServiceName = core_1.Fn.join('.', [serviceNamePrefix, core_1.Aws.REGION, this.vpcEndpointServiceId]);
        if (this.whitelistedPrincipals.length > 0) {
            new ec2_generated_1.CfnVPCEndpointServicePermissions(this, 'Permissions', {
                serviceId: this.endpointService.ref,
                allowedPrincipals: this.whitelistedPrincipals.map(x => x.arn),
            });
        }
    }
}
exports.VpcEndpointService = VpcEndpointService;
//# sourceMappingURL=data:application/json;base64,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