"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduledEc2Task = void 0;
const aws_ecs_1 = require("../../../aws-ecs"); // Automatically re-written from '@aws-cdk/aws-ecs'
const scheduled_task_base_1 = require("../base/scheduled-task-base");
/**
 * A scheduled EC2 task that will be initiated off of CloudWatch Events.
 */
class ScheduledEc2Task extends scheduled_task_base_1.ScheduledTaskBase {
    /**
     * Constructs a new instance of the ScheduledEc2Task class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        if (props.scheduledEc2TaskDefinitionOptions && props.scheduledEc2TaskImageOptions) {
            throw new Error('You must specify either a scheduledEc2TaskDefinitionOptions or scheduledEc2TaskOptions, not both.');
        }
        else if (props.scheduledEc2TaskDefinitionOptions) {
            this.taskDefinition = props.scheduledEc2TaskDefinitionOptions.taskDefinition;
        }
        else if (props.scheduledEc2TaskImageOptions) {
            const taskImageOptions = props.scheduledEc2TaskImageOptions;
            // Create a Task Definition for the container to start, also creates a log driver
            this.taskDefinition = new aws_ecs_1.Ec2TaskDefinition(this, 'ScheduledTaskDef');
            this.taskDefinition.addContainer('ScheduledContainer', {
                image: taskImageOptions.image,
                memoryLimitMiB: taskImageOptions.memoryLimitMiB,
                memoryReservationMiB: taskImageOptions.memoryReservationMiB,
                cpu: taskImageOptions.cpu,
                command: taskImageOptions.command,
                environment: taskImageOptions.environment,
                secrets: taskImageOptions.secrets,
                logging: taskImageOptions.logDriver !== undefined ? taskImageOptions.logDriver : this.createAWSLogDriver(this.node.id),
            });
        }
        else {
            throw new Error('You must specify a taskDefinition or image');
        }
        this.addTaskDefinitionToEventTarget(this.taskDefinition);
    }
}
exports.ScheduledEc2Task = ScheduledEc2Task;
//# sourceMappingURL=data:application/json;base64,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