"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcrImage = void 0;
const container_image_1 = require("../container-image");
/**
 * An image from an Amazon ECR repository.
 */
class EcrImage extends container_image_1.ContainerImage {
    /**
     * Constructs a new instance of the EcrImage class.
     */
    constructor(repository, tag) {
        super();
        this.repository = repository;
        this.tag = tag;
        this.imageName = this.repository.repositoryUriForTag(this.tag);
    }
    bind(_scope, containerDefinition) {
        this.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            imageName: this.imageName,
        };
    }
}
exports.EcrImage = EcrImage;
//# sourceMappingURL=data:application/json;base64,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