"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FireLensLogDriver = void 0;
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * FireLens enables you to use task definition parameters to route logs to an AWS service
 *  or AWS Partner Network (APN) destination for log storage and analytics
 */
class FireLensLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the FireLensLogDriver class.
     * @param props the awsfirelens log driver configuration options.
     */
    constructor(props) {
        super();
        this.options = props.options;
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'awsfirelens',
            ...(this.options && { options: utils_1.removeEmpty(this.options) }),
        };
    }
}
exports.FireLensLogDriver = FireLensLogDriver;
//# sourceMappingURL=data:application/json;base64,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