"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentdLogDriver = void 0;
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to journald Logs.
 */
class FluentdLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the FluentdLogDriver class.
     *
     * @param props the fluentd log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'fluentd',
            options: utils_1.stringifyOptions({
                'fluentd-address': this.props.address,
                'fluentd-async-connect': this.props.asyncConnect,
                'fluentd-buffer-limit': this.props.bufferLimit,
                'fluentd-retry-wait': this.props.retryWait && this.props.retryWait.toSeconds(),
                'fluentd-max-retries': this.props.maxRetries,
                'fluentd-sub-second-precision': this.props.subSecondPrecision,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.FluentdLogDriver = FluentdLogDriver;
//# sourceMappingURL=data:application/json;base64,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