"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenericLogDriver = void 0;
const index_1 = require("../index");
const utils_1 = require("./utils");
/**
 * A log driver that sends logs to the specified driver.
 */
class GenericLogDriver extends index_1.LogDriver {
    /**
     * Constructs a new instance of the GenericLogDriver class.
     *
     * @param props the generic log driver configuration options.
     */
    constructor(props) {
        super();
        this.logDriver = props.logDriver;
        this.options = props.options || {};
    }
    /**
     * Called when the log driver is configured on a container.
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: this.logDriver,
            options: utils_1.removeEmpty(this.options),
        };
    }
}
exports.GenericLogDriver = GenericLogDriver;
//# sourceMappingURL=data:application/json;base64,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