"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogDrivers = void 0;
const aws_log_driver_1 = require("./aws-log-driver");
const firelens_log_driver_1 = require("./firelens-log-driver");
const fluentd_log_driver_1 = require("./fluentd-log-driver");
const gelf_log_driver_1 = require("./gelf-log-driver");
const journald_log_driver_1 = require("./journald-log-driver");
const json_file_log_driver_1 = require("./json-file-log-driver");
const splunk_log_driver_1 = require("./splunk-log-driver");
const syslog_log_driver_1 = require("./syslog-log-driver");
/**
 * The base class for log drivers.
 */
class LogDrivers {
    /**
     * Creates a log driver configuration that sends log information to CloudWatch Logs.
     */
    static awsLogs(props) {
        return new aws_log_driver_1.AwsLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to fluentd Logs.
     */
    static fluentd(props) {
        return new fluentd_log_driver_1.FluentdLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to gelf Logs.
     */
    static gelf(props) {
        return new gelf_log_driver_1.GelfLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to journald Logs.
     */
    static journald(props) {
        return new journald_log_driver_1.JournaldLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to json-file Logs.
     */
    static jsonFile(props) {
        return new json_file_log_driver_1.JsonFileLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to splunk Logs.
     */
    static splunk(props) {
        return new splunk_log_driver_1.SplunkLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to syslog Logs.
     */
    static syslog(props) {
        return new syslog_log_driver_1.SyslogLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to firelens log router.
     * For detail configurations, please refer to Amazon ECS FireLens Examples:
     * https://github.com/aws-samples/amazon-ecs-firelens-examples
     */
    static firelens(props) {
        return new firelens_log_driver_1.FireLensLogDriver(props);
    }
}
exports.LogDrivers = LogDrivers;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9nLWRyaXZlcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsb2ctZHJpdmVycy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxxREFBbUU7QUFDbkUsK0RBQWtGO0FBQ2xGLDZEQUErRTtBQUMvRSx1REFBc0U7QUFDdEUsK0RBQWtGO0FBQ2xGLGlFQUFtRjtBQUVuRiwyREFBNEU7QUFDNUUsMkRBQTRFO0FBQzVFOztHQUVHO0FBQ0gsTUFBYSxVQUFVO0lBQ25COztPQUVHO0lBQ0ksTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUF3QjtRQUMxQyxPQUFPLElBQUksNkJBQVksQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Q7O09BRUc7SUFDSSxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQTZCO1FBQy9DLE9BQU8sSUFBSSxxQ0FBZ0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBQ0Q7O09BRUc7SUFDSSxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQXlCO1FBQ3hDLE9BQU8sSUFBSSwrQkFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFDRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBOEI7UUFDakQsT0FBTyxJQUFJLHVDQUFpQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFDRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBOEI7UUFDakQsT0FBTyxJQUFJLHdDQUFpQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFDRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxNQUFNLENBQUMsS0FBMkI7UUFDNUMsT0FBTyxJQUFJLG1DQUFlLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUNEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLE1BQU0sQ0FBQyxLQUE0QjtRQUM3QyxPQUFPLElBQUksbUNBQWUsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBQ0Q7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBNkI7UUFDaEQsT0FBTyxJQUFJLHVDQUFpQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3hDLENBQUM7Q0FDSjtBQW5ERCxnQ0FtREMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBd3NMb2dEcml2ZXIsIEF3c0xvZ0RyaXZlclByb3BzIH0gZnJvbSAnLi9hd3MtbG9nLWRyaXZlcic7XG5pbXBvcnQgeyBGaXJlTGVuc0xvZ0RyaXZlciwgRmlyZUxlbnNMb2dEcml2ZXJQcm9wcyB9IGZyb20gJy4vZmlyZWxlbnMtbG9nLWRyaXZlcic7XG5pbXBvcnQgeyBGbHVlbnRkTG9nRHJpdmVyLCBGbHVlbnRkTG9nRHJpdmVyUHJvcHMgfSBmcm9tICcuL2ZsdWVudGQtbG9nLWRyaXZlcic7XG5pbXBvcnQgeyBHZWxmTG9nRHJpdmVyLCBHZWxmTG9nRHJpdmVyUHJvcHMgfSBmcm9tICcuL2dlbGYtbG9nLWRyaXZlcic7XG5pbXBvcnQgeyBKb3VybmFsZExvZ0RyaXZlciwgSm91cm5hbGRMb2dEcml2ZXJQcm9wcyB9IGZyb20gJy4vam91cm5hbGQtbG9nLWRyaXZlcic7XG5pbXBvcnQgeyBKc29uRmlsZUxvZ0RyaXZlciwgSnNvbkZpbGVMb2dEcml2ZXJQcm9wcyB9IGZyb20gJy4vanNvbi1maWxlLWxvZy1kcml2ZXInO1xuaW1wb3J0IHsgTG9nRHJpdmVyIH0gZnJvbSAnLi9sb2ctZHJpdmVyJztcbmltcG9ydCB7IFNwbHVua0xvZ0RyaXZlciwgU3BsdW5rTG9nRHJpdmVyUHJvcHMgfSBmcm9tICcuL3NwbHVuay1sb2ctZHJpdmVyJztcbmltcG9ydCB7IFN5c2xvZ0xvZ0RyaXZlciwgU3lzbG9nTG9nRHJpdmVyUHJvcHMgfSBmcm9tICcuL3N5c2xvZy1sb2ctZHJpdmVyJztcbi8qKlxuICogVGhlIGJhc2UgY2xhc3MgZm9yIGxvZyBkcml2ZXJzLlxuICovXG5leHBvcnQgY2xhc3MgTG9nRHJpdmVycyB7XG4gICAgLyoqXG4gICAgICogQ3JlYXRlcyBhIGxvZyBkcml2ZXIgY29uZmlndXJhdGlvbiB0aGF0IHNlbmRzIGxvZyBpbmZvcm1hdGlvbiB0byBDbG91ZFdhdGNoIExvZ3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBhd3NMb2dzKHByb3BzOiBBd3NMb2dEcml2ZXJQcm9wcyk6IExvZ0RyaXZlciB7XG4gICAgICAgIHJldHVybiBuZXcgQXdzTG9nRHJpdmVyKHByb3BzKTtcbiAgICB9XG4gICAgLyoqXG4gICAgICogQ3JlYXRlcyBhIGxvZyBkcml2ZXIgY29uZmlndXJhdGlvbiB0aGF0IHNlbmRzIGxvZyBpbmZvcm1hdGlvbiB0byBmbHVlbnRkIExvZ3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBmbHVlbnRkKHByb3BzPzogRmx1ZW50ZExvZ0RyaXZlclByb3BzKTogTG9nRHJpdmVyIHtcbiAgICAgICAgcmV0dXJuIG5ldyBGbHVlbnRkTG9nRHJpdmVyKHByb3BzKTtcbiAgICB9XG4gICAgLyoqXG4gICAgICogQ3JlYXRlcyBhIGxvZyBkcml2ZXIgY29uZmlndXJhdGlvbiB0aGF0IHNlbmRzIGxvZyBpbmZvcm1hdGlvbiB0byBnZWxmIExvZ3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBnZWxmKHByb3BzOiBHZWxmTG9nRHJpdmVyUHJvcHMpOiBMb2dEcml2ZXIge1xuICAgICAgICByZXR1cm4gbmV3IEdlbGZMb2dEcml2ZXIocHJvcHMpO1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBDcmVhdGVzIGEgbG9nIGRyaXZlciBjb25maWd1cmF0aW9uIHRoYXQgc2VuZHMgbG9nIGluZm9ybWF0aW9uIHRvIGpvdXJuYWxkIExvZ3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBqb3VybmFsZChwcm9wcz86IEpvdXJuYWxkTG9nRHJpdmVyUHJvcHMpOiBMb2dEcml2ZXIge1xuICAgICAgICByZXR1cm4gbmV3IEpvdXJuYWxkTG9nRHJpdmVyKHByb3BzKTtcbiAgICB9XG4gICAgLyoqXG4gICAgICogQ3JlYXRlcyBhIGxvZyBkcml2ZXIgY29uZmlndXJhdGlvbiB0aGF0IHNlbmRzIGxvZyBpbmZvcm1hdGlvbiB0byBqc29uLWZpbGUgTG9ncy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIGpzb25GaWxlKHByb3BzPzogSnNvbkZpbGVMb2dEcml2ZXJQcm9wcyk6IExvZ0RyaXZlciB7XG4gICAgICAgIHJldHVybiBuZXcgSnNvbkZpbGVMb2dEcml2ZXIocHJvcHMpO1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBDcmVhdGVzIGEgbG9nIGRyaXZlciBjb25maWd1cmF0aW9uIHRoYXQgc2VuZHMgbG9nIGluZm9ybWF0aW9uIHRvIHNwbHVuayBMb2dzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgc3BsdW5rKHByb3BzOiBTcGx1bmtMb2dEcml2ZXJQcm9wcyk6IExvZ0RyaXZlciB7XG4gICAgICAgIHJldHVybiBuZXcgU3BsdW5rTG9nRHJpdmVyKHByb3BzKTtcbiAgICB9XG4gICAgLyoqXG4gICAgICogQ3JlYXRlcyBhIGxvZyBkcml2ZXIgY29uZmlndXJhdGlvbiB0aGF0IHNlbmRzIGxvZyBpbmZvcm1hdGlvbiB0byBzeXNsb2cgTG9ncy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHN5c2xvZyhwcm9wcz86IFN5c2xvZ0xvZ0RyaXZlclByb3BzKTogTG9nRHJpdmVyIHtcbiAgICAgICAgcmV0dXJuIG5ldyBTeXNsb2dMb2dEcml2ZXIocHJvcHMpO1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBDcmVhdGVzIGEgbG9nIGRyaXZlciBjb25maWd1cmF0aW9uIHRoYXQgc2VuZHMgbG9nIGluZm9ybWF0aW9uIHRvIGZpcmVsZW5zIGxvZyByb3V0ZXIuXG4gICAgICogRm9yIGRldGFpbCBjb25maWd1cmF0aW9ucywgcGxlYXNlIHJlZmVyIHRvIEFtYXpvbiBFQ1MgRmlyZUxlbnMgRXhhbXBsZXM6XG4gICAgICogaHR0cHM6Ly9naXRodWIuY29tL2F3cy1zYW1wbGVzL2FtYXpvbi1lY3MtZmlyZWxlbnMtZXhhbXBsZXNcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIGZpcmVsZW5zKHByb3BzOiBGaXJlTGVuc0xvZ0RyaXZlclByb3BzKTogTG9nRHJpdmVyIHtcbiAgICAgICAgcmV0dXJuIG5ldyBGaXJlTGVuc0xvZ0RyaXZlcihwcm9wcyk7XG4gICAgfVxufVxuIl19