"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyslogLogDriver = void 0;
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to syslog Logs.
 */
class SyslogLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the SyslogLogDriver class.
     *
     * @param props the syslog log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'syslog',
            options: utils_1.stringifyOptions({
                'syslog-address': this.props.address,
                'syslog-facility': this.props.facility,
                'syslog-tls-ca-cert': this.props.tlsCaCert,
                'syslog-tls-cert': this.props.tlsCert,
                'syslog-tls-key': this.props.tlsKey,
                'syslog-tls-skip-verify': this.props.tlsSkipVerify,
                'syslog-format': this.props.format,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.SyslogLogDriver = SyslogLogDriver;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3lzbG9nLWxvZy1kcml2ZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzeXNsb2ctbG9nLWRyaXZlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFHQSw2Q0FBMEQ7QUFDMUQsbUNBQXlFO0FBNER6RTs7R0FFRztBQUNILE1BQWEsZUFBZ0IsU0FBUSxzQkFBUztJQUMxQzs7OztPQUlHO0lBQ0gsWUFBNkIsUUFBOEIsRUFBRTtRQUN6RCxLQUFLLEVBQUUsQ0FBQztRQURpQixVQUFLLEdBQUwsS0FBSyxDQUEyQjtJQUU3RCxDQUFDO0lBQ0Q7O09BRUc7SUFDSSxJQUFJLENBQUMsTUFBaUIsRUFBRSxvQkFBeUM7UUFDcEUsT0FBTztZQUNILFNBQVMsRUFBRSxRQUFRO1lBQ25CLE9BQU8sRUFBRSx3QkFBZ0IsQ0FBQztnQkFDdEIsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPO2dCQUNwQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7Z0JBQ3RDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUztnQkFDMUMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPO2dCQUNyQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU07Z0JBQ25DLHdCQUF3QixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYTtnQkFDbEQsZUFBZSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTTtnQkFDbEMsR0FBRyxvQ0FBNEIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO2FBQzlDLENBQUM7U0FDTCxDQUFDO0lBQ04sQ0FBQztDQUNKO0FBM0JELDBDQTJCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCIuLi8uLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuaW1wb3J0IHsgQ29udGFpbmVyRGVmaW5pdGlvbiB9IGZyb20gJy4uL2NvbnRhaW5lci1kZWZpbml0aW9uJztcbmltcG9ydCB7IEJhc2VMb2dEcml2ZXJQcm9wcyB9IGZyb20gJy4vYmFzZS1sb2ctZHJpdmVyJztcbmltcG9ydCB7IExvZ0RyaXZlciwgTG9nRHJpdmVyQ29uZmlnIH0gZnJvbSAnLi9sb2ctZHJpdmVyJztcbmltcG9ydCB7IHJlbmRlckNvbW1vbkxvZ0RyaXZlck9wdGlvbnMsIHN0cmluZ2lmeU9wdGlvbnMgfSBmcm9tICcuL3V0aWxzJztcbi8qKlxuICogU3BlY2lmaWVzIHRoZSBzeXNsb2cgbG9nIGRyaXZlciBjb25maWd1cmF0aW9uIG9wdGlvbnMuXG4gKlxuICogW1NvdXJjZV0oaHR0cHM6Ly9kb2NzLmRvY2tlci5jb20vY29uZmlnL2NvbnRhaW5lcnMvbG9nZ2luZy9zeXNsb2cvKVxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN5c2xvZ0xvZ0RyaXZlclByb3BzIGV4dGVuZHMgQmFzZUxvZ0RyaXZlclByb3BzIHtcbiAgICAvKipcbiAgICAgKiBUaGUgYWRkcmVzcyBvZiBhbiBleHRlcm5hbCBzeXNsb2cgc2VydmVyLiBUaGUgVVJJIHNwZWNpZmllciBtYXkgYmVcbiAgICAgKiBbdGNwfHVkcHx0Y3ArdGxzXTovL2hvc3Q6cG9ydCwgdW5peDovL3BhdGgsIG9yIHVuaXhncmFtOi8vcGF0aC5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gSWYgdGhlIHRyYW5zcG9ydCBpcyB0Y3AsIHVkcCwgb3IgdGNwK3RscywgdGhlIGRlZmF1bHQgcG9ydCBpcyA1MTQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYWRkcmVzcz86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBUaGUgc3lzbG9nIGZhY2lsaXR5IHRvIHVzZS4gQ2FuIGJlIHRoZSBudW1iZXIgb3IgbmFtZSBmb3IgYW55IHZhbGlkXG4gICAgICogc3lzbG9nIGZhY2lsaXR5LiBTZWUgdGhlIHN5c2xvZyBkb2N1bWVudGF0aW9uOlxuICAgICAqIGh0dHBzOi8vdG9vbHMuaWV0Zi5vcmcvaHRtbC9yZmM1NDI0I3NlY3Rpb24tNi4yLjEuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIGZhY2lsaXR5IG5vdCBzZXRcbiAgICAgKi9cbiAgICByZWFkb25seSBmYWNpbGl0eT86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBUaGUgYWJzb2x1dGUgcGF0aCB0byB0aGUgdHJ1c3QgY2VydGlmaWNhdGVzIHNpZ25lZCBieSB0aGUgQ0EuIElnbm9yZWRcbiAgICAgKiBpZiB0aGUgYWRkcmVzcyBwcm90b2NvbCBpcyBub3QgdGNwK3Rscy5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gdGxzQ2FDZXJ0IG5vdCBzZXRcbiAgICAgKi9cbiAgICByZWFkb25seSB0bHNDYUNlcnQ/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIGFic29sdXRlIHBhdGggdG8gdGhlIFRMUyBjZXJ0aWZpY2F0ZSBmaWxlLiBJZ25vcmVkIGlmIHRoZSBhZGRyZXNzXG4gICAgICogcHJvdG9jb2wgaXMgbm90IHRjcCt0bHMuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIHRsc0NlcnQgbm90IHNldFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRsc0NlcnQ/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIGFic29sdXRlIHBhdGggdG8gdGhlIFRMUyBrZXkgZmlsZS4gSWdub3JlZCBpZiB0aGUgYWRkcmVzcyBwcm90b2NvbFxuICAgICAqIGlzIG5vdCB0Y3ArdGxzLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSB0bHNLZXkgbm90IHNldFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRsc0tleT86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBJZiBzZXQgdG8gdHJ1ZSwgVExTIHZlcmlmaWNhdGlvbiBpcyBza2lwcGVkIHdoZW4gY29ubmVjdGluZyB0byB0aGUgc3lzbG9nXG4gICAgICogZGFlbW9uLiBJZ25vcmVkIGlmIHRoZSBhZGRyZXNzIHByb3RvY29sIGlzIG5vdCB0Y3ArdGxzLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBmYWxzZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRsc1NraXBWZXJpZnk/OiBib29sZWFuO1xuICAgIC8qKlxuICAgICAqIFRoZSBzeXNsb2cgbWVzc2FnZSBmb3JtYXQgdG8gdXNlLiBJZiBub3Qgc3BlY2lmaWVkIHRoZSBsb2NhbCBVTklYIHN5c2xvZ1xuICAgICAqIGZvcm1hdCBpcyB1c2VkLCB3aXRob3V0IGEgc3BlY2lmaWVkIGhvc3RuYW1lLiBTcGVjaWZ5IHJmYzMxNjQgZm9yIHRoZSBSRkMtMzE2NFxuICAgICAqIGNvbXBhdGlibGUgZm9ybWF0LCByZmM1NDI0IGZvciBSRkMtNTQyNCBjb21wYXRpYmxlIGZvcm1hdCwgb3IgcmZjNTQyNG1pY3JvXG4gICAgICogZm9yIFJGQy01NDI0IGNvbXBhdGlibGUgZm9ybWF0IHdpdGggbWljcm9zZWNvbmQgdGltZXN0YW1wIHJlc29sdXRpb24uXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIGZvcm1hdCBub3Qgc2V0XG4gICAgICovXG4gICAgcmVhZG9ubHkgZm9ybWF0Pzogc3RyaW5nO1xufVxuLyoqXG4gKiBBIGxvZyBkcml2ZXIgdGhhdCBzZW5kcyBsb2cgaW5mb3JtYXRpb24gdG8gc3lzbG9nIExvZ3MuXG4gKi9cbmV4cG9ydCBjbGFzcyBTeXNsb2dMb2dEcml2ZXIgZXh0ZW5kcyBMb2dEcml2ZXIge1xuICAgIC8qKlxuICAgICAqIENvbnN0cnVjdHMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhlIFN5c2xvZ0xvZ0RyaXZlciBjbGFzcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBwcm9wcyB0aGUgc3lzbG9nIGxvZyBkcml2ZXIgY29uZmlndXJhdGlvbiBvcHRpb25zLlxuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFN5c2xvZ0xvZ0RyaXZlclByb3BzID0ge30pIHtcbiAgICAgICAgc3VwZXIoKTtcbiAgICB9XG4gICAgLyoqXG4gICAgICogQ2FsbGVkIHdoZW4gdGhlIGxvZyBkcml2ZXIgaXMgY29uZmlndXJlZCBvbiBhIGNvbnRhaW5lclxuICAgICAqL1xuICAgIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0LCBfY29udGFpbmVyRGVmaW5pdGlvbjogQ29udGFpbmVyRGVmaW5pdGlvbik6IExvZ0RyaXZlckNvbmZpZyB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBsb2dEcml2ZXI6ICdzeXNsb2cnLFxuICAgICAgICAgICAgb3B0aW9uczogc3RyaW5naWZ5T3B0aW9ucyh7XG4gICAgICAgICAgICAgICAgJ3N5c2xvZy1hZGRyZXNzJzogdGhpcy5wcm9wcy5hZGRyZXNzLFxuICAgICAgICAgICAgICAgICdzeXNsb2ctZmFjaWxpdHknOiB0aGlzLnByb3BzLmZhY2lsaXR5LFxuICAgICAgICAgICAgICAgICdzeXNsb2ctdGxzLWNhLWNlcnQnOiB0aGlzLnByb3BzLnRsc0NhQ2VydCxcbiAgICAgICAgICAgICAgICAnc3lzbG9nLXRscy1jZXJ0JzogdGhpcy5wcm9wcy50bHNDZXJ0LFxuICAgICAgICAgICAgICAgICdzeXNsb2ctdGxzLWtleSc6IHRoaXMucHJvcHMudGxzS2V5LFxuICAgICAgICAgICAgICAgICdzeXNsb2ctdGxzLXNraXAtdmVyaWZ5JzogdGhpcy5wcm9wcy50bHNTa2lwVmVyaWZ5LFxuICAgICAgICAgICAgICAgICdzeXNsb2ctZm9ybWF0JzogdGhpcy5wcm9wcy5mb3JtYXQsXG4gICAgICAgICAgICAgICAgLi4ucmVuZGVyQ29tbW9uTG9nRHJpdmVyT3B0aW9ucyh0aGlzLnByb3BzKSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==