"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppMeshProxyConfiguration = void 0;
const proxy_configuration_1 = require("./proxy-configuration");
/**
 * The class for App Mesh proxy configurations.
 *
 * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent and at least version
 * 1.26.0-1 of the ecs-init package to enable a proxy configuration. If your container instances are launched from the Amazon ECS-optimized
 * AMI version 20190301 or later, then they contain the required versions of the container agent and ecs-init.
 * For more information, see [Amazon ECS-optimized AMIs](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html).
 *
 * For tasks using the Fargate launch type, the task or service requires platform version 1.3.0 or later.
 */
class AppMeshProxyConfiguration extends proxy_configuration_1.ProxyConfiguration {
    /**
     * Constructs a new instance of the AppMeshProxyConfiguration class.
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.properties) {
            if (!props.properties.ignoredUID && !props.properties.ignoredGID) {
                throw new Error('At least one of ignoredUID or ignoredGID should be specified.');
            }
        }
    }
    /**
     * Called when the proxy configuration is configured on a task definition.
     */
    bind(_scope, _taskDefinition) {
        const configProps = this.props.properties;
        const configType = 'APPMESH';
        return {
            containerName: this.props.containerName,
            proxyConfigurationProperties: renderProperties(configProps),
            type: configType,
        };
    }
}
exports.AppMeshProxyConfiguration = AppMeshProxyConfiguration;
function renderProperties(props) {
    const ret = new Array();
    for (const [k, v] of Object.entries(props)) {
        const key = String(k);
        const value = String(v);
        if (value !== 'undefined' && value !== '') {
            const capitalizedKey = key.charAt(0).toUpperCase() + key.slice(1);
            ret.push({ ['name']: capitalizedKey, ['value']: value });
        }
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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