"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.spotInterruptHandler = exports.LifecycleLabel = void 0;
var LifecycleLabel;
(function (LifecycleLabel) {
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
const DEFAULT_NODE_SELECTOR = { lifecycle: LifecycleLabel.SPOT };
function spotInterruptHandler(nodeSelector = DEFAULT_NODE_SELECTOR) {
    return [
        {
            kind: 'ClusterRole',
            apiVersion: 'rbac.authorization.k8s.io/v1',
            metadata: {
                name: 'node-termination-handler',
                namespace: 'default',
            },
            rules: [
                {
                    apiGroups: [
                        'apps',
                    ],
                    resources: [
                        'daemonsets',
                    ],
                    verbs: [
                        'get',
                        'delete',
                    ],
                },
                {
                    apiGroups: [
                        '',
                    ],
                    resources: [
                        '*',
                    ],
                    verbs: [
                        '*',
                    ],
                },
                {
                    apiGroups: [
                        'rbac.authorization.k8s.io',
                    ],
                    resources: [
                        '*',
                    ],
                    verbs: [
                        '*',
                    ],
                },
                {
                    apiGroups: [
                        'apiextensions.k8s.io',
                    ],
                    resources: [
                        'customresourcedefinitions',
                    ],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                        'create',
                        'delete',
                    ],
                },
            ],
        },
        {
            apiVersion: 'v1',
            kind: 'ServiceAccount',
            metadata: {
                name: 'node-termination-handler',
            },
        },
        {
            kind: 'ClusterRoleBinding',
            apiVersion: 'rbac.authorization.k8s.io/v1',
            metadata: {
                name: 'node-termination-handler',
                namespace: 'default',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: 'node-termination-handler',
                    namespace: 'default',
                },
            ],
            roleRef: {
                kind: 'ClusterRole',
                name: 'node-termination-handler',
                apiGroup: 'rbac.authorization.k8s.io',
            },
        },
        {
            apiVersion: 'apps/v1beta2',
            kind: 'DaemonSet',
            metadata: {
                name: 'node-termination-handler',
                namespace: 'default',
            },
            spec: {
                selector: {
                    matchLabels: {
                        app: 'node-termination-handler',
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            app: 'node-termination-handler',
                        },
                    },
                    spec: {
                        serviceAccountName: 'node-termination-handler',
                        containers: [
                            {
                                name: 'node-termination-handler',
                                image: 'amazon/aws-node-termination-handler:v1.0.0',
                                imagePullPolicy: 'Always',
                                env: [
                                    {
                                        name: 'NODE_NAME',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'spec.nodeName',
                                            },
                                        },
                                    },
                                    {
                                        name: 'POD_NAME',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'metadata.name',
                                            },
                                        },
                                    },
                                    {
                                        name: 'NAMESPACE',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'metadata.namespace',
                                            },
                                        },
                                    },
                                    {
                                        name: 'SPOT_POD_IP',
                                        valueFrom: {
                                            fieldRef: {
                                                fieldPath: 'status.podIP',
                                            },
                                        },
                                    },
                                ],
                                resources: {
                                    requests: {
                                        memory: '64Mi',
                                        cpu: '50m',
                                    },
                                    limits: {
                                        memory: '128Mi',
                                        cpu: '100m',
                                    },
                                },
                            },
                        ],
                        nodeSelector,
                    },
                },
            },
        },
    ];
}
exports.spotInterruptHandler = spotInterruptHandler;
//# sourceMappingURL=data:application/json;base64,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