"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesManifest = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const kubectl_provider_1 = require("./kubectl-provider");
/**
 * Represents a manifest within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addManifest(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the manifest using `kubectl`.
 */
class KubernetesManifest extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: KubernetesManifest.RESOURCE_TYPE,
            properties: {
                // `toJsonString` enables embedding CDK tokens in the manifest and will
                // render a CloudFormation-compatible JSON string (similar to
                // StepFunctions, CloudWatch Dashboards etc).
                Manifest: stack.toJsonString(props.manifest),
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
            },
        });
    }
}
exports.KubernetesManifest = KubernetesManifest;
/**
 * The CloudFormation reosurce type.
 */
KubernetesManifest.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesResource';
//# sourceMappingURL=data:application/json;base64,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