"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesObjectValue = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const kubectl_provider_1 = require("./kubectl-provider");
/**
 * Represents a value of a specific object deployed in the cluster.
 * Use this to fetch any information available by the `kubectl get` command.
 */
class KubernetesObjectValue extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        this._resource = new core_1.CustomResource(this, 'Resource', {
            resourceType: KubernetesObjectValue.RESOURCE_TYPE,
            serviceToken: provider.serviceToken,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                ObjectType: props.objectType,
                ObjectName: props.objectName,
                ObjectNamespace: (_a = props.objectNamespace) !== null && _a !== void 0 ? _a : 'default',
                JsonPath: props.jsonPath,
                TimeoutSeconds: ((_b = props === null || props === void 0 ? void 0 : props.timeout) !== null && _b !== void 0 ? _b : core_1.Duration.minutes(5)).toSeconds(),
            },
        });
    }
    /**
     * The value as a string token.
     */
    get value() {
        return core_1.Token.asString(this._resource.getAtt('Value'));
    }
}
exports.KubernetesObjectValue = KubernetesObjectValue;
/**
 * The CloudFormation reosurce type.
 */
KubernetesObjectValue.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-KubernetesObjectValue';
//# sourceMappingURL=data:application/json;base64,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