"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubectlLayer = void 0;
const crypto = require("crypto");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const KUBECTL_APP_ARN = 'arn:aws:serverlessrepo:us-east-1:903779448426:applications/lambda-layer-kubectl';
const KUBECTL_APP_CN_ARN = 'arn:aws-cn:serverlessrepo:cn-north-1:487369736442:applications/lambda-layer-kubectl';
const KUBECTL_APP_VERSION = '2.0.0';
/**
 * An AWS Lambda layer that includes kubectl and the AWS CLI.
 *
 * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
 */
class KubectlLayer extends core_1.Construct {
    constructor(scope, id, props = {}) {
        var _a, _b;
        super(scope, id);
        /**
         * All runtimes are compatible.
         */
        this.compatibleRuntimes = undefined;
        this.stack = core_1.Stack.of(this);
        this.env = {
            account: this.stack.account,
            region: this.stack.region,
        };
        const uniqueId = crypto.createHash('md5').update(this.node.path).digest('hex');
        const version = (_a = props.version) !== null && _a !== void 0 ? _a : KUBECTL_APP_VERSION;
        const applictionId = (_b = props.applicationId) !== null && _b !== void 0 ? _b : (this.isChina() ? KUBECTL_APP_CN_ARN : KUBECTL_APP_ARN);
        this.stack.templateOptions.transforms = ['AWS::Serverless-2016-10-31']; // required for AWS::Serverless
        const resource = new core_1.CfnResource(this, 'Resource', {
            type: 'AWS::Serverless::Application',
            properties: {
                Location: {
                    ApplicationId: applictionId,
                    SemanticVersion: version,
                },
                Parameters: {
                    LayerName: `kubectl-${uniqueId}`,
                },
            },
        });
        this.layerVersionArn = core_1.Token.asString(resource.getAtt('Outputs.LayerVersionArn'));
    }
    addPermission(_id, _permission) {
        return;
    }
    isChina() {
        const region = this.stack.region;
        return !core_1.Token.isUnresolved(region) && region.startsWith('cn-');
    }
}
exports.KubectlLayer = KubectlLayer;
//# sourceMappingURL=data:application/json;base64,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