import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::ElasticLoadBalancing::LoadBalancer`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 */
export interface CfnLoadBalancerProps {
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
     */
    readonly listeners: Array<CfnLoadBalancer.ListenersProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
     */
    readonly accessLoggingPolicy?: CfnLoadBalancer.AccessLoggingPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
     */
    readonly appCookieStickinessPolicy?: Array<CfnLoadBalancer.AppCookieStickinessPolicyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AvailabilityZones`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-availabilityzones
     */
    readonly availabilityZones?: string[];
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
     */
    readonly connectionDrainingPolicy?: CfnLoadBalancer.ConnectionDrainingPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
     */
    readonly connectionSettings?: CfnLoadBalancer.ConnectionSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
     */
    readonly crossZone?: boolean | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
     */
    readonly healthCheck?: CfnLoadBalancer.HealthCheckProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Instances`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-instances
     */
    readonly instances?: string[];
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
     */
    readonly lbCookieStickinessPolicy?: Array<CfnLoadBalancer.LBCookieStickinessPolicyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LoadBalancerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-elbname
     */
    readonly loadBalancerName?: string;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
     */
    readonly policies?: Array<CfnLoadBalancer.PoliciesProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Scheme`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-scheme
     */
    readonly scheme?: string;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.SecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-securitygroups
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Subnets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-subnets
     */
    readonly subnets?: string[];
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-elasticloadbalancing-loadbalancer-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`
 *
 * @cloudformationResource AWS::ElasticLoadBalancing::LoadBalancer
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 */
export declare class CfnLoadBalancer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancing::LoadBalancer";
    /**
     * @cloudformationAttribute CanonicalHostedZoneName
     */
    readonly attrCanonicalHostedZoneName: string;
    /**
     * @cloudformationAttribute CanonicalHostedZoneNameID
     */
    readonly attrCanonicalHostedZoneNameId: string;
    /**
     * @cloudformationAttribute DNSName
     */
    readonly attrDnsName: string;
    /**
     * @cloudformationAttribute SourceSecurityGroup.GroupName
     */
    readonly attrSourceSecurityGroupGroupName: string;
    /**
     * @cloudformationAttribute SourceSecurityGroup.OwnerAlias
     */
    readonly attrSourceSecurityGroupOwnerAlias: string;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
     */
    listeners: Array<CfnLoadBalancer.ListenersProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
     */
    accessLoggingPolicy: CfnLoadBalancer.AccessLoggingPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
     */
    appCookieStickinessPolicy: Array<CfnLoadBalancer.AppCookieStickinessPolicyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AvailabilityZones`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-availabilityzones
     */
    availabilityZones: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
     */
    connectionDrainingPolicy: CfnLoadBalancer.ConnectionDrainingPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
     */
    connectionSettings: CfnLoadBalancer.ConnectionSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
     */
    crossZone: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
     */
    healthCheck: CfnLoadBalancer.HealthCheckProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Instances`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-instances
     */
    instances: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
     */
    lbCookieStickinessPolicy: Array<CfnLoadBalancer.LBCookieStickinessPolicyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LoadBalancerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-elbname
     */
    loadBalancerName: string | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
     */
    policies: Array<CfnLoadBalancer.PoliciesProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Scheme`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-scheme
     */
    scheme: string | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.SecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-securitygroups
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Subnets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-subnets
     */
    subnets: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-elasticloadbalancing-loadbalancer-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ElasticLoadBalancing::LoadBalancer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLoadBalancerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnLoadBalancer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html
     */
    interface AccessLoggingPolicyProperty {
        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.EmitInterval`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-emitinterval
         */
        readonly emitInterval?: number;
        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-s3bucketname
         */
        readonly s3BucketName: string;
        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketPrefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-s3bucketprefix
         */
        readonly s3BucketPrefix?: string;
    }
}
export declare namespace CfnLoadBalancer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html
     */
    interface AppCookieStickinessPolicyProperty {
        /**
         * `CfnLoadBalancer.AppCookieStickinessPolicyProperty.CookieName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html#cfn-elb-appcookiestickinesspolicy-cookiename
         */
        readonly cookieName: string;
        /**
         * `CfnLoadBalancer.AppCookieStickinessPolicyProperty.PolicyName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html#cfn-elb-appcookiestickinesspolicy-policyname
         */
        readonly policyName: string;
    }
}
export declare namespace CfnLoadBalancer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html
     */
    interface ConnectionDrainingPolicyProperty {
        /**
         * `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html#cfn-elb-connectiondrainingpolicy-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Timeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html#cfn-elb-connectiondrainingpolicy-timeout
         */
        readonly timeout?: number;
    }
}
export declare namespace CfnLoadBalancer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectionsettings.html
     */
    interface ConnectionSettingsProperty {
        /**
         * `CfnLoadBalancer.ConnectionSettingsProperty.IdleTimeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectionsettings.html#cfn-elb-connectionsettings-idletimeout
         */
        readonly idleTimeout: number;
    }
}
export declare namespace CfnLoadBalancer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html
     */
    interface HealthCheckProperty {
        /**
         * `CfnLoadBalancer.HealthCheckProperty.HealthyThreshold`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-healthythreshold
         */
        readonly healthyThreshold: string;
        /**
         * `CfnLoadBalancer.HealthCheckProperty.Interval`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-interval
         */
        readonly interval: string;
        /**
         * `CfnLoadBalancer.HealthCheckProperty.Target`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-target
         */
        readonly target: string;
        /**
         * `CfnLoadBalancer.HealthCheckProperty.Timeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-timeout
         */
        readonly timeout: string;
        /**
         * `CfnLoadBalancer.HealthCheckProperty.UnhealthyThreshold`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-unhealthythreshold
         */
        readonly unhealthyThreshold: string;
    }
}
export declare namespace CfnLoadBalancer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html
     */
    interface LBCookieStickinessPolicyProperty {
        /**
         * `CfnLoadBalancer.LBCookieStickinessPolicyProperty.CookieExpirationPeriod`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html#cfn-elb-lbcookiestickinesspolicy-cookieexpirationperiod
         */
        readonly cookieExpirationPeriod?: string;
        /**
         * `CfnLoadBalancer.LBCookieStickinessPolicyProperty.PolicyName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html#cfn-elb-lbcookiestickinesspolicy-policyname
         */
        readonly policyName?: string;
    }
}
export declare namespace CfnLoadBalancer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html
     */
    interface ListenersProperty {
        /**
         * `CfnLoadBalancer.ListenersProperty.InstancePort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-instanceport
         */
        readonly instancePort: string;
        /**
         * `CfnLoadBalancer.ListenersProperty.InstanceProtocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-instanceprotocol
         */
        readonly instanceProtocol?: string;
        /**
         * `CfnLoadBalancer.ListenersProperty.LoadBalancerPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-loadbalancerport
         */
        readonly loadBalancerPort: string;
        /**
         * `CfnLoadBalancer.ListenersProperty.PolicyNames`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-policynames
         */
        readonly policyNames?: string[];
        /**
         * `CfnLoadBalancer.ListenersProperty.Protocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-protocol
         */
        readonly protocol: string;
        /**
         * `CfnLoadBalancer.ListenersProperty.SSLCertificateId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-sslcertificateid
         */
        readonly sslCertificateId?: string;
    }
}
export declare namespace CfnLoadBalancer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html
     */
    interface PoliciesProperty {
        /**
         * `CfnLoadBalancer.PoliciesProperty.Attributes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-attributes
         */
        readonly attributes: Array<any | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLoadBalancer.PoliciesProperty.InstancePorts`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-instanceports
         */
        readonly instancePorts?: string[];
        /**
         * `CfnLoadBalancer.PoliciesProperty.LoadBalancerPorts`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-loadbalancerports
         */
        readonly loadBalancerPorts?: string[];
        /**
         * `CfnLoadBalancer.PoliciesProperty.PolicyName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-policyname
         */
        readonly policyName: string;
        /**
         * `CfnLoadBalancer.PoliciesProperty.PolicyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-policytype
         */
        readonly policyType: string;
    }
}
