"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetType = exports.SslPolicy = exports.ApplicationProtocol = exports.Protocol = exports.IpAddressType = void 0;
/**
 * What kind of addresses to allocate to the load balancer
 */
var IpAddressType;
(function (IpAddressType) {
    /**
     * Allocate IPv4 addresses
     */
    IpAddressType["IPV4"] = "ipv4";
    /**
     * Allocate both IPv4 and IPv6 addresses
     */
    IpAddressType["DUAL_STACK"] = "dualstack";
})(IpAddressType = exports.IpAddressType || (exports.IpAddressType = {}));
/**
 * Backend protocol for network load balancers and health checks
 */
var Protocol;
(function (Protocol) {
    /**
     * HTTP (ALB health checks and NLB health checks)
     */
    Protocol["HTTP"] = "HTTP";
    /**
     * HTTPS (ALB health checks and NLB health checks)
     */
    Protocol["HTTPS"] = "HTTPS";
    /**
     * TCP (NLB, NLB health checks)
     */
    Protocol["TCP"] = "TCP";
    /**
     * TLS (NLB)
     */
    Protocol["TLS"] = "TLS";
    /**
     * UDP (NLB)
     */
    Protocol["UDP"] = "UDP";
    /**
     * Listen to both TCP and UDP on the same port (NLB)
     */
    Protocol["TCP_UDP"] = "TCP_UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Load balancing protocol for application load balancers
 */
var ApplicationProtocol;
(function (ApplicationProtocol) {
    /**
     * HTTP
     */
    ApplicationProtocol["HTTP"] = "HTTP";
    /**
     * HTTPS
     */
    ApplicationProtocol["HTTPS"] = "HTTPS";
})(ApplicationProtocol = exports.ApplicationProtocol || (exports.ApplicationProtocol = {}));
/**
 * Elastic Load Balancing provides the following security policies for Application Load Balancers
 *
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 *
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 *
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 */
var SslPolicy;
(function (SslPolicy) {
    /**
     * The recommended security policy
     */
    SslPolicy["RECOMMENDED"] = "ELBSecurityPolicy-2016-08";
    /**
     * Strong forward secrecy ciphers and TLS1.2 only
     */
    SslPolicy["FORWARD_SECRECY_TLS12_RES"] = "ELBSecurityPolicy-FS-1-2-Res-2019-08";
    /**
     * Forward secrecy ciphers and TLS1.2 only
     */
    SslPolicy["FORWARD_SECRECY_TLS12"] = "ELBSecurityPolicy-FS-1-2-2019-08";
    /**
     * Forward secrecy ciphers only with TLS1.1 and higher
     */
    SslPolicy["FORWARD_SECRECY_TLS11"] = "ELBSecurityPolicy-FS-1-1-2019-08";
    /**
     * Forward secrecy ciphers only
     */
    SslPolicy["FORWARD_SECRECY"] = "ELBSecurityPolicy-FS-2018-06";
    /**
     * TLS1.2 only and no SHA ciphers
     */
    SslPolicy["TLS12"] = "ELBSecurityPolicy-TLS-1-2-2017-01";
    /**
     * TLS1.2 only with all ciphers
     */
    SslPolicy["TLS12_EXT"] = "ELBSecurityPolicy-TLS-1-2-Ext-2018-06";
    /**
     * TLS1.1 and higher with all ciphers
     */
    SslPolicy["TLS11"] = "ELBSecurityPolicy-TLS-1-1-2017-01";
    /**
     * Support for DES-CBC3-SHA
     *
     * Do not use this security policy unless you must support a legacy client
     * that requires the DES-CBC3-SHA cipher, which is a weak cipher.
     */
    SslPolicy["LEGACY"] = "ELBSecurityPolicy-TLS-1-0-2015-04";
})(SslPolicy = exports.SslPolicy || (exports.SslPolicy = {}));
/**
 * How to interpret the load balancing target identifiers
 */
var TargetType;
(function (TargetType) {
    /**
     * Targets identified by instance ID
     */
    TargetType["INSTANCE"] = "instance";
    /**
     * Targets identified by IP address
     */
    TargetType["IP"] = "ip";
    /**
     * Target is a single Lambda Function
     */
    TargetType["LAMBDA"] = "lambda";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
//# sourceMappingURL=data:application/json;base64,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